package uk.ac.starlink.table.formats;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.DataSource;

public class TwoMassPscTableBuilder implements TableBuilder {

    public boolean canImport( DataFlavor flavor ) {
        return false;
    }

    public String getFormatName() {
        return "2mass-psc";
    }

    public StarTable makeStarTable( DataSource datsrc, boolean wantRandom,
                                    StoragePolicy storagePolicy )
            throws IOException {
        URL schema = getClass().getResource( "twomass_psc_schema" );
        if ( schema == null ) {
            throw new IOException( "No schema found" );
        }
        else {
            return new PostgresAsciiStarTable( datsrc, schema );
        }
    }

    public void streamStarTable( InputStream in, TableSink sink,
                                 String pos ) {
        throw new UnsupportedOperationException();
    }
}
