/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.PrintStream;
import java.util.Arrays;
import uk.ac.starlink.ttools.filter.ProcessingFilter;
import uk.ac.starlink.ttools.filter.StepFactory;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class FilterDoc {
    private final PrintStream out_;

    private FilterDoc(PrintStream out) {
        this.out_ = out;
    }

    private void write() throws LoadException {
        ObjectFactory<ProcessingFilter> stepFact = StepFactory.getInstance().getFilterFactory();
        Object[] fnames = stepFact.getNickNames();
        Arrays.sort(fnames);
        for (int i = 0; i < fnames.length; ++i) {
            Object name = fnames[i];
            ProcessingFilter filter = (ProcessingFilter)stepFact.createObject((String)name);
            this.out_.println("<subsubsect id=\"" + (String)name + "\">");
            this.out_.println("<subhead><title><code>" + (String)name + "</code></title></subhead>");
            this.out_.print("<p>");
            this.out_.println("<strong>Usage:</strong>");
            this.out_.print("<verbatim>   " + (String)name);
            String pad = "   " + ((String)name).replaceAll(".", " ");
            String usage = filter.getUsage();
            if (usage != null) {
                this.out_.print(" " + usage.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "\n " + pad));
            }
            this.out_.print("</verbatim>");
            this.out_.print("</p>");
            this.out_.println();
            String descrip = filter.getDescription();
            if (descrip == null) {
                throw new IllegalArgumentException("No description for filter " + (String)name);
            }
            this.out_.print(descrip);
            this.out_.println("</subsubsect>");
            this.out_.println();
        }
    }

    public static void main(String[] args) throws LoadException {
        new FilterDoc(System.out).write();
    }
}

