/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.InvokeUtils;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.build.UsageWriter;
import uk.ac.starlink.ttools.filter.ProcessingFilter;
import uk.ac.starlink.ttools.filter.StepFactory;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.AbstractInputTableParameter;
import uk.ac.starlink.ttools.task.Calc;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.InputTablesParameter;
import uk.ac.starlink.ttools.task.MapEnvironment;
import uk.ac.starlink.ttools.task.MultiOutputFormatParameter;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.OutputModeParameter;
import uk.ac.starlink.ttools.task.OutputTableParameter;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class JyStilts {
    private final Stilts stilts_;
    private final Formatter formatter_;
    private final Map clazzMap_;
    private final String[] imports_;
    private final Map paramAliasMap_;
    private static final String paramAliasDictName_ = "_param_alias_dict";
    private static final Class[] IMPORT_CLASSES = new Class[]{ByteArrayInputStream.class, OutputStream.class, Class.class, System.class, Array.class, ArrayList.class, ColumnInfo.class, MultiStarTableWriter.class, StarTable.class, StarTableFactory.class, StarTableOutput.class, TableSequence.class, Tables.class, WrapperStarTable.class, WrapperRowSequence.class, InvokeUtils.class, Stilts.class, StepFactory.class, MapEnvironment.class, DataSource.class};

    public JyStilts(Stilts stilts) {
        this.stilts_ = stilts;
        this.formatter_ = new Formatter();
        this.clazzMap_ = new HashMap();
        Class[] clazzes = IMPORT_CLASSES;
        ArrayList<String> importList = new ArrayList<String>();
        importList.add("import jarray.array");
        for (int ic = 0; ic < clazzes.length; ++ic) {
            String clazzName;
            Class clazz = clazzes[ic];
            String importName = clazzName = clazz.getName();
            if (this.clazzMap_.containsValue(importName = importName.replaceFirst(".*\\.", "_"))) {
                throw new RuntimeException("import name clash: " + importName);
            }
            this.clazzMap_.put(clazz, importName);
            String line = "import " + clazzName;
            if (!importName.equals(clazzName)) {
                line = line + " as " + importName;
            }
            importList.add(line);
        }
        Class[] calcClazzes = JELUtils.getStaticClasses().toArray(new Class[0]);
        for (int ic = 0; ic < calcClazzes.length; ++ic) {
            String clazzName;
            Class clazz = calcClazzes[ic];
            String importName = clazzName = clazz.getName();
            if (this.clazzMap_.containsValue(importName = importName.replaceFirst(".*\\.", ""))) {
                throw new RuntimeException("import name clash: " + importName);
            }
            String line = "import " + clazzName + " as " + importName;
            importList.add(line);
        }
        this.imports_ = importList.toArray(new String[0]);
        this.paramAliasMap_ = new HashMap();
        this.paramAliasMap_.put("in", "in_");
    }

    private String[] header() {
        return new String[]{"# This module auto-generated by java class " + this.getClass().getName() + ".", "", "'''Provides access to STILTS commands.", "", "See the manual, http://www.starlink.ac.uk/stilts/sun256/", "for tutorial and full usage information.", "'''", "", "from __future__ import generators", "__author__ = 'Mark Taylor'", ""};
    }

    private String[] imports() {
        return this.imports_;
    }

    private String getImportName(Class clazz) {
        String cname = (String)this.clazzMap_.get(clazz);
        if (cname == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " not imported");
        }
        return cname;
    }

    private String[] defUtils() {
        ArrayList<String> lineList = new ArrayList<String>(Arrays.asList("class RandomJyStarTable(JyStarTable):", "    '''Extends the JyStarTable wrapper class for random access.", "", "    Instances of this class can be subscripted.", "    '''", "    def __init__(self, base_table):", "        JyStarTable.__init__(self, base_table)", "    def __len__(self):", "        return int(self.getRowCount())", "    def __getitem__(self, key):", "        if type(key) is type(slice(0)):", "            return [self._create_row(self.getRow(irow))", "                    for irow in _slice_range(key, len(self))]", "        elif key < 0:", "            irow = self.getRowCount() + key", "            return self._create_row(self.getRow(irow))", "        else:", "            return self._create_row(self.getRow(key))", "    def __str__(self):", "        return str(self.getName()) + '(' + str(self.getRowCount()) + 'x' + str(self.getColumnCount()) + ')'", "    def coldata(self, key):", "        '''Returns a sequence of all the values in a given column.'''", "        icol = self._column_index(key)", "        return _Coldata(self, icol)", "", "class _Coldata(object):", "    def __init__(self, table, icol):", "        self.table = table", "        self.icol = icol", "        self.nrow = len(table)", "    def __iter__(self):", "        rowseq = self.table.getRowSequence()", "        while rowseq.next():", "            yield rowseq.getCell(self.icol)", "    def __len__(self):", "        return self.nrow", "    def __getitem__(self, key):", "        if type(key) is type(slice(0)):", "            return [self.table.getCell(irow, self.icol)", "                    for irow in _slice_range(key, self.nrow)]", "        elif key < 0:", "            irow = self.nrow + key", "            return self.table.getCell(irow, self.icol)", "        else:", "            return self.table.getCell(key, self.icol)", "", "class _JyColumnInfo(" + this.getImportName(ColumnInfo.class) + "):", "    def __init__(self, base):", "        " + this.getImportName(ColumnInfo.class) + ".__init__(self, base)", "    def __str__(self):", "        return self.getName()", "", "class _JyRow(tuple):", "    def __init__(self, array):", "        tuple.__init__(self, array)", "    def __getitem__(self, key):", "        icol = self.table._column_index(key)", "        return tuple.__getitem__(self, icol)", "", "class _JyEnvironment(" + this.getImportName(MapEnvironment.class) + "):", "    def __init__(self, grab_output=False):", "        " + this.getImportName(MapEnvironment.class) + ".__init__(self)", "        if grab_output:", "            self._out = " + this.getImportName(MapEnvironment.class) + ".getOutputStream(self)", "        else:", "            self._out = " + this.getImportName(System.class) + ".out", "        self._err = " + this.getImportName(System.class) + ".err", "        self._used = {}", "    def getOutputStream(self):", "        return self._out", "    def getErrorStream(self):", "        return self._err", "    def acquireValue(self, param):", "        " + this.getImportName(MapEnvironment.class) + ".acquireValue(self, param)", "        self._used[param.getName()] = True", "    def getUnusedArgs(self):", "        return filter(lambda n: n not in self._used, self.getNames())", "", "def _check_unused_args(env):", "    names = env.getUnusedArgs()", "    if (names):", "        raise SyntaxError('Unused STILTS parameters %s' % str(tuple([str(n) for n in names])))", "", "def _check_multi_handler(handler):", "    if not " + this.getImportName(Class.class) + ".forName('" + MultiStarTableWriter.class.getName() + "')" + ".isInstance(handler):", "        raise TypeError('Handler %s cannot write multiple tables' % handler.getFormatName())", "", "def _slice_range(slice, leng):", "    start = slice.start", "    stop = slice.stop", "    step = slice.step", "    if start is None:", "        start = 0", "    elif start < 0:", "        start += leng", "    if stop is None:", "        stop = leng", "    elif stop < 0:", "        stop += leng", "    if step is None:", "        return xrange(start, stop)", "    else:", "        return xrange(start, stop, step)", "", "class _JyOutputStream(" + this.getImportName(OutputStream.class) + "):", "    def __init__(self, file):", "        self._file = file", "    def write(self, *args):", "        narg = len(args)", "        if narg is 1:", "            arg0 = args[0]", "            if type(arg0) is type(1):", "                pyarg = chr(arg0)", "            else:", "                pyarg = arg0", "        elif narg is 3:", "            buf, off, leng = args", "            pyarg = buf[off:off + leng].tostring()", "        else:", "            raise SyntaxError('%d args?' % narg)", "        self._file.write(pyarg)", "    def close(self):", "        self._file.close()", "    def flush(self):", "        self._file.flush()", "", "class _JyTableSequence(" + this.getImportName(TableSequence.class) + "):", "    def __init__(self, seq):", "        self._iter = iter(seq)", "    def nextTable(self):", "        try:", "            return self._iter.next()", "        except StopIteration:", "            return None", "", "class _JyDataSource(" + this.getImportName(DataSource.class) + "):", "    def __init__(self, file):", "        buf = file.read(-1)", "        self._buffer = jarray.array(buf, 'b')", "        if hasattr(file, 'name'):", "            self.setName(file.name)", "    def getRawInputStream(self):", "        return " + this.getImportName(ByteArrayInputStream.class) + "(self._buffer)", "def import_star_table(table):", "    '''Imports a StarTable instance for use with JyStilts.", "", "    This factory function takes an instance of the Java class", "    " + StarTable.class.getName(), "    and returns an instance of a wrapper subclass which has some", "    decorations useful in a python environment.", "    This includes stilts cmd_* and mode_* methods, as well as", "    python-friendly standard methods to make it behave as an", "    iterable, and where possible a container, of data rows,", "    and overloaded addition and multiplication operators", "    with the semantics of concatenation.", "    '''", "    if table.isRandom():", "        return RandomJyStarTable(table)", "    else:", "        return JyStarTable(table)", "", "def _map_env_value(pval):", "    if pval is None:", "        return None", "    elif pval is True:", "        return 'true'", "    elif pval is False:", "        return 'false'", "    elif isinstance(pval, " + this.getImportName(StarTable.class) + "):", "        return pval", "    elif _is_container(pval, " + this.getImportName(StarTable.class) + "):", "        return jarray.array(pval, " + this.getImportName(StarTable.class) + ")", "    else:", "        return str(pval)", "", "def _is_container(value, type):", "    try:", "        if len(value) > 0:", "            for item in value:", "                if not isinstance(item, type):", "                    return False", "            return True", "        else:", "            return False", "    except TypeError:", "        return False", "", "_stilts = " + this.getImportName(Stilts.class) + "()", "", this.getImportName(InvokeUtils.class) + ".configureLogging(0, False)", ""));
        lineList.add("_param_alias_dict = {}");
        for (Map.Entry entry : this.paramAliasMap_.entrySet()) {
            lineList.add("_param_alias_dict['" + entry.getKey() + "']='" + entry.getValue() + "'");
        }
        lineList.add("");
        return lineList.toArray(new String[0]);
    }

    private String[] defVersionCheck() {
        String[] stringArray = new String[5];
        stringArray[0] = "_stilts_lib_version = _stilts.getVersion()";
        JyStilts jyStilts = this;
        stringArray[1] = "_stilts_script_version = '" + jyStilts.stilts_.getVersion() + "'";
        stringArray[2] = "if _stilts_lib_version != _stilts_script_version:";
        stringArray[3] = "    print('WARNING: STILTS script/class library version mismatch (' + _stilts_script_version + '/' + _stilts_lib_version + ').')";
        stringArray[4] = "    print('         This may or may not cause trouble.')";
        return stringArray;
    }

    private String[] defTableClass(String cname) throws LoadException, SAXException {
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("class " + cname + "(" + this.getImportName(WrapperStarTable.class) + "):");
        lineList.add("    '''StarTable wrapper class for use within Jython.");
        lineList.add("");
        lineList.add("Decorates a " + StarTable.class.getName());
        lineList.add("java object with methods for use within jython.");
        lineList.add("These include special bound functions to make it an");
        lineList.add("iterable object (with items which are table rows),");
        lineList.add("arithmetic + and * overloads for concatenation,");
        lineList.add("a write method for table viewing or output,");
        lineList.add("and methods representing STILTS filter functionality,");
        lineList.add("namely cmd_* methods for filters and mode_* methods");
        lineList.add("for output modes.");
        lineList.add("");
        lineList.add("As a general rule, any StarTable object which is");
        lineList.add("intented for use by JyStilts program code should be");
        lineList.add("wrapped in an instance of this class.");
        lineList.add("    '''");
        lineList.add("    def __init__(self, base_table):");
        lineList.add("        " + this.getImportName(WrapperStarTable.class) + ".__init__(self, base_table)");
        lineList.add("    def __iter__(self):");
        lineList.add("        rowseq = self.getRowSequence()");
        lineList.add("        while rowseq.next():");
        lineList.add("            yield self._create_row(rowseq.getRow())");
        lineList.add("    def __str__(self):");
        lineList.add("        return '%s (?x%d)' % (self.getName(), self.getColumnCount())");
        lineList.add("    def __add__(self, other):");
        lineList.add("        return tcat([self, other])");
        lineList.add("    def __mul__(self, count):");
        lineList.add("        return tcat([self] * count)");
        lineList.add("    def __rmul__(self, count):");
        lineList.add("        return tcat([self] * count)");
        lineList.add("    def columns(self):");
        lineList.add("        '''Returns a tuple of ColumnInfo objects describing the columns of this table.'''");
        lineList.add("        if hasattr(self, '_columns'):");
        lineList.add("            return self._columns");
        lineList.add("        else:");
        lineList.add("            col_list = []");
        lineList.add("            for i in xrange(self.getColumnCount()):");
        lineList.add("                col_list.append(_JyColumnInfo(self.getColumnInfo(i)))");
        lineList.add("            self._columns = tuple(col_list)");
        lineList.add("            return self.columns()");
        lineList.add("    def parameters(self):");
        lineList.add("        '''");
        lineList.add("Returns a mapping of table parameter names to values.");
        lineList.add("");
        lineList.add("This does not provide all the information about the parameters,");
        lineList.add("for instance units and UCDs are not included.");
        lineList.add("For more detail, use the relevant StarTable methods.");
        lineList.add("Currently, this is not a live list, in the sense that changing");
        lineList.add("the returned dictionary will not affect the table parameter values.");
        lineList.add("        '''");
        lineList.add("        if hasattr(self, '_parameters'):");
        lineList.add("            return self._parameters");
        lineList.add("        else:");
        lineList.add("            params = {}");
        lineList.add("            for p in self.getParameters():");
        lineList.add("                params[p.getInfo().getName()] = p.getValue()");
        lineList.add("            self._parameters = params");
        lineList.add("            return self.parameters()");
        lineList.add("    def coldata(self, key):");
        lineList.add("        '''Returns a sequence of all the values in a given column.'''");
        lineList.add("        icol = self._column_index(key)");
        lineList.add("        rowseq = self.getRowSequence()");
        lineList.add("        while rowseq.next():");
        lineList.add("            yield rowseq.getCell(icol)");
        lineList.add("    def count_rows(self):");
        lineList.add("        '''Returns the number of rows in this table.");
        lineList.add("        For random access tables it calls getRowCount");
        lineList.add("        which returns the value directly.");
        lineList.add("        For non-random tables it may have to iterate over the rows.");
        lineList.add("        That could be slow, though it should be much faster than iterating");
        lineList.add("        over this table as an iterable itself, since the cell data");
        lineList.add("        does not need to be made available.'''");
        lineList.add("        nrow = self.getRowCount();");
        lineList.add("        if nrow >= 0:");
        lineList.add("            return nrow");
        lineList.add("        else:");
        lineList.add("            nr = 0");
        lineList.add("            rseq = self.getRowSequence()");
        lineList.add("            while rseq.next():");
        lineList.add("                nr += 1");
        lineList.add("            return nr");
        lineList.add("    def _create_row(self, array):");
        lineList.add("        row = _JyRow(array)");
        lineList.add("        row.table = self");
        lineList.add("        return row");
        lineList.add("    def _column_index(self, key):");
        lineList.add("        if type(key) is type(1):");
        lineList.add("            if key >= 0:");
        lineList.add("                return key");
        lineList.add("            else:");
        lineList.add("                return key + self.getColumnCount()");
        lineList.add("        if hasattr(self, '_colmap'):");
        lineList.add("            return self._colmap[key]");
        lineList.add("        else:");
        lineList.add("            colmap = {}");
        lineList.add("            for ic, col in enumerate(self.columns()):");
        lineList.add("                if not col in colmap:");
        lineList.add("                    colmap[col] = ic");
        lineList.add("                colname = col.getName()");
        lineList.add("                if not colname in colmap:");
        lineList.add("                    colmap[colname] = ic");
        lineList.add("            self._colmap = colmap");
        lineList.add("            return self._column_index(key)");
        String[] writeLines = this.defWrite("write", true);
        lineList.addAll(Arrays.asList(this.prefixLines("    ", writeLines)));
        ObjectFactory<ProcessingFilter> filterFactory = StepFactory.getInstance().getFilterFactory();
        String[] filterNames = filterFactory.getNickNames();
        for (int i = 0; i < filterNames.length; ++i) {
            String name = filterNames[i];
            String[] filterLines = this.defCmd("cmd_" + name, name, true);
            lineList.addAll(Arrays.asList(this.prefixLines("    ", filterLines)));
        }
        JyStilts jyStilts = this;
        ObjectFactory<ProcessingMode> modeFactory = jyStilts.stilts_.getModeFactory();
        String[] modeNames = modeFactory.getNickNames();
        for (int i = 0; i < modeNames.length; ++i) {
            String name = modeNames[i];
            String[] modeLines = this.defMode("mode_" + name, name, true);
            lineList.addAll(Arrays.asList(this.prefixLines("    ", modeLines)));
        }
        return lineList.toArray(new String[0]);
    }

    private String[] defRead(String fname) {
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("def " + fname + "(location, fmt='(auto)', random=False):");
        lineList.add("    '''Reads a table from a filename, URL or python file object.");
        lineList.add("");
        lineList.add("    The random argument determines whether random access is required");
        lineList.add("    for the table.");
        lineList.add("    Setting it true may improve efficiency, but perhaps at the cost");
        lineList.add("    of memory usage and load time for large tables.");
        lineList.add("");
        lineList.add("    The fmt argument must be supplied if the table format cannot");
        lineList.add("    be auto-detected.");
        lineList.add("");
        lineList.add("    In general supplying a filename is preferred; the current implementation");
        lineList.add("    may be much more expensive on memory if a python file object is used.");
        lineList.add("");
        String fmtInfo = new InputFormatParameter("location").getExtraUsage(new MapEnvironment());
        lineList.addAll(Arrays.asList(this.prefixLines(" ", fmtInfo)));
        lineList.add("");
        lineList.add("    The result of the function is a JyStilts table object.");
        lineList.add("    '''");
        lineList.add("    fact = " + this.getImportName(StarTableFactory.class) + "(random)");
        lineList.add("    if hasattr(location, 'read'):");
        lineList.add("        datsrc = _JyDataSource(location)");
        lineList.add("        table = fact.makeStarTable(datsrc, fmt)");
        lineList.add("    else:");
        lineList.add("        table = fact.makeStarTable(location, fmt)");
        lineList.add("    return import_star_table(table)");
        return lineList.toArray(new String[0]);
    }

    private String[] defReads(String fname) {
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("def " + fname + "(location, fmt='(auto)', random=False):");
        lineList.add("    '''Reads multiple tables from a filename, URL or python file object.");
        lineList.add("");
        lineList.add("    It only makes sense to use this function rather than tread() if the");
        lineList.add("    format is, or may be, one which can contain multiple tables.");
        lineList.add("    Generally this means VOTable or FITS or one of their variants.");
        lineList.add("");
        lineList.add("    The random argument determines whether random access is required");
        lineList.add("    for the table.");
        lineList.add("    Setting it true may improve efficiency, but perhaps at the cost");
        lineList.add("    of memory usage and load time for large tables.");
        lineList.add("");
        lineList.add("    The fmt argument must be supplied if the table format cannot");
        lineList.add("    be auto-detected.");
        lineList.add("");
        lineList.add("    In general supplying a filename is preferred; the current implementation");
        lineList.add("    may be much more expensive on memory if a python file object is used.");
        lineList.add("");
        lineList.add("    The result of the function is a list of JyStilts table objects.");
        lineList.add("    '''");
        lineList.add("    fact = " + this.getImportName(StarTableFactory.class) + "(random)");
        lineList.add("    if hasattr(location, 'read'):");
        lineList.add("        datsrc = _JyDataSource(location)");
        lineList.add("    else:");
        lineList.add("        datsrc = " + this.getImportName(DataSource.class) + ".makeDataSource(location)");
        lineList.add("    tseq = fact.makeStarTables(datsrc, fmt)");
        lineList.add("    tables = " + this.getImportName(Tables.class) + ".tableArray(tseq)");
        lineList.add("    return map(import_star_table, tables)");
        return lineList.toArray(new String[0]);
    }

    private String[] defWrite(String fname, boolean isBound) {
        String tArgName = isBound ? "self" : "table";
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("def " + fname + "(" + tArgName + ", location=None, fmt='(auto)'):");
        lineList.add("    '''Writes table to a file.");
        lineList.add("");
        lineList.add("    The location parameter may give a filename or a");
        lineList.add("    python file object open for writing.");
        lineList.add("    if it is not supplied, standard output is used.");
        lineList.add("");
        lineList.add("    The fmt parameter specifies output format.");
        String fmtInfo = new OutputFormatParameter("out").getExtraUsage(new MapEnvironment());
        lineList.addAll(Arrays.asList(this.prefixLines(" ", fmtInfo)));
        lineList.add("    '''");
        lineList.add("    sto = " + this.getImportName(StarTableOutput.class) + "()");
        lineList.add("    if hasattr(location, 'write') and hasattr(location, 'flush'):");
        lineList.add("        ostrm = _JyOutputStream(location)");
        lineList.add("        name = getattr(location, 'name', None)");
        lineList.add("        handler = sto.getHandler(fmt, name)");
        lineList.add("        sto.writeStarTable(" + tArgName + ", ostrm, handler)");
        lineList.add("    else:");
        lineList.add("        if location is None:");
        lineList.add("            location = '-'");
        lineList.add("        sto.writeStarTable(" + tArgName + ", location, fmt)");
        return lineList.toArray(new String[0]);
    }

    private String[] defWrites(String fname) {
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("def " + fname + "(tables, location=None, fmt='(auto)'):");
        lineList.add("    '''Writes a sequence of tables to a single container file.");
        lineList.add("");
        lineList.add("    The tables parameter gives an iterable over JyStilts table objects");
        lineList.add("    The location parameter may give a filename or a python file object");
        lineList.add("    open for writing.  If it is not supplied,  standard output is used.");
        lineList.add("");
        lineList.add("    The fmt parameter specifies output format.");
        lineList.add("    Note that not all formats can write multiple tables;");
        lineList.add("    an error will result if an attempt is made to write");
        lineList.add("    multiple tables to a single-table only format.");
        String fmtInfo = new MultiOutputFormatParameter("out").getExtraUsage(new MapEnvironment());
        lineList.addAll(Arrays.asList(this.prefixLines(" ", fmtInfo)));
        lineList.add("    '''");
        lineList.add("    sto = " + this.getImportName(StarTableOutput.class) + "()");
        lineList.add("    tseq = _JyTableSequence(tables)");
        lineList.add("    if hasattr(location, 'write') and hasattr(location, 'flush'):");
        lineList.add("        ostrm = _JyOutputStream(location)");
        lineList.add("        name = getattr(location, 'name', None)");
        lineList.add("        handler = sto.getHandler(fmt, name)");
        lineList.add("        _check_multi_handler(handler)");
        lineList.add("        handler.writeStarTables(tseq, ostrm)");
        lineList.add("    else:");
        lineList.add("        if location is None:");
        lineList.add("            location = '-'");
        lineList.add("        handler = sto.getHandler(fmt, location)");
        lineList.add("        _check_multi_handler(handler)");
        lineList.add("        handler.writeStarTables(tseq, location, sto)");
        return lineList.toArray(new String[0]);
    }

    private String[] defFilter(String fname) {
        return new String[]{"def " + fname + "(table, cmd):", "    '''Applies a filter operation to a table and returns the result.", "    In most cases, it's better to use one of the cmd_* functions.", "    '''", "    step = " + this.getImportName(StepFactory.class) + ".getInstance().createStep(cmd)", "    return import_star_table(step.wrap(table))"};
    }

    private String[] defCmd(String fname, String filterNickName, boolean isBound) throws LoadException, SAXException {
        ProcessingFilter filter = (ProcessingFilter)StepFactory.getInstance().getFilterFactory().createObject(filterNickName);
        String usage = filter.getUsage();
        boolean hasUsage = usage != null && usage.trim().length() > 0;
        String tArgName = isBound ? "self" : "table";
        ArrayList<String> lineList = new ArrayList<String>();
        if (hasUsage) {
            lineList.add("def " + fname + "(" + tArgName + ", *args):");
        } else {
            lineList.add("def " + fname + "(" + tArgName + "):");
        }
        lineList.add("    '''\\");
        lineList.addAll(Arrays.asList(this.formatXml(filter.getDescription())));
        lineList.add("");
        lineList.add("The filtered table is returned.");
        if (hasUsage) {
            lineList.add("");
            lineList.add("args is a list with words as elements:");
            lineList.addAll(Arrays.asList(this.prefixLines("    ", filter.getUsage())));
        }
        lineList.add("'''");
        lineList.add("    pfilt = " + this.getImportName(StepFactory.class) + ".getInstance()" + ".getFilterFactory()" + ".createObject(\"" + filterNickName + "\")");
        if (hasUsage) {
            lineList.add("    sargs = [str(a) for a in args]");
        } else {
            lineList.add("    sargs = []");
        }
        lineList.add("    argList = " + this.getImportName(ArrayList.class) + "(sargs)");
        lineList.add("    step = pfilt.createStep(argList.iterator())");
        lineList.add("    return import_star_table(step.wrap(" + tArgName + "))");
        return lineList.toArray(new String[0]);
    }

    private String[] defMode(String fname, String modeNickName, boolean isBound) throws LoadException, SAXException {
        JyStilts jyStilts = this;
        ProcessingMode mode = (ProcessingMode)jyStilts.stilts_.getModeFactory().createObject(modeNickName);
        Parameter[] params = mode.getAssociatedParameters();
        ArrayList<String> lineList = new ArrayList<String>();
        ArrayList<Arg> mandArgList = new ArrayList<Arg>();
        ArrayList<Arg> optArgList = new ArrayList<Arg>();
        for (int ip = 0; ip < params.length; ++ip) {
            Parameter param = params[ip];
            String name = param.getName();
            if (this.paramAliasMap_.containsKey(name)) {
                param.setName((String)this.paramAliasMap_.get(name));
            }
            String pname = param.getName();
            String sdflt = this.getDefaultString(param);
            if (sdflt == null) {
                mandArgList.add(new Arg(param, pname));
                continue;
            }
            optArgList.add(new Arg(param, pname + "=" + sdflt));
        }
        String tArgName = isBound ? "self" : "table";
        ArrayList<Arg> argList = new ArrayList<Arg>();
        argList.addAll(mandArgList);
        argList.addAll(optArgList);
        StringBuffer sbuf = new StringBuffer().append("def ").append(fname).append("(").append(tArgName);
        for (Arg arg : argList) {
            sbuf.append(", ");
            sbuf.append(arg.formalArg_);
        }
        sbuf.append("):");
        lineList.add(sbuf.toString());
        lineList.add("    '''\\");
        lineList.addAll(Arrays.asList(this.formatXml(mode.getDescription())));
        lineList.addAll(Arrays.asList(this.getParamDocs(params)));
        lineList.add("'''");
        lineList.add("    env = _JyEnvironment()");
        for (Arg arg : argList) {
            Parameter param = arg.param_;
            String name = param.getName();
            lineList.add("    env.setValue('" + name + "', " + "_map_env_value(" + name + "))");
        }
        lineList.add("    mode = _stilts.getModeFactory().createObject('" + modeNickName + "')");
        lineList.add("    consumer = mode.createConsumer(env)");
        lineList.add("    _check_unused_args(env)");
        lineList.add("    consumer.consume(" + tArgName + ")");
        return lineList.toArray(new String[0]);
    }

    private String[] defTask(String fname, String taskNickName) throws LoadException, SAXException {
        JyStilts jyStilts = this;
        Task task = (Task)jyStilts.stilts_.getTaskFactory().createObject(taskNickName);
        boolean isProducer = task instanceof ConsumerTask && ((ConsumerTask)task).getOutputMode() instanceof ChoiceMode;
        boolean returnOutput = task instanceof Calc;
        ArrayList<String> lineList = new ArrayList<String>();
        ArrayList<Parameter> paramList = new ArrayList<Parameter>(Arrays.asList(task.getParameters()));
        ArrayList<BooleanParameter> shunnedList = new ArrayList<BooleanParameter>();
        Iterator it = paramList.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            if (param instanceof AbstractInputTableParameter) {
                shunnedList.add(((AbstractInputTableParameter)param).getStreamParameter());
            }
            if (param instanceof InputTableParameter) {
                param.setDescription("<p>Input table.</p>");
            } else if (param instanceof InputTablesParameter) {
                param.setDescription("<p>Array of input tables.</p>");
            }
            if (!(param instanceof FilterParameter) && !(param instanceof InputFormatParameter) && !(param instanceof OutputFormatParameter) && !(param instanceof OutputTableParameter) && !(param instanceof OutputModeParameter)) continue;
            it.remove();
        }
        paramList.removeAll(shunnedList);
        Parameter[] params = paramList.toArray(new Parameter[0]);
        ArrayList<Arg> mandArgList = new ArrayList<Arg>();
        ArrayList<Arg> optArgList = new ArrayList<Arg>();
        int iPos = 0;
        for (int ip = 0; ip < params.length; ++ip) {
            Parameter param = params[ip];
            String name = param.getName();
            if (this.paramAliasMap_.containsKey(name)) {
                param.setName((String)this.paramAliasMap_.get(name));
            }
            String pname = param.getName();
            boolean byPos = false;
            int pos = param.getPosition();
            if (pos > 0) {
                assert (pos == ++iPos);
                byPos = true;
            }
            if (!byPos && !this.paramAliasMap_.containsKey(name)) continue;
            String sdflt = this.getDefaultString(param);
            if (sdflt == null) {
                mandArgList.add(new Arg(param, pname));
                continue;
            }
            optArgList.add(new Arg(param, pname + "=" + sdflt));
        }
        ArrayList<Arg> argList = new ArrayList<Arg>();
        argList.addAll(mandArgList);
        argList.addAll(optArgList);
        StringBuffer sbuf = new StringBuffer().append("def ").append(fname).append("(");
        for (Arg arg : argList) {
            sbuf.append(arg.formalArg_).append(", ");
        }
        sbuf.append("**kwargs").append("):");
        lineList.add(sbuf.toString());
        lineList.add("    '''\\");
        lineList.add(task.getPurpose() + ".");
        if (isProducer) {
            lineList.add("");
            lineList.add("The return value is the resulting table.");
        } else if (returnOutput) {
            lineList.add("");
            lineList.add("The return value is the output string.");
        }
        lineList.addAll(Arrays.asList(this.getParamDocs(params)));
        lineList.add("'''");
        lineList.add("    task = _stilts.getTaskFactory().createObject('" + taskNickName + "')");
        lineList.add("    for param in task.getParameters():");
        lineList.add("        pname = param.getName()");
        lineList.add("        if pname in _param_alias_dict:");
        lineList.add("            param.setName(_param_alias_dict[pname])");
        if (returnOutput) {
            lineList.add("    env = _JyEnvironment(grab_output=True)");
        } else {
            lineList.add("    env = _JyEnvironment()");
        }
        for (Arg arg : mandArgList) {
            Parameter param = arg.param_;
            String name = param.getName();
            lineList.add("    env.setValue('" + name + "', " + "_map_env_value(" + name + "))");
        }
        lineList.add("    for kw in kwargs.iteritems():");
        lineList.add("        key = kw[0]");
        lineList.add("        value = kw[1]");
        lineList.add("        env.setValue(key, _map_env_value(value))");
        if (isProducer) {
            lineList.add("    table = task.createProducer(env).getTable()");
            lineList.add("    _check_unused_args(env)");
            lineList.add("    return import_star_table(table)");
        } else {
            lineList.add("    exe = task.createExecutable(env)");
            lineList.add("    _check_unused_args(env)");
            lineList.add("    exe.execute()");
            if (returnOutput) {
                lineList.add("    txt = env.getOutputText()");
                lineList.add("    return str(txt.strip())");
            }
        }
        return lineList.toArray(new String[0]);
    }

    private String getDefaultString(Parameter param) {
        String dflt = param.getStringDefault();
        boolean isDfltNull = dflt == null || dflt.trim().length() == 0;
        boolean nullable = param.isNullPermitted();
        if (nullable || !isDfltNull) {
            if (isDfltNull) {
                return "None";
            }
            if (param instanceof IntegerParameter || param instanceof DoubleParameter) {
                return dflt;
            }
            return "'" + dflt + "'";
        }
        return null;
    }

    private String[] formatXml(String xml) throws SAXException {
        int csub = 8;
        String text = this.formatter_.formatXML(xml, csub);
        ArrayList<String> lineList = new ArrayList<String>();
        Iterator lineIt = JyStilts.lineIterator(text);
        while (lineIt.hasNext()) {
            String line = (String)lineIt.next();
            if (line.trim().length() == 0) {
                lineList.add("");
                continue;
            }
            assert ("        ".equals(line.substring(0, csub)));
            lineList.add(line.substring(csub));
        }
        return lineList.toArray(new String[0]);
    }

    private String[] getParamDocs(Parameter[] params) throws SAXException {
        if (params.length == 0) {
            return new String[0];
        }
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("");
        lineList.add("Parameters:");
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<dl>");
        for (int i = 0; i < params.length; ++i) {
            sbuf.append(UsageWriter.xmlItem(params[i], true));
        }
        sbuf.append("</dl>");
        lineList.addAll(Arrays.asList(this.formatXml(sbuf.toString())));
        return lineList.toArray(new String[0]);
    }

    private String[] prefixLines(String prefix, String text) {
        ArrayList<String> lineList = new ArrayList<String>();
        Iterator lineIt = JyStilts.lineIterator(text);
        while (lineIt.hasNext()) {
            lineList.add(prefix + (String)lineIt.next());
        }
        return lineList.toArray(new String[0]);
    }

    private String[] prefixLines(String prefix, String[] lines) {
        ArrayList<String> lineList = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            lineList.add(prefix + lines[i]);
        }
        return lineList.toArray(new String[0]);
    }

    private void writeLines(String[] lines, Writer writer) throws IOException {
        BufferedWriter bw = new BufferedWriter(writer);
        for (int i = 0; i < lines.length; ++i) {
            bw.write(lines[i]);
            bw.newLine();
        }
        bw.newLine();
        bw.flush();
    }

    public void writeModule(Writer writer) throws IOException, LoadException, SAXException {
        this.writeLines(this.header(), writer);
        this.writeLines(this.imports(), writer);
        this.writeLines(this.defTableClass("JyStarTable"), writer);
        this.writeLines(this.defUtils(), writer);
        this.writeLines(this.defVersionCheck(), writer);
        this.writeLines(this.defRead("tread"), writer);
        this.writeLines(this.defReads("treads"), writer);
        this.writeLines(this.defWrite("twrite", false), writer);
        this.writeLines(this.defWrites("twrites"), writer);
        this.writeLines(this.defFilter("tfilter"), writer);
        JyStilts jyStilts = this;
        ObjectFactory<Task> taskFactory = jyStilts.stilts_.getTaskFactory();
        String[] taskNames = taskFactory.getNickNames();
        for (int i = 0; i < taskNames.length; ++i) {
            String name = taskNames[i];
            String[] taskLines = this.defTask(name, name);
            this.writeLines(taskLines, writer);
        }
        ObjectFactory<ProcessingFilter> filterFactory = StepFactory.getInstance().getFilterFactory();
        String[] filterNames = filterFactory.getNickNames();
        for (int i = 0; i < filterNames.length; ++i) {
            String name = filterNames[i];
            String[] filterLines = this.defCmd("cmd_" + name, name, false);
            this.writeLines(filterLines, writer);
        }
        JyStilts jyStilts2 = this;
        ObjectFactory<ProcessingMode> modeFactory = jyStilts2.stilts_.getModeFactory();
        String[] modeNames = modeFactory.getNickNames();
        for (int i = 0; i < modeNames.length; ++i) {
            String name = modeNames[i];
            String[] modeLines = this.defMode("mode_" + name, name, false);
            this.writeLines(modeLines, writer);
        }
    }

    public static void main(String[] args) throws IOException, LoadException, SAXException {
        Logger.getLogger("uk.ac.starlink.ttools.plot2").setLevel(Level.WARNING);
        new JyStilts(new Stilts()).writeModule(new OutputStreamWriter(new BufferedOutputStream(System.out)));
    }

    private static Iterator lineIterator(final String text) {
        return new Iterator(){
            private int pos_;

            @Override
            public boolean hasNext() {
                return this.pos_ < text.length();
            }

            public Object next() {
                int nextPos = text.indexOf(10, this.pos_);
                if (nextPos < 0) {
                    nextPos = text.length();
                }
                String line = text.substring(this.pos_, nextPos);
                this.pos_ = nextPos + 1;
                return line;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class OutputStreamWriter
    extends Writer {
        private final OutputStream out_;

        OutputStreamWriter(OutputStream out) {
            this.out_ = out;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            byte[] buf = new byte[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = this.toByte(cbuf[off + i]);
            }
            this.out_.write(buf, 0, len);
        }

        @Override
        public void write(int c) throws IOException {
            this.out_.write(this.toByte((char)c));
        }

        @Override
        public void flush() throws IOException {
            this.out_.flush();
        }

        @Override
        public void close() throws IOException {
            this.out_.close();
        }

        private byte toByte(char c) throws IOException {
            if (c >= '\u0000' && c <= '\u007f') {
                return (byte)c;
            }
            if (Character.isSpaceChar(c)) {
                return 32;
            }
            throw new IOException("Non-ASCII character 0x" + Integer.toHexString(c));
        }
    }

    private static class Arg {
        final Parameter param_;
        final String formalArg_;

        Arg(Parameter param, String formalArg) {
            this.param_ = param;
            this.formalArg_ = formalArg;
        }
    }
}

