/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.build.Plot2Example;
import uk.ac.starlink.ttools.build.UsageWriter;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.geom.CubePlotType;
import uk.ac.starlink.ttools.plot2.geom.PlanePlotType;
import uk.ac.starlink.ttools.plot2.geom.SkyPlotType;
import uk.ac.starlink.ttools.plot2.geom.TimePlotType;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.LayerType;
import uk.ac.starlink.ttools.plot2.task.LayerTypeParameter;
import uk.ac.starlink.ttools.plot2.task.ShapeFamilyLayerType;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;

public class LayerTypeDoc {
    private final boolean basicXml_;
    private final String suffix_;
    private final Map<String, String> examplesMap_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.build");

    public LayerTypeDoc(boolean basicXml) {
        this.basicXml_ = basicXml;
        this.suffix_ = "N";
        this.examplesMap_ = Plot2Example.getExamplesXml();
    }

    public String getXmlDoc(LayerType layerType) {
        String exname;
        String exXml;
        String[] posPlaceholderWords;
        String lname = layerType.getName().toLowerCase();
        int npos = layerType.getPositionCount();
        Coord[] extraCoords = layerType.getExtraCoords();
        ConfigKey[] styleKeys = layerType.getStyleKeys();
        PlotType plotType = lname.startsWith("xyz") ? CubePlotType.getInstance() : (lname.startsWith("xy") ? PlanePlotType.getInstance() : (lname.startsWith("sky") ? SkyPlotType.getInstance() : (lname.equals("yerror") ? TimePlotType.getInstance() : null)));
        boolean hasPos = npos > 0;
        boolean hasExtra = extraCoords.length > 0;
        boolean hasStyle = styleKeys.length > 0;
        boolean hasShade = layerType instanceof ShapeFamilyLayerType;
        boolean hasTable = hasPos | hasExtra;
        StringBuffer sbuf = new StringBuffer().append("<subsubsect id='layer-").append(lname).append("'>\n").append("<subhead><title><code>").append(lname).append("</code></title></subhead>\n");
        sbuf.append(layerType.getXmlDescription());
        ArrayList<String> usageWords = new ArrayList<String>();
        ArrayList<Object> paramList = new ArrayList<Object>();
        usageWords.add("layer" + this.suffix_ + "=" + lname);
        if (hasStyle) {
            Parameter[] styleParams = LayerTypeParameter.getLayerConfigParams(styleKeys, this.suffix_, false);
            paramList.addAll(Arrays.asList(styleParams));
            usageWords.addAll(LayerTypeParameter.usageWords(styleParams));
        }
        if (hasShade) {
            ChoiceParameter<ShapeMode> shapeModeParam = ((ShapeFamilyLayerType)layerType).createShapeModeParameter(this.suffix_);
            paramList.add(shapeModeParam);
            usageWords.add(LayerTypeParameter.usageWord(shapeModeParam));
        }
        if (hasPos) {
            if (plotType != null) {
                DataGeom[] geoms = plotType.getPointDataGeoms();
                assert (geoms.length == 1);
                DataGeom geom = geoms[0];
                ArrayList<StringParameter> posParamList = new ArrayList<StringParameter>();
                for (int ipos = 0; ipos < npos; ++ipos) {
                    String string = npos == 1 ? "" : PlotUtil.getIndexSuffix(ipos);
                    for (Coord posCoord : geom.getPosCoords()) {
                        String sfix = string + this.suffix_;
                        for (Input input : posCoord.getInputs()) {
                            posParamList.add(AbstractPlot2Task.createDataParameter(input, sfix, false));
                        }
                    }
                }
                paramList.addAll(posParamList);
                Parameter[] posParams = posParamList.toArray(new Parameter[0]);
                usageWords.addAll(LayerTypeParameter.usageWords(posParams));
                posPlaceholderWords = new String[]{};
            } else {
                posPlaceholderWords = new String[npos];
                for (int ipos = 0; ipos < npos; ++ipos) {
                    String posSuffix = npos == 1 ? "" : PlotUtil.getIndexSuffix(ipos);
                    posPlaceholderWords[ipos] = "<pos-coord-params" + posSuffix + this.suffix_ + ">";
                }
                usageWords.addAll(Arrays.asList(posPlaceholderWords));
            }
        } else {
            posPlaceholderWords = new String[]{};
        }
        if (hasExtra) {
            Parameter[] extraParams = LayerTypeParameter.getCoordParams(extraCoords, this.suffix_, false);
            paramList.addAll(Arrays.asList(extraParams));
            usageWords.addAll(LayerTypeParameter.usageWords(extraParams));
        }
        if (hasTable) {
            Parameter[] tableParams = LayerTypeParameter.getInputParams(this.suffix_);
            paramList.addAll(Arrays.asList(tableParams));
            usageWords.addAll(LayerTypeParameter.usageWords(tableParams));
        }
        sbuf.append("<p>\n").append("<strong>Usage Overview:</strong>\n").append("<verbatim><![CDATA[\n").append(Formatter.formatWords(usageWords, 3)).append("]]></verbatim>\n").append("</p>\n").append("<p>All the parameters listed here\n").append("affect only the relevant layer,\n").append("identified by the suffix\n").append("<code>").append(this.suffix_).append("</code>.\n").append("</p>\n");
        int nppw = posPlaceholderWords.length;
        if (nppw > 0) {
            sbuf.append("<p><dl>\n").append("<dt>Positional Coordinate Parameters:</dt>\n");
            sbuf.append("<dd>").append("<p>The positional coordinates\n");
            for (int i = 0; i < nppw; ++i) {
                if (i > 0) {
                    sbuf.append(", ");
                }
                sbuf.append("<code><![CDATA[").append(posPlaceholderWords[i]).append("]]></code>\n");
            }
            sbuf.append("give ").append(npos == 1 ? "a position " : npos + " positions ").append("for each row of the input table.\n").append("Their form depends on the plot geometry,\n").append("i.e. which plotting command is used.\n").append("For a plane plot ").append("(<ref id='plot2plane'><code>plot2plane</code></ref>)\n").append("the parameters would be\n");
            for (int ipos = 0; ipos < npos; ++ipos) {
                String posSuffix = npos == 1 ? "" : PlotUtil.getIndexSuffix(ipos);
                String sfix = posSuffix + this.suffix_;
                boolean bl = ipos < npos - 1;
                sbuf.append("<code>x").append(sfix).append("</code>").append(bl ? ", " : " and ").append("<code>y").append(sfix).append("</code>").append(bl ? "," : ".").append("\n");
            }
            sbuf.append(PlotUtil.concatLines(new String[]{"The coordinate parameter values are in all cases strings", "interpreted as numeric expressions based on column names.", "These can be column names, fixed values or algebraic", "expressions as described in <ref id='jel'/>.", "</p>"}));
            sbuf.append("</dd>\n").append("</dl>\n").append("</p>\n");
        }
        if ((exXml = this.examplesMap_.get(exname = "layer-" + lname)) != null) {
            sbuf.append("<p>\n").append("<strong>Example:</strong>\n").append("</p>\n").append("<figure>\n").append("<figureimage src='&FIG.plot2-").append(exname).append(";'/>\n").append("</figure>\n").append("<p>").append(exXml).append("</p>\n");
        } else {
            logger_.severe("No example figure for layer type " + lname);
        }
        Collections.sort(paramList, Parameter.BY_NAME);
        if (paramList.size() > 0) {
            sbuf.append("<p><dl>\n");
            for (Parameter parameter : paramList) {
                sbuf.append(UsageWriter.xmlItem(parameter, this.basicXml_)).append("\n");
            }
            sbuf.append("</dl></p>\n");
        }
        sbuf.append("</subsubsect>\n");
        return sbuf.toString();
    }

    public static TypedPlot2Task[] getPlot2Tasks() throws LoadException {
        ArrayList<TypedPlot2Task> plot2Tasks = new ArrayList<TypedPlot2Task>();
        ObjectFactory<Task> taskFact = Stilts.getTaskFactory();
        for (String nickname : taskFact.getNickNames()) {
            Task task = (Task)taskFact.createObject(nickname);
            if (!(task instanceof TypedPlot2Task)) continue;
            plot2Tasks.add((TypedPlot2Task)task);
        }
        return plot2Tasks.toArray(new TypedPlot2Task[0]);
    }

    public static Map<String, LayerType> getLayerTypes(TypedPlot2Task[] tasks) {
        LinkedHashMap<String, LayerType> typeMap = new LinkedHashMap<String, LayerType>();
        for (TypedPlot2Task task : tasks) {
            LayerTypeParameter ltParam = AbstractPlot2Task.createLayerTypeParameter("", task.getPlotContext());
            for (LayerType ltype : (LayerType[])ltParam.getOptions()) {
                String name = ltype.getName();
                if (typeMap.containsKey(name)) continue;
                typeMap.put(ltype.getName(), ltype);
            }
        }
        return typeMap;
    }

    public static String layerTypeRef(LayerType ltype) {
        String ltname = ltype.getName().toLowerCase();
        return new StringBuffer().append("<ref id='layer-").append(ltname).append("' plaintextref='yes'><code>").append(ltname).append("</code></ref>").toString();
    }

    public static void main(String[] args) throws LoadException {
        String usage = new StringBuffer().append("\n   ").append("Usage: ").append(LayerTypeDoc.class.getName()).append(" [-doc]").append(" [-basicxml]").append(" [<layer-name> ...]").append("\n").toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean doc = false;
        boolean basicXml = false;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-doc")) {
                it.remove();
                doc = true;
            }
            if (arg.equals("-basicxml")) {
                it.remove();
                basicXml = true;
            }
            if (!arg.startsWith("-h") && !arg.startsWith("--h")) continue;
            it.remove();
            System.err.println(usage);
            return;
        }
        Map<String, LayerType> typeMap = LayerTypeDoc.getLayerTypes(LayerTypeDoc.getPlot2Tasks());
        if (argList.size() > 0) {
            typeMap.keySet().retainAll(argList);
        }
        PrintStream out = System.out;
        if (doc) {
            out.println("<doc>");
        }
        LayerTypeDoc doccer = new LayerTypeDoc(basicXml);
        for (LayerType ltype : typeMap.values()) {
            out.println(doccer.getXmlDoc(ltype));
        }
        if (doc) {
            out.println("</doc>");
        }
    }
}

