/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class MemberDoclet {
    private final RootDoc root_;
    private final Set packages_ = new HashSet();
    private static final Pattern P_PATTERN = Pattern.compile("\\s*(</*[Pp]>)?\\s+(<[Pp]>)\\s*");
    private static final Map<String, String> TYPE_NAMES = new HashMap<String, String>();

    protected abstract void startClass(ClassDoc var1) throws IOException;

    protected abstract void endClass() throws IOException;

    protected abstract void startMember(MemberDoc var1, String var2, String var3) throws IOException;

    protected abstract void endMember() throws IOException;

    protected abstract void outItem(String var1, String var2) throws IOException;

    protected abstract void outParameters(Parameter[] var1, String[] var2, boolean var3) throws IOException;

    protected abstract void outReturn(Type var1, String var2) throws IOException;

    protected abstract void outExamples(String[] var1) throws IOException;

    protected abstract void outDescription(String var1) throws IOException;

    protected MemberDoclet(RootDoc root) {
        this.root_ = root;
    }

    protected boolean process() throws IOException {
        ClassDoc[] classes = this.root_.classes();
        for (int i = 0; i < classes.length; ++i) {
            ClassDoc clazz = classes[i];
            if (!clazz.isPublic()) continue;
            this.processClass(clazz);
            if (this.packages_.contains(clazz)) continue;
            this.processPackage(clazz.containingPackage());
        }
        return true;
    }

    protected void processPackage(PackageDoc pack) throws IOException {
    }

    protected void processClass(ClassDoc clazz) throws IOException {
        this.startClass(clazz);
        MethodDoc[] methods = clazz.methods();
        for (int i = 0; i < methods.length; ++i) {
            MethodDoc method = methods[i];
            if (!method.isPublic() || !method.isStatic()) continue;
            this.processMethod(method);
        }
        FieldDoc[] fields = clazz.fields();
        for (int i = 0; i < fields.length; ++i) {
            FieldDoc field = fields[i];
            if (!field.isPublic() || !field.isStatic() || !field.isFinal()) continue;
            this.processField(field);
        }
        this.endClass();
    }

    private void processField(FieldDoc field) throws IOException {
        ClassDoc clazz = field.containingClass();
        this.startMember((MemberDoc)field, "Constant", field.name());
        this.outDescription(field.commentText());
        this.outItem("Type", MemberDoclet.typeString(field.type()));
        Object value = field.constantValue();
        if (value != null) {
            this.outItem("Value", value.toString());
        }
        this.endMember();
    }

    private void processMethod(MethodDoc method) throws IOException {
        ClassDoc clazz = method.containingClass();
        boolean isVararg = method.isVarArgs();
        Parameter[] params = method.parameters();
        StringBuffer paramList = new StringBuffer("( ");
        for (int i = 0; i < params.length; ++i) {
            String pname = params[i].name();
            if (i > 0) {
                paramList.append(", ");
            }
            paramList.append(pname);
        }
        if (isVararg) {
            paramList.append(", ...");
        }
        paramList.append(" )");
        ParamTag[] ptags = method.paramTags();
        String[] comments = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            String pname = params[i].name();
            for (int j = 0; j < ptags.length; ++j) {
                if (!pname.equals(ptags[j].parameterName())) continue;
                if (comments[i] == null) {
                    comments[i] = ptags[j].parameterComment();
                    continue;
                }
                MemberDoclet.warning(clazz + "." + method + ": " + "multiple tags for parameter " + pname);
            }
            if (comments[i] != null) continue;
            MemberDoclet.warning(clazz + "." + method + ": " + "no tag for parameter " + pname);
        }
        String retdesc = null;
        boolean isVoid = "void".equals(method.returnType().qualifiedTypeName());
        Tag[] retags = method.tags("return");
        if (!isVoid) {
            if (retags.length != 1) {
                MemberDoclet.warning(clazz + "." + method + ": " + retags.length + " @return tags");
            } else {
                retdesc = retags[0].text();
            }
        }
        Tag[] extags = method.tags("example");
        String[] examples = new String[extags.length];
        for (int i = 0; i < extags.length; ++i) {
            examples[i] = extags[i].text();
        }
        Type rtype = method.returnType();
        this.startMember((MemberDoc)method, "Function", method.name() + paramList);
        this.outDescription(method.commentText());
        this.outParameters(params, comments, isVararg);
        if (!isVoid) {
            this.outReturn(rtype, retdesc);
        }
        if (examples.length > 0) {
            this.outExamples(examples);
        }
        String signature = new StringBuffer().append("<tt>").append(rtype.toString().replaceAll("^.*\\.", "")).append(" ").append(method.name()).append(method.signature().replaceAll("\\w[\\w\\.]*\\.(\\w+)", "$1")).append("</tt>").toString();
        this.outItem("Signature", signature);
        this.endMember();
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static String typeString(Type type) {
        return MemberDoclet.varargTypeString(type, false);
    }

    public static String varargTypeString(Type type, boolean isVararg) {
        String tdim = type.dimension();
        if (isVararg) {
            if (tdim.startsWith("[]")) {
                tdim = tdim.substring(2);
            } else {
                isVararg = false;
            }
        }
        String pre = tdim.replaceAll("\\[\\]", "array of ");
        String post = isVararg ? ", one or more" : "";
        String typetxt = TYPE_NAMES.get(type.qualifiedTypeName());
        if (typetxt == null) {
            typetxt = type.typeName();
        }
        return pre + typetxt + post;
    }

    public static String pWrap(String text) {
        String[] params = P_PATTERN.split(text);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            sbuf.append("<p>" + params[i] + "</p>\n");
        }
        return sbuf.toString();
    }

    public static void warning(String msg) {
        System.err.println(msg);
    }

    static {
        TYPE_NAMES.put(Byte.TYPE.getName(), "byte");
        TYPE_NAMES.put(Short.TYPE.getName(), "short integer");
        TYPE_NAMES.put(Integer.TYPE.getName(), "integer");
        TYPE_NAMES.put(Long.TYPE.getName(), "long integer");
        TYPE_NAMES.put(Float.TYPE.getName(), "floating point");
        TYPE_NAMES.put(Double.TYPE.getName(), "floating point");
        TYPE_NAMES.put(Byte.class.getName(), "byte");
        TYPE_NAMES.put(Short.class.getName(), "short integer");
        TYPE_NAMES.put(Integer.class.getName(), "integer");
        TYPE_NAMES.put(Long.class.getName(), "long integer");
        TYPE_NAMES.put(Float.class.getName(), "floating point");
        TYPE_NAMES.put(Double.class.getName(), "floating point");
        TYPE_NAMES.put(String.class.getName(), "String");
    }
}

