/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.PdfGraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;
import uk.ac.starlink.ttools.plot.PictureImageIcon;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.MapEnvironment;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;
import uk.ac.starlink.util.XmlWriter;

public class Plot2Example {
    private final String label_;
    private final Context context_;
    private final PlotTask task_;
    private final String[] params_;

    public Plot2Example(String label, Context context, PlotTask task, String[] params) {
        this.label_ = label;
        this.context_ = context;
        this.task_ = task;
        this.params_ = params;
    }

    public String getLabel() {
        return this.label_;
    }

    public String[] getLines() {
        String intro = "stilts " + this.task_.getName();
        String pad = intro.replaceAll(".", " ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(intro);
        for (String param : this.params_) {
            if (param == null) {
                if (sbuf.length() > 0) {
                    lines.add(sbuf.toString());
                }
                sbuf = new StringBuffer();
                continue;
            }
            if (sbuf.length() == 0) {
                sbuf.append(pad);
            }
            sbuf.append(' ').append(Plot2Example.toPair(param).txt_);
        }
        if (sbuf.length() > 0) {
            lines.add(sbuf.toString());
        }
        return lines.toArray(new String[0]);
    }

    public String getXml() {
        String intro = "   stilts " + this.task_.getName();
        String pad = intro.replaceAll(".", " ");
        StringBuffer sbuf = new StringBuffer().append("<verbatim>").append(intro);
        for (String param : this.params_) {
            if (param == null) {
                if (sbuf.length() <= 0) continue;
                sbuf.append("\n").append(pad);
                continue;
            }
            String xtxt = Plot2Example.toPair(param).getXml();
            if (xtxt.length() <= 0) continue;
            sbuf.append(' ').append(xtxt);
        }
        sbuf.append("</verbatim>");
        return sbuf.toString();
    }

    public Picture createPicture(String[] extraParams) throws IOException, TaskException, InterruptedException, LoadException {
        MapEnvironment env = Plot2Example.createEnvironment(this.context_, PlotUtil.arrayConcat(this.params_, extraParams));
        AbstractPlot2Task task = this.task_.createTask();
        Picture picture = PlotUtil.toPicture(task.createPlotIcon(env));
        Plot2Example.checkUsedEnvironment(env);
        return picture;
    }

    public void testParams() throws Exception {
        MapEnvironment env = Plot2Example.createEnvironment(this.context_, this.params_);
        this.task_.createTask().testEnv(env);
        Plot2Example.checkUsedEnvironment(env);
    }

    public String[] getRequiredTableNames() {
        TreeSet<String> tnames = new TreeSet<String>();
        for (String param : this.params_) {
            if (param == null) continue;
            String value = Plot2Example.toPair(param).value_;
            if (!this.context_.tableNames_.contains(value)) continue;
            tnames.add(value);
        }
        return tnames.toArray(new String[0]);
    }

    public static Map<String, String> getExamplesXml() {
        File dir = new File(".");
        Plot2Example[] examples = Plot2Example.createExamples(new Context(dir, TName.NAMES, dir, null));
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Plot2Example ex : examples) {
            map.put(ex.getLabel(), ex.getXml());
        }
        return map;
    }

    static void checkExamples(File dataDir) throws Exception {
        Context context = new Context(dataDir, TName.NAMES, null, null);
        Plot2Example[] examples = Plot2Example.createExamples(context);
        TreeSet<String> tnames = new TreeSet<String>();
        for (Plot2Example ex : examples) {
            tnames.addAll(Arrays.asList(ex.getRequiredTableNames()));
        }
        int nHas = 0;
        for (String tname : tnames) {
            if (!new File(dataDir, tname).exists()) continue;
            ++nHas;
        }
        if (nHas == 0) {
            System.out.println("No required data tables in " + dataDir + ", skip plot2 example tests");
        } else {
            context.checkHasTables(tnames.toArray(new String[0]));
            for (Plot2Example ex : examples) {
                ex.testParams();
            }
        }
    }

    private static Pair toPair(String param) {
        String txt;
        Flag flag;
        switch (param.charAt(0)) {
            case '*': {
                flag = Flag.BOLD;
                txt = param.substring(1);
                break;
            }
            case '!': {
                flag = Flag.HIDDEN;
                txt = param.substring(1);
                break;
            }
            default: {
                flag = Flag.NORMAL;
                txt = param;
            }
        }
        int ieq = txt.indexOf(61);
        if (ieq > 0) {
            String key = txt.substring(0, ieq);
            String rvalue = txt.substring(ieq + 1);
            int vleng = rvalue.length();
            String value = rvalue.indexOf(39) == 0 && rvalue.indexOf(39, 1) == vleng - 1 ? rvalue.substring(1, vleng - 1) : rvalue;
            return new Pair(txt, flag, key, value);
        }
        throw new IllegalArgumentException("param \"" + param + "\" not [*!]key=value");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MapEnvironment createEnvironment(Context context, String[] params) throws IOException {
        LinkedHashMap map = new LinkedHashMap();
        for (String param : params) {
            void var11_13;
            if (param == null) continue;
            Pair pair = Plot2Example.toPair(param);
            String key = pair.key_;
            String value = pair.value_;
            StarTable table = context.getTable(value);
            if (table != null) {
                StarTable starTable = table;
            } else if (map.containsKey(key)) {
                if (!key.startsWith("cmd") && !key.startsWith("icmd")) throw new IllegalArgumentException("Multiple values for key " + key);
                String string = (String)map.get(key) + new FilterParameter("dummy").getValueSeparator() + value;
            } else {
                String string = value;
            }
            map.put(key, var11_13);
        }
        for (Map.Entry entry : context.envDefaults_.entrySet()) {
            String key = (String)entry.getKey();
            if (map.containsKey(key)) continue;
            map.put(key, entry.getValue());
        }
        return new MapEnvironment(map);
    }

    private static void checkUsedEnvironment(MapEnvironment env) throws TaskException {
        Object[] unused = env.getUnused();
        if (unused.length > 0) {
            throw new TaskException("Unused args: " + Arrays.toString(unused));
        }
    }

    private static URL toContextUrl(String txt) throws MalformedURLException {
        if (txt == null) {
            return null;
        }
        if (txt.endsWith("/")) {
            return new URL(txt);
        }
        return new URL(txt + "/");
    }

    private static Plot2Example[] createExamples(Context c) {
        return new Plot2Example[]{new Plot2Example("layer-mark", c, PlotTask.PLANE, new String[]{"*layer1=mark", "*in1=" + TName.RR, "*x1=p1", "*y1=peak_to_peak_g"}), new Plot2Example("layer-size", c, PlotTask.SKY, new String[]{"projection=aitoff", "xpix=500", "ypix=250", null, "*layer1=size", "*in1=" + TName.MESSIER, "*shading1=transparent", "*lon1=RA", "*lat1=DEC", "*size1=Radius"}), new Plot2Example("layer-sizexy", c, PlotTask.PLANE, new String[]{"*layer1=sizexy", "*in1=" + TName.QSO, "*shape1=filled_rectangle", null, "*x1=psfmag_u-psfmag_g", "*y1=psfmag_r-psfmag_z", "*xsize1=exp(psfmag_g)", "*ysize1=exp(psfmag_r)", null, "xmin=-3", "xmax=1", "ymin=1", "ymax=3.2"}), new Plot2Example("layer-xyvector", c, PlotTask.PLANE, new String[]{"*layer1=xyvector", "*in1=" + TName.GAVO2, null, "*x1=x", "*y1=y", "*xdelta1=velX", "*ydelta1=velY", "*autoscale1=true", null, "xmin=9", "xmax=11", "ymin=12", "ymax=13.5"}), new Plot2Example("layer-xyerror", c, PlotTask.PLANE, new String[]{"in=" + TName.FORNAX, "x=S500", "y=S160", null, "layer1=mark", null, "*layer2=xyerror", "*xerrhi2=e_S500", "*yerrhi2=e_S160", "*errorbar2=capped_lines", null, "xlog=true", "ylog=true", "xmin=0.012", "xmax=1", "ymin=0.01", "ymax=10"}), new Plot2Example("layer-xyellipse", c, PlotTask.PLANE, new String[]{"*in=" + TName.MGC, "*x=mgc_alpha_j2000", "*y=mgc_delta_j2000", null, "*ra=bulge_re/3600.", "*rb=bulge_re*bulge_e/3600.", "*posang=bulge_pa", null, "*autoscale=false", "*scale=10", "*color=blue", null, "*layer1=xyellipse", "*ellipse1=filled_ellipse", "*shading1=transparent", "*opaque1=4", null, "*layer2=xyellipse", "*ellipse2=crosshair_ellipse", null, "aspect=1", "xmin=181.3", "xmax=181.9"}), new Plot2Example("layer-skyellipse", c, PlotTask.SKY, new String[]{"*in=" + TName.MGC, null, "*lon=mgc_alpha_j2000", "*lat=mgc_delta_j2000", null, "*ra=bulge_re", "*rb=bulge_re*bulge_e", "*unit=arcsec", "*posang=bulge_pa", null, "*scale=10", "*color=#cc00ff", null, "*layer1=skyellipse", "*ellipse1=filled_ellipse", "*shading1=transparent", "*opaque1=4", null, "*layer2=skyellipse", "*ellipse2=crosshair_ellipse", null, "clon=180.1", "clat=0", "radius=0.25"}), new Plot2Example("layer-xycorr", c, PlotTask.PLANE, new String[]{"*in=" + TName.TGAS, "*icmd='select skyDistanceDegrees(ra,dec,56.9,23.9)<0.4'", null, "*x=pmra", "*y=pmdec", null, "layer1=mark", null, "xerrhi2=pmra_error", "yerrhi2=pmdec_error", null, "color2=cyan", "shading2=transparent", null, "layer2a=xyerror", "errorbar2a=filled_rectangle", "opaque2a=10", null, "layer2b=xyerror", "errorbar2b=crosshair_rectangle", "opaque2b=4", null, "*layer3=xycorr", "*autoscale3=false", null, "*xerr3=pmra_error", "*yerr3=pmdec_error", "*xycorr3=pmra_pmdec_corr", null, "*ellipse3=crosshair_ellipse", null, "aspect=1", null, "xmin=17", "xmax=24", "ymin=-48", "ymax=-42"}), new Plot2Example("layer-skycorr", c, PlotTask.SKY, new String[]{"*in=" + TName.TGAS, null, "*lon=ra", "*lat=dec", null, "icmd='select ra>245.1&&ra<245.9&&dec>-17.8&&dec<-17.2'", null, "color=blue", null, "layer1=mark", null, "*unit=mas", "*scale=2e5", null, "ra2=ra_error", "rb2=dec_error", "posang2=90", null, "color2=orange", "shading2=transparent", null, "layer2a=skyellipse", "ellipse2a=filled_rectangle", "opaque2a=6", null, "layer2b=skyellipse", "ellipse2b=crosshair_rectangle", "opaque2b=2", null, "*layer3=skycorr", null, "*lonerr3=ra_error", "*laterr3=dec_error", "*corr3=ra_dec_corr", null, "*ellipse3=crosshair_ellipse"}), new Plot2Example("layer-line", c, PlotTask.TIME, new String[]{"*in=" + TName.ACE, "*t=epoch", null, "*layer1=line", "*y1=Br", "zone1=A", null, "*layer2=line", "*y2=Bt", "zone2=B", null, "*layer3=line", "*y3=Bn", "zone3=C"}), new Plot2Example("layer-linearfit", c, PlotTask.PLANE, new String[]{"*in=" + TName.MINI6, "*x=RMAG", "*y=BMAG", "layer1=mark", "*layer2=linearfit"}), new Plot2Example("layer-label", c, PlotTask.SKY, new String[]{"*in=" + TName.MESSIER, "*lon=RA", "*lat=DEC", "layer1=mark", "*layer2=label", "*label2=NAME"}), new Plot2Example("layer-contour", c, PlotTask.PLANE, new String[]{"*in=" + TName.TGAS, "*x=phot_g_mean_mag", "*y=phot_g_mean_flux_error", null, "ylog=true", "xmax=14", "ymin=10", null, "layer1=mark", "shading1=density", "densemap1=greyscale", null, "*layer2=contour", "*scaling2=log"}), new Plot2Example("layer-grid", c, PlotTask.PLANE, new String[]{"*layer1=grid", "*in1=" + TName.HESS, "*x1=g_min_ks", "*y1=g_mag_abs", null, "*weight1=n", "*combine1=sum", "*xbinsize1=0.2", "*ybinsize1=0.2", "*xphase1=0.5", "*yphase1=0.5", null, "yflip=true", "auxfunc=log", "auxmap=viridis"}), new Plot2Example("layer-fill", c, PlotTask.TIME, new String[]{"*layer1=fill", "*in1=" + TName.IERS, "*t1=decYear", "*y1=lodErr", "ylog=true"}), new Plot2Example("layer-quantile", c, PlotTask.PLANE, new String[]{"*in=" + TName.TGAS, "*x=phot_g_mean_mag", "*y=phot_g_mean_flux_error", null, "ylog=true", "xmax=15", "ymin=10", null, "layer.d=mark", "color.d=99ff99", null, "*layer.q4=quantile", "*quantiles.q4=0.25,0.75", "*color.q4=magenta", "*transparency.q4=0.35", null, "*layer.q2=quantile", "*quantiles.q2=0.5", "*color.q2=SkyBlue", "*thick.q2=4", null, "*smooth.q=0.05", null, "leglabel.q4=Quartiles", "leglabel.q2=Median", "legseq=.q4,.q2", "legpos=0.95,0.95"}), new Plot2Example("layer-skyvector", c, PlotTask.SKY, new String[]{"*in=" + TName.TGAS, "*lon=ra", "*lat=dec", null, "layer1=mark", null, "*layer2=skyvector", null, "*dlon2=pmra", "*dlat2=pmdec", "*unit2=scaled", "*arrow2=medium_arrow", null, "clon=56.75", "clat=24.10", "radius=1.5"}), new Plot2Example("layer-histogram", c, PlotTask.PLANE, new String[]{"*layer1=histogram", "*in1=" + TName.RR, "*x1=p1"}), new Plot2Example("layer-kde", c, PlotTask.PLANE, new String[]{"*layer1=kde", "*in1=" + TName.RR, "*x1=p1"}), new Plot2Example("layer-knn", c, PlotTask.PLANE, new String[]{"*layer1=knn", "*in1=" + TName.RR, "*x1=p1"}), new Plot2Example("layer-densogram", c, PlotTask.PLANE, new String[]{"*in=" + TName.TGAS, "*x=hypot(pmra_error,pmdec_error)", null, "xlog=true", "*normalise=maximum", null, "color=grey", "layer1=histogram", "layer2=kde", null, "*layer3=densogram", "*densemap3=skyblue-yellow-hotpink", "*densefunc3=log", null, "*size3=50", "*pos3=0.5"}), new Plot2Example("layer-gaussian", c, PlotTask.PLANE, new String[]{"*in=" + TName.MGC, "*x=mgc_dc_sb", null, "layer1=histogram", "color1=green", null, "*layer2=gaussian", "*color2=grey", "*thick2=3", null, "ymax=1200"}), new Plot2Example("layer-skydensity", c, PlotTask.SKY, new String[]{"*in=" + TName.TGAS, "*lon=l", "*lat=b", null, "*layer1=skydensity", "*weight1=astrometric_excess_noise", "*combine1=mean", "*level1=4", null, "projection=aitoff", "auxmap=cubehelix", "auxfunc=log", null, "xpix=580", "ypix=250"}), new Plot2Example("layer-healpix", c, PlotTask.SKY, new String[]{"*layer1=healpix", "*in1=" + TName.SIMBAD_HPX, "*healpix1=HPX8", "*value1=NBREF", null, "*datalevel1=8", "*degrade1=2", null, "projection=aitoff", "*datasys1=equatorial", "viewsys=galactic", "labelpos=none", null, "auxfunc=log", "auxmap=cold", "auxflip=true", "auxvisible=false", "auxclip=0,1", null, "xpix=500", "ypix=250"}), new Plot2Example("layer-xyzvector", c, PlotTask.CUBE, new String[]{"*in=" + TName.GAVO2, null, "*x=x", "*y=y", "*z=z", "*xdelta=velX", "*ydelta=velY", "*zdelta=velZ", "*autoscale=true", null, "*color=BlueViolet", "*scale=1.5", null, "*layer1=xyzvector", "*shading1=transparent", "*opaque1=5", "*arrow1=medium_filled_dart", null, "*layer2=xyzvector", "*shading2=flat", "*arrow2=medium_open_dart", null, "xmin=6", "xmax=7.5", "ymin=12.5", "ymax=13.5", "zmin=19", "zmax=21.5"}), new Plot2Example("layer-xyzerror", c, PlotTask.CUBE, new String[]{"*in=" + TName.QSO, "icmd='select morphology==1'", null, "*x=psfmag_g", "*xerrhi=psfmagerr_g", null, "*y=psfmag_r", "*yerrhi=psfmagerr_r", null, "*z=psfmag_u", "*zerrhi=psfmagerr_u", null, "layer1=mark", null, "*layer2=xyzerror", "*errorbar2=cuboid", null, "shading=transparent", "opaque=3", null, "xmin=17.5", "xmax=18", "ymin=17.3", "ymax=17.7", "zmin=17.4", "zmax=18.2"}), new Plot2Example("layer-spectrogram", c, PlotTask.TIME, new String[]{"*layer1=spectrogram", "*in1=" + TName.LRS, "*t1=epoch", "*spectrum1=RX2", null, "auxfunc=linear", "auxmap=plasma", "auxclip=0,1", null, "xpix=600", "ypix=300", null, "tmin=2007-11-01T00", "tmax=2007-11-01T12", "ymax=500"}), new Plot2Example("layer-yerror", c, PlotTask.TIME, new String[]{"*in=" + TName.ACE, "*t=epoch", "*y=Bmag", null, "*layer1=yerror", "*yerrhi1=sigma_B", "*errorbar1=capped_lines", null, "layer2=mark", "shape2=open_circle", "size2=3", null, "layer3=line", "color3=a0a0a0", null, "tmin=2001-08-17T07", "tmax=2001-08-17T10", "ypix=250"}), new Plot2Example("layer-mark2", c, PlotTask.SKY, new String[]{"clon=14.78", "clat=-72.1525", "radius=0.0015", "sex=false", null, "layer_h=mark", "in_h=" + TName.NGC346, "lon_h=_RAJ2000", "lat_h=_DEJ2000", "color_h=red", null, "layer_g=mark", "in_g=" + TName.NGC346_GAIA, "lon_g=ra", "lat_g=dec", "color_g=blue", "shading_g=flat", "size_g=3", null, "*in_x=" + TName.NGC346_GAIA, "*lon1_x=_RAJ2000", "*lat1_x=_DEJ2000", "*lon2_x=ra", "*lat2_x=dec", "*shading_x=flat", null, "layer_xl=link2", "color_xl=greenyellow", null, "*layer_xm=mark2", "*color_xm=forestgreen", "*size_xm=4", "*shape_xm=open_circle", null, "seq=_xm,_xl,_h,_g", "leglabel_h=HST", "leglabel_g='Gaia DR1'", "legseq=_h,_g", "legpos=0.95,0.95"}), new Plot2Example("layer-link2", c, PlotTask.SKY, new String[]{"clon=14.78", "clat=-72.1525", "radius=0.0015", "sex=false", null, "layer_h=mark", "in_h=" + TName.NGC346, "lon_h=_RAJ2000", "lat_h=_DEJ2000", "color_h=red", null, "layer_g=mark", "in_g=" + TName.NGC346_GAIA, "lon_g=ra", "lat_g=dec", "color_g=blue", "shading_g=flat", "size_g=3", null, "*in_x=" + TName.NGC346_GAIA, "*lon1_x=_RAJ2000", "*lat1_x=_DEJ2000", "*lon2_x=ra", "*lat2_x=dec", "*shading_x=flat", null, "*layer_xl=link2", "*color_xl=forestgreen", null, "layer_xm=mark2", "color_xm=greenyellow", "size_xm=4", "shape_xm=open_circle", null, "seq=_xm,_xl,_h,_g", "leglabel_h=HST", "leglabel_g='Gaia DR1'", "legseq=_h,_g", "legpos=0.95,0.95"}), new Plot2Example("layer-function", c, PlotTask.PLANE, new String[]{"*layer1=function", "*fexpr1=sin(x)/x", "*thick1=3", null, "xmin=0", "xmax=30", "ymin=-0.25", "ymax=0.25"}), new Plot2Example("layer-skygrid", c, PlotTask.SKY, new String[]{"xpix=500", "ypix=250", "projection=aitoff", null, "*viewsys=ecliptic", null, "*layer1=skygrid", "*gridsys1=galactic", "*gridcolor1=HotPink", "*labelpos1=none"}), Plot2Example.createShadingExample("flat", c, new String[0]), Plot2Example.createShadingExample("auto", c, new String[0]), Plot2Example.createShadingExample("transparent", c, new String[0]), Plot2Example.createShadingExample("translucent", c, new String[0]), Plot2Example.createShadingExample("density", c, new String[]{"*densemap1=viridis"}), Plot2Example.createShadingExample("aux", c, new String[]{"*aux1=z", "*auxmap=plasma"}), Plot2Example.createShadingExample("weighted", c, new String[]{"*weight1=z", "*auxmap=plasma"})};
    }

    private static Plot2Example createShadingExample(String shading, Context context, String[] extraParams) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.addAll(Arrays.asList("layer1=mark", "in1=" + TName.QSO, null, "*shading1=" + shading));
        paramList.addAll(Arrays.asList(extraParams));
        paramList.addAll(Arrays.asList(null, "x1=psfmag_g-psfmag_r", "y1=psfmag_u-psfmag_g", "size1=2", null, "xmin=-0.5", "xmax=2.5", "ymin=-1", "ymax=6"));
        return new Plot2Example("shading-" + shading, context, PlotTask.PLANE, paramList.toArray(new String[0]));
    }

    public static void main(String[] args) throws Exception {
        StringBuffer mbuf = new StringBuffer();
        for (Mode mode : Mode.values()) {
            mbuf.append(mbuf.length() > 0 ? "|" : "").append((Object)mode);
        }
        String usage = new StringBuffer().append(Plot2Example.class.getSimpleName()).append(" [-mode " + mbuf + "]").append(" [-dataDir <dir>]").append(" [-outDir <dir>]").append(" [-dataUrl <url>]").append(" [-help]").append(" [label ...]").toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        String dataDir = ".";
        String outDir = ".";
        String dataUrl = null;
        Mode mode = Mode.swing;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if ("-mode".equalsIgnoreCase(arg)) {
                it.remove();
                String modeName = (String)it.next();
                it.remove();
                mode = Mode.valueOf(modeName);
                continue;
            }
            if ("-dataDir".equalsIgnoreCase(arg)) {
                it.remove();
                dataDir = (String)it.next();
                it.remove();
                continue;
            }
            if ("-outDir".equalsIgnoreCase(arg)) {
                it.remove();
                outDir = (String)it.next();
                it.remove();
                continue;
            }
            if ("-dataUrl".equalsIgnoreCase(arg)) {
                it.remove();
                dataUrl = (String)it.next();
                it.remove();
                continue;
            }
            if (!arg.toLowerCase().startsWith("-h")) continue;
            System.err.println(usage);
            return;
        }
        Logger.getLogger("uk.ac.starlink").setLevel(Level.SEVERE);
        Context context = new Context(new File(dataDir), TName.NAMES, new File(outDir), Plot2Example.toContextUrl(dataUrl));
        LinkedHashMap<String, Plot2Example> exampleMap = new LinkedHashMap<String, Plot2Example>();
        for (Plot2Example ex : Plot2Example.createExamples(context)) {
            if (exampleMap.put(ex.label_, ex) == null) continue;
            throw new RuntimeException("duplicate example label \"" + ex.label_ + "\"");
        }
        String[] labels = argList.size() > 0 ? argList.toArray(new String[0]) : exampleMap.keySet().toArray(new String[0]);
        ArrayList<Plot2Example> exampleList = new ArrayList<Plot2Example>();
        TreeSet<String> tableNames = new TreeSet<String>();
        for (String label : labels) {
            Plot2Example ex = (Plot2Example)exampleMap.get(label);
            if (ex != null) {
                tableNames.addAll(Arrays.asList(ex.getRequiredTableNames()));
                exampleList.add(ex);
                continue;
            }
            System.err.println("no such example: " + label);
        }
        Plot2Example[] examples = exampleList.toArray(new Plot2Example[0]);
        if (mode.requiresPreTest()) {
            context.checkHasTables(tableNames.toArray(new String[0]));
            for (Plot2Example ex : examples) {
                ex.testParams();
            }
        }
        mode.execute(context, examples);
    }

    private static enum Flag {
        NORMAL{

            @Override
            String wrapXml(String etxt) {
                return etxt;
            }
        }
        ,
        BOLD{

            @Override
            String wrapXml(String etxt) {
                return "<strong>" + etxt + "</strong>";
            }
        }
        ,
        HIDDEN{

            @Override
            String wrapXml(String etxt) {
                return "";
            }
        };


        abstract String wrapXml(String var1);
    }

    private static class Pair {
        private final String txt_;
        private Flag flag_;
        private final String key_;
        private final String value_;

        Pair(String txt, Flag flag, String key, String value) {
            this.txt_ = txt;
            this.flag_ = flag;
            this.key_ = key;
            this.value_ = value;
        }

        String getXml() {
            return this.flag_.wrapXml(XmlWriter.formatText((String)this.txt_));
        }
    }

    private static class TName {
        public static final String RR;
        public static final String TGAS;
        public static final String MESSIER;
        public static final String QSO;
        public static final String GAVO2;
        public static final String FORNAX;
        public static final String ACE;
        public static final String MINI6;
        public static final String HESS;
        public static final String IERS;
        public static final String MGC;
        public static final String SIMBAD_HPX;
        public static final String LRS;
        public static final String NGC346;
        public static final String NGC346_GAIA;
        public static final String[] NAMES;

        private TName() {
        }

        static {
            String[] stringArray = new String[15];
            RR = "rrlyrae.fits";
            stringArray[0] = "rrlyrae.fits";
            TGAS = "tgas_source.fits";
            stringArray[1] = "tgas_source.fits";
            MESSIER = "messier.xml";
            stringArray[2] = "messier.xml";
            QSO = "dr5qso.fits";
            stringArray[3] = "dr5qso.fits";
            GAVO2 = "gavo_g2.fits";
            stringArray[4] = "gavo_g2.fits";
            FORNAX = "J_MNRAS_440_1571.vot";
            stringArray[5] = "J_MNRAS_440_1571.vot";
            ACE = "ACE_data.vot";
            stringArray[6] = "ACE_data.vot";
            MINI6 = "6dfgs_mini.xml";
            stringArray[7] = "6dfgs_mini.xml";
            HESS = "gk_hess.fits";
            stringArray[8] = "gk_hess.fits";
            IERS = "iers.fits";
            stringArray[9] = "iers.fits";
            MGC = "mgc_ok.fits";
            stringArray[10] = "mgc_ok.fits";
            SIMBAD_HPX = "simbad-hpx8.fits";
            stringArray[11] = "simbad-hpx8.fits";
            LRS = "LRS_NPW_V010_20071101.cdf";
            stringArray[12] = "LRS_NPW_V010_20071101.cdf";
            NGC346 = "ngc346.fits";
            stringArray[13] = "ngc346.fits";
            NGC346_GAIA = "ngc346xGaiadr1.fits";
            stringArray[14] = "ngc346xGaiadr1.fits";
            NAMES = stringArray;
        }
    }

    private static enum Mode {
        swing(true){

            @Override
            public void execute(Context context, Plot2Example[] examples) throws Exception {
                for (Plot2Example ex : examples) {
                    System.out.println(ex.getLabel() + ":");
                    for (String line : ex.getLines()) {
                        System.out.println("   " + line);
                    }
                    Picture pic = ex.createPicture(FORCEBITMAP);
                    JLabel picComp = new JLabel(new PictureImageIcon(pic, true));
                    final JDialog dialog = new JDialog((Frame)null, ex.getLabel(), true);
                    dialog.setDefaultCloseOperation(2);
                    JComponent holder = (JComponent)dialog.getContentPane();
                    holder.add(picComp);
                    String quitKey = "quit";
                    holder.getInputMap().put(KeyStroke.getKeyStroke('q'), quitKey);
                    holder.getActionMap().put(quitKey, new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            dialog.dispose();
                        }
                    });
                    dialog.pack();
                    dialog.setVisible(true);
                }
            }
        }
        ,
        png(true){

            @Override
            public void execute(Context context, Plot2Example[] examples) throws Exception {
                Mode.writeExamples(context, examples, GraphicExporter.PNG, ".png");
            }
        }
        ,
        pdf(true){

            @Override
            public void execute(Context context, Plot2Example[] examples) throws Exception {
                Mode.writeExamples(context, examples, PdfGraphicExporter.BASIC, ".pdf");
            }
        }
        ,
        copydata(false){

            @Override
            public void execute(Context context, Plot2Example[] examples) throws IOException {
                File dataDir = context.dataDir_;
                URL dataUrl = context.dataUrl_;
                String intro = "Copying files from " + dataUrl + " to " + dataDir + ":";
                int ic = 0;
                for (String tname : context.tableNames_) {
                    File f = new File(dataDir, tname);
                    if (f.exists()) continue;
                    if (ic++ == 0) {
                        System.out.println(intro);
                    }
                    System.out.println("   " + tname);
                    URL turl = new URL(dataUrl, tname);
                    InputStream in = turl.openStream();
                    FileOutputStream out = new FileOutputStream(f);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    in.close();
                    ((OutputStream)out).close();
                }
            }
        };

        private final boolean preTest_;
        private static final String[] FORCEBITMAP;

        private Mode(boolean preTest) {
            this.preTest_ = preTest;
        }

        public abstract void execute(Context var1, Plot2Example[] var2) throws Exception;

        public boolean requiresPreTest() {
            return this.preTest_;
        }

        private static void writeExamples(Context context, Plot2Example[] examples, GraphicExporter exporter, String suffix) throws Exception {
            String[] extraParams = exporter.isVector() ? new String[]{} : FORCEBITMAP;
            File outDir = context.outDir_;
            int nex = examples.length;
            System.out.println("Writing " + nex + " plot2 examples in " + outDir + ":");
            for (int iex = 0; iex < examples.length; ++iex) {
                Plot2Example ex = examples[iex];
                String label = ex.getLabel();
                String fname = "plot2-" + label + suffix;
                System.out.println("   " + fname);
                FileOutputStream out = new FileOutputStream(new File(outDir, fname));
                exporter.exportGraphic(ex.createPicture(extraParams), out);
                ((OutputStream)out).close();
            }
            String defsname = "plot2-figdefs.xml";
            String listname = "plot2-figs.lis";
            Charset utf8 = Charset.forName("UTF-8");
            System.out.println("Writing " + defsname + ", " + listname);
            OutputStreamWriter defOut = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outDir, defsname)), utf8);
            OutputStreamWriter listOut = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outDir, listname)), utf8);
            for (Plot2Example ex : examples) {
                String label = ex.getLabel();
                String fname = "plot2-" + label + suffix;
                defOut.write("  <!ENTITY FIG.plot2-" + label + " '" + fname + "'>\n");
                listOut.write(fname + "\n");
            }
            ((Writer)defOut).close();
            ((Writer)listOut).close();
        }

        static {
            FORCEBITMAP = new String[]{"forcebitmap=true"};
        }
    }

    private static class PlotTask {
        private final String name_;
        private static ObjectFactory<Task> taskFactory_ = Stilts.getTaskFactory();
        public static final PlotTask PLANE = new PlotTask("plot2plane");
        public static final PlotTask SKY = new PlotTask("plot2sky");
        public static final PlotTask CUBE = new PlotTask("plot2cube");
        public static final PlotTask SPHERE = new PlotTask("plot2sphere");
        public static final PlotTask TIME = new PlotTask("plot2time");

        PlotTask(String name) {
            this.name_ = name;
            this.createTask();
        }

        public String getName() {
            return this.name_;
        }

        public AbstractPlot2Task createTask() {
            try {
                return (AbstractPlot2Task)taskFactory_.createObject(this.name_);
            }
            catch (Throwable e) {
                throw new RuntimeException("Trouble creating task " + this.name_, e);
            }
        }
    }

    private static class Context {
        private final File dataDir_;
        private final Collection<String> tableNames_;
        private final File outDir_;
        private final URL dataUrl_;
        private final StarTableFactory tableFactory_;
        private final Map<String, StarTable> tableMap_;
        private final Map<String, Object> envDefaults_;

        public Context(File dataDir, String[] tableNames, File outDir, URL dataUrl) {
            this.dataDir_ = dataDir;
            this.tableNames_ = new TreeSet<String>(Arrays.asList(tableNames));
            this.outDir_ = outDir;
            this.dataUrl_ = dataUrl;
            this.tableFactory_ = new StarTableFactory();
            this.tableMap_ = new HashMap<String, StarTable>();
            this.envDefaults_ = new LinkedHashMap<String, Object>();
            this.envDefaults_.put("ypix", "350");
        }

        public synchronized StarTable getTable(String name) throws IOException {
            if (this.tableNames_.contains(name)) {
                if (!this.tableMap_.containsKey(name)) {
                    File f = new File(this.dataDir_, name);
                    this.tableMap_.put(name, this.tableFactory_.makeStarTable((DataSource)new FileDataSource(f)));
                }
                return this.tableMap_.get(name);
            }
            return null;
        }

        public void checkHasTables(String[] tnames) throws FileNotFoundException {
            ArrayList<String> missing = new ArrayList<String>();
            for (String tname : tnames) {
                if (new File(this.dataDir_, tname).exists()) continue;
                missing.add(tname);
            }
            if (missing.size() > 0) {
                throw new FileNotFoundException("Missing example data files in " + this.dataDir_ + ": " + missing);
            }
        }
    }
}

