/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.Formatter;
import uk.ac.starlink.ttools.build.LayerTypeDoc;
import uk.ac.starlink.ttools.build.Plot2Example;
import uk.ac.starlink.ttools.build.UsageWriter;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.task.LayerType;
import uk.ac.starlink.ttools.plot2.task.LayerTypeParameter;
import uk.ac.starlink.ttools.plot2.task.ShapeFamilyLayerType;
import uk.ac.starlink.util.LoadException;

public class ShapeModeDoc {
    private final boolean basicXml_;
    private final String suffix_;
    private final String paramPrefix_;
    private final Map<String, String> examplesMap_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.build");

    public ShapeModeDoc(boolean basicXml) {
        this.basicXml_ = basicXml;
        this.suffix_ = "N";
        this.paramPrefix_ = "shading";
        this.examplesMap_ = Plot2Example.getExamplesXml();
    }

    public String getXmlDoc(ShapeMode mode) {
        String mname = mode.getModeName();
        Parameter[] coordParams = LayerTypeParameter.getCoordParams(mode.getExtraCoords(), this.suffix_, true);
        Parameter[] styleParams = LayerTypeParameter.getLayerConfigParams(mode.getConfigKeys(), this.suffix_, false);
        Parameter[] params = PlotUtil.arrayConcat(coordParams, styleParams);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<subsubsect id='shading-").append(mname).append("'>\n").append("<subhead><title><code>").append(mname).append("</code></title></subhead>\n");
        sbuf.append(mode.getModeDescription());
        ArrayList<String> usageWords = new ArrayList<String>();
        usageWords.add(this.paramPrefix_ + this.suffix_ + "=" + mname);
        for (Parameter param : params) {
            usageWords.add(LayerTypeParameter.usageWord(param));
        }
        sbuf.append("<p>\n").append("<strong>Usage:</strong>\n").append("<verbatim><![CDATA[\n").append(Formatter.formatWords(usageWords, 3)).append("]]></verbatim>\n").append("</p>\n").append("<p>All the parameters listed here\n").append("affect only the relevant layer,\n").append("identified by the suffix\n").append("<code>").append(this.suffix_).append("</code>.\n").append("</p>\n");
        String exname = "shading-" + mname;
        String exXml = this.examplesMap_.get(exname);
        if (exXml != null) {
            sbuf.append("<p>\n").append("<strong>Example:</strong>\n").append("</p>\n").append("<figure>\n").append("<figureimage src='&FIG.plot2-").append(exname).append(";'/>\n").append("</figure>\n").append("<p>").append(exXml).append("</p>\n");
        } else {
            logger_.severe("No example figure for shading type " + mname);
        }
        if (params.length > 0) {
            sbuf.append("<p>Associated parameters are as follows:\n");
            sbuf.append("<dl>\n");
            Arrays.sort(params, Parameter.BY_NAME);
            for (Parameter param : params) {
                sbuf.append(UsageWriter.xmlItem(param, this.basicXml_));
            }
            sbuf.append("</dl>\n");
            sbuf.append("</p>\n");
        }
        sbuf.append("</subsubsect>\n");
        return sbuf.toString();
    }

    public static Map<String, ShapeMode> getShapeModes() throws LoadException {
        LayerType[] ltypes = LayerTypeDoc.getLayerTypes(LayerTypeDoc.getPlot2Tasks()).values().toArray(new LayerType[0]);
        LinkedHashMap<String, ShapeMode> modeMap = new LinkedHashMap<String, ShapeMode>();
        for (LayerType ltype : ltypes) {
            ShapePlotter.ShapeModePlotter[] plotters;
            if (!(ltype instanceof ShapeFamilyLayerType)) continue;
            for (ShapePlotter.ShapeModePlotter plotter : plotters = ((ShapeFamilyLayerType)ltype).getShapeModePlotters()) {
                ShapeMode mode = plotter.getMode();
                modeMap.put(mode.getModeName(), mode);
            }
        }
        return modeMap;
    }

    public static void main(String[] args) throws LoadException {
        String usage = new StringBuffer().append("\n   ").append("Usage: ").append(ShapeModeDoc.class.getName()).append(" [-doc]").append(" [-basicxml]").append(" [<mode-name> ...]").append("\n").toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean doc = false;
        boolean basicXml = false;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-doc")) {
                it.remove();
                doc = true;
            }
            if (arg.equals("-basicxml")) {
                it.remove();
                basicXml = true;
            }
            if (!arg.startsWith("-h") && !arg.startsWith("--h")) continue;
            it.remove();
            System.err.println(usage);
            return;
        }
        Map<String, ShapeMode> modeMap = ShapeModeDoc.getShapeModes();
        if (argList.size() > 0) {
            modeMap.keySet().retainAll(argList);
        }
        PrintStream out = System.out;
        if (doc) {
            out.println("<doc>");
        }
        ShapeModeDoc doccer = new ShapeModeDoc(basicXml);
        for (ShapeMode mode : modeMap.values()) {
            out.println(doccer.getXmlDoc(mode));
        }
        if (doc) {
            out.println("</doc>");
        }
    }
}

