/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.build;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.task.LineInvoker;
import uk.ac.starlink.util.LoadException;

public class UsageWriter {
    private final OutputStream out_;
    private final String taskName_;
    private final Task task_;

    private UsageWriter(String taskName, OutputStream out) throws LoadException {
        this.out_ = out;
        this.taskName_ = taskName;
        this.task_ = (Task)Stilts.getTaskFactory().createObject(this.taskName_);
    }

    private void writeXml() throws IOException {
        String prefix = "   stilts <stilts-flags> " + this.taskName_;
        this.outln("<subsubsect id=\"" + this.taskName_ + "-usage\">");
        this.outln("<subhead><title>Usage</title></subhead>");
        this.outln("<p>The usage of <code>" + this.taskName_ + "</code> is");
        this.outln("<verbatim><![CDATA[");
        this.outln(LineInvoker.getPrefixedParameterUsage(this.task_.getParameters(), prefix).replaceFirst("\n+$", ""));
        this.outln("]]></verbatim>");
        this.outln("If you don't have the <code>stilts</code> script installed,");
        this.outln("write \"<code>java -jar stilts.jar</code>\" instead of");
        this.outln("\"<code>stilts</code>\" - see <ref id=\"invoke\"/>.");
        this.outln("The available <code>&lt;stilts-flags&gt;</code> are listed");
        this.outln("in <ref id=\"stilts-flags\"/>.");
        this.outln("For programmatic invocation, the Task class for this");
        this.outln("command is <code>" + this.task_.getClass().getName() + "</code>.");
        this.outln("</p>");
        this.outln();
        Parameter[] params = this.task_.getParameters();
        if (params.length > 0) {
            this.outln("<p>Parameter values are assigned on the command line");
            this.outln("as explained in <ref id=\"task-args\"/>.");
            this.outln("They are as follows:");
            this.outln("</p>");
            this.outln("<p>");
            this.outln("<dl>");
            Arrays.sort(params, Parameter.BY_NAME);
            for (int i = 0; i < params.length; ++i) {
                this.outln(UsageWriter.xmlItem(params[i], false));
            }
            this.outln("</dl>");
            this.outln("</p>");
        } else {
            this.outln("<p>This task has no parameters.");
            this.outln("</p>");
        }
        this.outln("</subsubsect>");
    }

    public static String xmlItem(Parameter param, boolean isBasic) {
        String descrip = param.getDescription();
        if (descrip == null) {
            throw new NullPointerException("No description for parameter " + param);
        }
        return new StringBuffer().append("<dt>").append("<code>").append(UsageWriter.getUsageXml(param)).append("</code>").append(" ").append(UsageWriter.nbsps(6)).append("<em>(").append(UsageWriter.getTypeXml(param, isBasic)).append(")</em>").append("</dt>\n").append("<dd>").append(descrip).append(UsageWriter.getDefaultXml(param)).append("</dd>").toString();
    }

    private static String getUsageXml(Parameter param) {
        return (param.getName() + " = " + param.getUsage()).replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String getTypeXml(Parameter param, boolean isBasic) {
        Class<?> vClazz = param.getValueClass();
        boolean isArray = vClazz.getComponentType() != null;
        Class<?> clazz = isArray ? vClazz.getComponentType() : vClazz;
        String arraySuffix = isArray ? "[]" : "";
        String clazzName = clazz.getName();
        int pkgLeng = clazzName.lastIndexOf(".");
        String pkgName = pkgLeng >= 0 ? clazzName.substring(0, pkgLeng) : "";
        String unqName = clazz.getSimpleName();
        String docset = pkgName.startsWith("java") ? "&corejavadocs;" : (pkgName.startsWith("uk.ac.starlink.ttools") ? "&stiltsjavadocs;" : (pkgName.startsWith("uk.ac.starlink.table") ? "&stiljavadocs;" : null));
        boolean isPublic = Modifier.isPublic(clazz.getModifiers());
        StringBuffer sbuf = new StringBuffer();
        if (pkgName.length() == 0 || pkgName.startsWith("java.lang") || !isPublic) {
            sbuf.append(unqName).append(arraySuffix);
        } else if (docset == null || isBasic) {
            sbuf.append(clazzName).append(arraySuffix);
        } else {
            sbuf.append("<javadoc docset='").append(docset).append("'").append(" class='").append(clazzName).append("'").append(">").append(unqName).append(arraySuffix).append("</javadoc>");
        }
        return sbuf.toString();
    }

    private static String getDefaultXml(Parameter param) {
        String dflt = param.getStringDefault();
        StringBuffer sbuf = new StringBuffer();
        if (dflt != null && dflt.length() > 0) {
            sbuf.append("<p>[Default: <code>").append(dflt.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")).append("</code>]</p>");
        }
        return sbuf.toString();
    }

    private static String nbsps(int count) {
        StringBuffer sbuf = new StringBuffer(count);
        for (int i = 0; i < count; ++i) {
            sbuf.append("&#xA0;");
        }
        return sbuf.toString();
    }

    private void out(String text) throws IOException {
        this.out_.write(text.getBytes());
    }

    private void outln(String line) throws IOException {
        this.out(line + "\n");
    }

    private void outln() throws IOException {
        this.out("\n");
    }

    public static void main(String[] args) throws IOException, LoadException {
        Logger.getLogger("uk.ac.starlink.ttools").setLevel(Level.WARNING);
        if (args.length == 0) {
            String[] taskNames = Stilts.getTaskFactory().getNickNames();
            File dir = new File(".");
            for (int i = 0; i < taskNames.length; ++i) {
                String taskName = taskNames[i];
                String fname = taskName + "-summary.xml";
                File file = new File(dir, fname);
                System.out.println("Writing " + fname);
                OutputStream out = new FileOutputStream(file);
                out = new BufferedOutputStream(out);
                new UsageWriter(taskName, out).writeXml();
                out.close();
            }
        } else {
            new UsageWriter(args[0], System.out).writeXml();
        }
    }
}

