/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.calc;

import gnu.jel.CompilationException;
import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.calc.CacheRowPipe;
import uk.ac.starlink.ttools.calc.ColumnCalculator;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.JELTable;

public abstract class ColumnCalculatorFilter<S>
extends BasicFilter {
    private final ColumnCalculator<S> calc_;

    public ColumnCalculatorFilter(String name, String usage, ColumnCalculator<S> calc) {
        super(name, usage);
        this.calc_ = calc;
    }

    protected ProcessingStep createCalcStep(String[] tupleExpressions, S spec) {
        if (this.calc_.getTupleInfos().length != tupleExpressions.length) {
            throw new IllegalArgumentException("tuple length mismatch");
        }
        return new CalcStep<S>(this.calc_, tupleExpressions, spec);
    }

    private static class CalcStep<S>
    implements ProcessingStep {
        private final ColumnCalculator calc_;
        private final String[] tupleExprs_;
        private final S spec_;

        CalcStep(ColumnCalculator calc, String[] tupleExprs, S spec) {
            this.calc_ = calc;
            this.tupleExprs_ = tupleExprs;
            this.spec_ = spec;
        }

        @Override
        public StarTable wrap(StarTable base) throws IOException {
            StarTable tupleTable = this.toTupleTable(base);
            CacheRowPipe cache = new CacheRowPipe();
            this.calc_.calculateColumns(this.spec_, tupleTable, (TableSink)cache);
            StarTable addcolTable = cache.waitForStarTable();
            return new JoinStarTable(new StarTable[]{base, addcolTable});
        }

        private StarTable toTupleTable(StarTable base) throws IOException {
            ValueInfo[] tupleInfos = this.calc_.getTupleInfos();
            int nTuple = tupleInfos.length;
            ColumnInfo[] colInfos = new ColumnInfo[nTuple];
            for (int ic = 0; ic < nTuple; ++ic) {
                colInfos[ic] = new ColumnInfo(tupleInfos[ic]);
            }
            try {
                return new JELTable(base, colInfos, this.tupleExprs_);
            }
            catch (CompilationException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
    }
}

