/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.ttools.cone.ColumnPlan;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.RowMapper;
import uk.ac.starlink.ttools.cone.ServiceFindMode;
import uk.ac.starlink.ttools.cone.UploadConeTable;
import uk.ac.starlink.ttools.cone.UploadMatcher;
import uk.ac.starlink.util.CgiQuery;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.HttpStreamParam;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

public class CdsUploadMatcher
implements UploadMatcher {
    private final URL serviceUrl_;
    private final String tableId_;
    private final double srArcsec_;
    private final ServiceFindMode serviceMode_;
    private final ContentCoding coding_;
    private final boolean uploadFirst_;
    public static final String XMATCH_URL = "http://cdsxmatch.u-strasbg.fr/xmatch/api/v1/sync";
    public static final String SIMBAD_NAME = "simbad";
    public static final boolean UPLOAD_EMPTY = false;
    private static final String ID_NAME = "__UPLOAD_ID__";
    private static final String RA_NAME = "__UPLOAD_RA__";
    private static final String DEC_NAME = "__UPLOAD_DEC__";
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");

    public CdsUploadMatcher(URL serviceUrl, String tableId, double srArcsec, ServiceFindMode serviceMode, ContentCoding coding) {
        this.serviceUrl_ = serviceUrl;
        this.tableId_ = tableId;
        this.srArcsec_ = srArcsec;
        this.serviceMode_ = serviceMode;
        this.coding_ = coding;
        this.uploadFirst_ = this.serviceMode_ != ServiceFindMode.BEST_REMOTE;
    }

    @Override
    public boolean streamRawResult(ConeQueryRowSequence coneSeq, TableSink rawResultSink, RowMapper<?> rowMapper, long maxrec) throws IOException {
        String remoteIndex;
        String uploadIndex;
        if (this.uploadFirst_) {
            uploadIndex = "1";
            remoteIndex = "2";
        } else {
            uploadIndex = "2";
            remoteIndex = "1";
        }
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
        stringMap.put("REQUEST", "xmatch");
        stringMap.put("RESPONSEFORMAT", "votable");
        stringMap.put("distMaxArcsec", Double.toString(this.srArcsec_));
        stringMap.put("selection", this.serviceMode_.isBestOnly() ? "best" : "all");
        stringMap.put("cat" + remoteIndex, this.tableId_);
        stringMap.put("colRA" + uploadIndex, RA_NAME);
        stringMap.put("colDec" + uploadIndex, DEC_NAME);
        stringMap.put("cols" + uploadIndex, ID_NAME);
        if (this.serviceMode_.isScoreOnly()) {
            stringMap.put("cols" + remoteIndex, "");
        }
        if (maxrec >= 0L) {
            stringMap.put("MAXREC", Long.toString(maxrec));
        }
        LinkedHashMap<String, 1> streamMap = new LinkedHashMap<String, 1>();
        String uploadParamName = "cat" + uploadIndex;
        final LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
        headerMap.put("Content-Type", "application/x-votable+xml");
        final VOTableWriter vowriter = new VOTableWriter(DataFormat.BINARY, true, VOTableVersion.V12);
        UploadConeTable coneTable = new UploadConeTable(coneSeq, rowMapper, ID_NAME, RA_NAME, DEC_NAME);
        HttpStreamParam param = new HttpStreamParam((StarTable)coneTable){
            final /* synthetic */ StarTable val$coneTable;
            {
                this.val$coneTable = starTable;
            }

            public Map<String, String> getHttpHeaders() {
                return headerMap;
            }

            public long getContentLength() {
                return -1L;
            }

            public void writeContent(OutputStream out) throws IOException {
                vowriter.writeStarTable(this.val$coneTable, out);
            }
        };
        streamMap.put(uploadParamName, param);
        HttpURLConnection conn = UwsJob.postForm((URL)this.serviceUrl_, (ContentCoding)this.coding_, stringMap, streamMap);
        try {
            return TapQuery.streamResultVOTable((URLConnection)conn, (ContentCoding)this.coding_, (TableSink)rawResultSink);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("Parse error from CDS Xmatch service result " + e).initCause(e);
        }
    }

    @Override
    public ColumnPlan getColumnPlan(ColumnInfo[] resultCols, ColumnInfo[] uploadCols) {
        return new CdsColumnPlan(resultCols, uploadCols, this.uploadFirst_);
    }

    public static String toCdsId(String txt) {
        if (txt == null) {
            return null;
        }
        if ((txt = txt.trim()).length() == 0) {
            return null;
        }
        if (txt.equalsIgnoreCase(SIMBAD_NAME)) {
            return SIMBAD_NAME;
        }
        return "vizier:" + txt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readAliases() throws IOException {
        String url = "http://cdsxmatch.u-strasbg.fr/xmatch/api/v1/sync/tables?action=getPrettyNames";
        logger_.info("Reading VizieR aliases from " + url);
        ArrayList<String> aliasList = new ArrayList<String>();
        BufferedReader rdr = CdsUploadMatcher.getLineReader(url, ContentCoding.NONE);
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                aliasList.add(line);
            }
        }
        finally {
            rdr.close();
        }
        Object[] aliases = aliasList.toArray(new String[0]);
        logger_.info("Got " + aliases.length + " VizieR aliases");
        Arrays.sort(aliases);
        return aliases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readVizierNames() throws IOException {
        String url = "http://cdsxmatch.u-strasbg.fr/xmatch/api/v1/sync/tables?action=getVizieRTableNames";
        logger_.info("Reading VizieR table names from " + url);
        ArrayList<String> nameList = new ArrayList<String>();
        BufferedReader rdr = CdsUploadMatcher.getLineReader(url, ContentCoding.GZIP);
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String name = line.replaceAll("[\\[\\]\",]", "").trim();
                if (name.length() <= 0) continue;
                nameList.add(name);
            }
        }
        finally {
            rdr.close();
        }
        Object[] names = nameList.toArray(new String[0]);
        logger_.info("Got " + names.length + "VizieR table names");
        Arrays.sort(names);
        return names;
    }

    public static VizierMeta readVizierMetadata(String vizName) throws IOException {
        CgiQuery query = new CgiQuery("http://cdsxmatch.u-strasbg.fr/xmatch/api/v1/sync/tables");
        query.addArgument("action", "getInfo");
        query.addArgument("tabName", vizName);
        URL url = query.toURL();
        logger_.info("Reading " + vizName + " metadata from " + url);
        BufferedInputStream in = new BufferedInputStream(ContentCoding.NONE.openStream(url));
        try {
            JSONTokener jt = new JSONTokener((InputStream)in);
            Object next = jt.nextValue();
            if (next instanceof JSONObject) {
                VizierMeta vizierMeta = new VizierMeta((JSONObject)next);
                return vizierMeta;
            }
            throw new IOException("Unexpected JSON object from " + url);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static BufferedReader getLineReader(String urltxt, ContentCoding coding) throws IOException {
        URL url = new URL(urltxt);
        InputStream in = coding.openStream(url);
        return new BufferedReader(new InputStreamReader(in, "utf8"));
    }

    private static class CdsColumnPlan
    implements ColumnPlan {
        private final int ncUp_;
        private final int ncRem_;
        private final int ncOut_;
        private final int icId_;
        private final int icDist_;
        private final int ic0Rem_;
        private final int jcDist_;
        private final int jc0Up_;
        private final int jc0Rem_;

        CdsColumnPlan(ColumnInfo[] resultCols, ColumnInfo[] uploadCols, boolean isUploadFirst) {
            ColumnInfo idInfo;
            int ncRes = resultCols.length;
            this.ncUp_ = uploadCols.length;
            this.ncRem_ = ncRes - 2;
            this.ncOut_ = this.ncUp_ + this.ncRem_ + 1;
            this.icDist_ = 0;
            if (isUploadFirst) {
                this.icId_ = 1;
                this.ic0Rem_ = 2;
            } else {
                this.ic0Rem_ = 1;
                this.icId_ = ncRes - 1;
            }
            this.jc0Up_ = 0;
            this.jc0Rem_ = this.jc0Up_ + this.ncUp_;
            this.jcDist_ = this.jc0Rem_ + this.ncRem_;
            ColumnInfo distInfo = resultCols[this.icDist_];
            if (!("angDist".equalsIgnoreCase(distInfo.getName()) && "arcsec".equals(distInfo.getUnitString()) && Number.class.isAssignableFrom(distInfo.getContentClass()))) {
                logger_.warning("Unexpected Distance column " + this.icDist_ + " from CDS Xmatch: " + distInfo);
            }
            if (!CdsUploadMatcher.ID_NAME.equals((idInfo = resultCols[this.icId_]).getName())) {
                logger_.warning("Unexpected ID column " + this.icId_ + " from CDS Xmatch: " + idInfo);
            }
        }

        @Override
        public int getOutputColumnCount() {
            return this.ncOut_;
        }

        @Override
        public int getOutputColumnLocation(int icolOutput) {
            assert (0 <= this.jc0Up_ && this.jc0Up_ <= this.jc0Rem_ && this.jc0Rem_ <= this.jcDist_ && this.jcDist_ == this.ncOut_ - 1);
            if (icolOutput < this.jc0Up_) {
                throw new IllegalArgumentException("out of range");
            }
            if (icolOutput < this.jc0Rem_) {
                int iUp = icolOutput - this.jc0Up_;
                return -iUp - 1;
            }
            if (icolOutput < this.jcDist_) {
                int iRes = icolOutput + this.ic0Rem_ - this.jc0Rem_;
                return iRes;
            }
            if (icolOutput == this.jcDist_) {
                int iRes = this.icDist_;
                return iRes;
            }
            throw new IllegalArgumentException("out of range");
        }

        @Override
        public int getResultIdColumnIndex() {
            return this.icId_;
        }

        @Override
        public int getResultScoreColumnIndex() {
            return this.icDist_;
        }
    }

    public static class VizierMeta {
        private final String name_;
        private final String prettyName_;
        private final Long rowCount_;
        private final String desc_;

        private VizierMeta(JSONObject jobj) {
            this.name_ = jobj.optString("name", null);
            this.prettyName_ = jobj.optString("prettyName", null);
            this.desc_ = jobj.optString("desc", null);
            long nbrows = jobj.optLong("nbrows", -1L);
            this.rowCount_ = nbrows >= 0L ? new Long(nbrows) : null;
        }

        public String getName() {
            return this.name_;
        }

        public String getPrettyName() {
            return this.prettyName_;
        }

        public String getDescription() {
            return this.desc_;
        }

        public Long getRowCount() {
            return this.rowCount_;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer();
            if (this.name_ != null) {
                sbuf.append("name: ").append(this.name_);
            }
            if (this.prettyName_ != null) {
                sbuf.append("; ").append("prettyName: ").append(this.prettyName_);
            }
            if (this.rowCount_ != null) {
                sbuf.append("; ").append("rowCount: ").append(this.rowCount_);
            }
            if (this.desc_ != null) {
                sbuf.append("; ").append("desc: ").append(this.desc_);
            }
            return sbuf.toString();
        }
    }
}

