/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.cone.ConeSearcher;

public abstract class ConeErrorPolicy {
    private final String name_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");
    public static final ConeErrorPolicy ABORT = new ConeErrorPolicy("abort"){

        @Override
        public StarTable performConeSearch(ConeSearcher cs, double ra, double dec, double sr) throws IOException, InterruptedException {
            return ConeErrorPolicy.invokeConeSearcher(cs, ra, dec, sr);
        }
    };
    public static final ConeErrorPolicy IGNORE = new ConeErrorPolicy("ignore"){

        @Override
        public StarTable performConeSearch(ConeSearcher cs, double ra, double dec, double sr) throws IOException, InterruptedException {
            try {
                return ConeErrorPolicy.invokeConeSearcher(cs, ra, dec, sr);
            }
            catch (IOException e) {
                logger_.info(ConeErrorPolicy.searchString(ra, dec, sr) + " failed: " + e);
                return null;
            }
        }
    };
    public static final ConeErrorPolicy RETRY = ConeErrorPolicy.createRetryPolicy("retry", -1);

    protected ConeErrorPolicy(String name) {
        this.name_ = name;
    }

    public String toString() {
        return this.name_;
    }

    public abstract StarTable performConeSearch(ConeSearcher var1, double var2, double var4, double var6) throws IOException, InterruptedException;

    public static ConeErrorPolicy createRetryPolicy(String name, final int nTry) {
        return new ConeErrorPolicy(name){

            @Override
            public StarTable performConeSearch(ConeSearcher cs, double ra, double dec, double sr) throws IOException, InterruptedException {
                IOException lastError = null;
                for (int nFail = 0; nTry <= 0 || nFail < nTry; ++nFail) {
                    try {
                        return ConeErrorPolicy.invokeConeSearcher(cs, ra, dec, sr);
                    }
                    catch (IOException e) {
                        String count = Integer.toString(nFail + 1);
                        if (nTry > 0) {
                            count = count + "/" + nTry;
                        }
                        logger_.info(ConeErrorPolicy.searchString(ra, dec, sr) + " attempt " + count + " failed");
                        lastError = e;
                        continue;
                    }
                }
                throw (IOException)new IOException(nTry + " attempts failed").initCause(lastError);
            }
        };
    }

    public static ConeErrorPolicy createAdviceAbortPolicy(String name, final String extraAdvice) {
        return new ConeErrorPolicy(name){

            @Override
            public StarTable performConeSearch(ConeSearcher cs, double ra, double dec, double sr) throws IOException, InterruptedException {
                try {
                    return ConeErrorPolicy.invokeConeSearcher(cs, ra, dec, sr);
                }
                catch (IOException e) {
                    throw (IOException)new IOException(extraAdvice).initCause(e);
                }
            }
        };
    }

    private static String searchString(double ra, double dec, double sr) {
        return new StringBuffer().append("search ").append('(').append((float)ra).append(", ").append((float)dec).append(')').append('+').append((float)sr).toString();
    }

    private static StarTable invokeConeSearcher(ConeSearcher cs, double ra, double dec, double sr) throws IOException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        StarTable table = cs.performSearch(ra, dec, sr);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return table;
    }
}

