/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.ConeErrorPolicy;

public class ConeErrorPolicyParameter
extends Parameter<ConeErrorPolicy> {
    private static final ConeErrorPolicy[] FIXED_POLICIES = new ConeErrorPolicy[]{ConeErrorPolicy.ABORT, ConeErrorPolicy.IGNORE, ConeErrorPolicy.RETRY};
    private static final String RETRY_PREFIX = ConeErrorPolicy.RETRY.toString();

    public ConeErrorPolicyParameter(String name) {
        super(name, ConeErrorPolicy.class, true);
        StringBuffer ubuf = new StringBuffer();
        for (int i = 0; i < FIXED_POLICIES.length; ++i) {
            if (i > 0) {
                ubuf.append('|');
            }
            ubuf.append(FIXED_POLICIES[i].toString());
        }
        ubuf.append('|').append(RETRY_PREFIX).append("<n>");
        this.setUsage(ubuf.toString());
        this.setPrompt("Action on cone search failure");
        this.setStringDefault(ConeErrorPolicy.ABORT.toString());
        this.setDescription(new String[]{"<p>Determines what will happen if any of the individual cone", "search requests fails.  By default the task aborts.", "That may be the best thing to do, but for unreliable or", "poorly implemented services you may find that some searches", "fail and others succeed so it can be best to continue", "operation in the face of a few failures.", "The options are:", "<ul>", "<li><code>" + ConeErrorPolicy.ABORT.toString() + "</code>:", "failure of any query terminates the task", "</li>", "<li><code>" + ConeErrorPolicy.IGNORE.toString() + "</code>:", "failure of a query is treated the same as a query which", "returns no rows", "</li>", "<li><code>" + ConeErrorPolicy.RETRY.toString() + "</code>:", "failed queries are retried until they succeed;", "use with care - if the failure is for some good, or at least", "reproducible reason this could prevent the task from ever", "completing", "</li>", "<li><code>" + RETRY_PREFIX + "&lt;n&gt;" + "</code>:", "failed queries are retried at most a fixed number", "<code>&lt;n&gt;</code> of times", "If they still fail the task terminates.", "</li>", "</ul>", "</p>"});
    }

    public ConeErrorPolicy policyValue(Environment env) throws TaskException {
        return (ConeErrorPolicy)this.objectValue(env);
    }

    public ConeErrorPolicy stringToObject(Environment env, String stringVal) throws TaskException {
        for (int i = 0; i < FIXED_POLICIES.length; ++i) {
            ConeErrorPolicy policy = FIXED_POLICIES[i];
            if (!policy.toString().equalsIgnoreCase(stringVal)) continue;
            return policy;
        }
        if (stringVal.toLowerCase().startsWith(RETRY_PREFIX.toLowerCase())) {
            int nTry;
            String numString = stringVal.substring(RETRY_PREFIX.length());
            try {
                nTry = Integer.parseInt(numString);
                if (nTry <= 0) {
                    throw new ParameterValueException((Parameter)this, nTry + " out of range");
                }
            }
            catch (NumberFormatException e) {
                throw new ParameterValueException((Parameter)this, "\"" + numString + "\" not numeric");
            }
            return ConeErrorPolicy.createRetryPolicy(stringVal, nTry);
        }
        throw new ParameterValueException((Parameter)this, "Unknown error action " + stringVal);
    }
}

