/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.net.URL;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.task.URLParameter;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.Coner;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.cone.ServiceConeSearcher;
import uk.ac.starlink.ttools.cone.SiaConeSearcher;
import uk.ac.starlink.ttools.cone.SsaConeSearcher;
import uk.ac.starlink.ttools.cone.UrlMocCoverage;
import uk.ac.starlink.ttools.task.ContentCodingParameter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.ConeSearch;

public class ConeSearchConer
implements Coner {
    private final URLParameter urlParam_;
    private final ChoiceParameter<String> verbParam_;
    private final ChoiceParameter<ServiceType> serviceParam_;
    private final BooleanParameter believeemptyParam_;
    private final ContentCodingParameter codingParam_;
    private final StringParameter formatParam_;
    private int nside_ = -1;
    private static final String BELIEVE_EMPTY_NAME = "emptyok";
    private static final String INCONSISTENT_EMPTY_ADVICE = "emptyok=false";

    public ConeSearchConer() {
        Object[] serviceTypes = new ServiceType[]{new ConeServiceType(), new SiaServiceType(), new SsaServiceType()};
        this.urlParam_ = new URLParameter("serviceurl");
        this.urlParam_.setPrompt("Base URL for query returning VOTable");
        this.urlParam_.setDescription(new String[]{"<p>The base part of a URL which defines the queries to be made.", "Additional parameters will be appended to this using CGI syntax", "(\"<code>name=value</code>\", separated by '&amp;' characters).", "If this value does not end in either a '?' or a '&amp;',", "one will be added as appropriate.", "</p>", "<p>See <ref id='coneService'/> for discussion of how to locate", "service URLs corresponding to given datasets.", "</p>"});
        this.serviceParam_ = new ChoiceParameter("servicetype", serviceTypes);
        this.serviceParam_.setPrompt("Search service type");
        StringBuffer typesDescrip = new StringBuffer();
        for (int i = 0; i < serviceTypes.length; ++i) {
            Object stype = serviceTypes[i];
            typesDescrip.append("<li>").append("<code>").append(stype).append("</code>:\n").append(((ServiceType)stype).getDescription()).append("</li>").append("\n");
        }
        this.serviceParam_.setDescription(new String[]{"<p>Selects the type of data access service to contact.", "Most commonly this will be the Cone Search service itself,", "but there are one or two other possibilities:", "<ul>", typesDescrip.toString(), "</ul>", "</p>"});
        this.serviceParam_.setDefaultOption(serviceTypes[0]);
        this.verbParam_ = new ChoiceParameter("verb", (Object[])new String[]{"1", "2", "3"});
        this.verbParam_.setNullPermitted(true);
        this.verbParam_.setPrompt("Verbosity level of search responses (1..3)");
        this.verbParam_.setDescription(new String[]{"<p>Verbosity level of the tables returned by the query service.", "A value of 1 indicates the bare minimum and", "3 indicates all available information.", "</p>"});
        this.believeemptyParam_ = new BooleanParameter(BELIEVE_EMPTY_NAME);
        this.believeemptyParam_.setBooleanDefault(true);
        this.believeemptyParam_.setPrompt("Believe metadata from empty results?");
        this.believeemptyParam_.setDescription(new String[]{"<p>Whether the table metadata which is returned from a search", "result with zero rows is to be believed.", "According to the spirit, though not the letter, of the", "cone search standard, a cone search service which returns no data", "ought nevertheless to return the correct column headings.", "Unfortunately this is not always the case.", "If this parameter is set <code>true</code>, it is assumed", "that the service behaves properly in this respect; if it does not", "an error may result.  In that case, set this parameter", "<code>false</code>.  A consequence of setting it false is that", "in the event of no results being returned, the task will", "return no table at all, rather than an empty one.", "</p>"});
        this.codingParam_ = new ContentCodingParameter();
        this.formatParam_ = new StringParameter("dataformat");
        this.formatParam_.setPrompt("Data format type for DAL outputs");
        this.formatParam_.setNullPermitted(true);
        StringBuffer formatsDescrip = new StringBuffer();
        for (int i = 0; i < serviceTypes.length; ++i) {
            Object stype = serviceTypes[i];
            formatsDescrip.append("<li>").append("<code>").append(this.serviceParam_.getName()).append("=").append(stype).append("</code>:\n").append(((ServiceType)stype).getFormatDescription()).append("</li>").append("\n");
        }
        this.formatParam_.setDescription(new String[]{"<p>Indicates the format of data objects described in the", "returned table.", "The meaning of this is dependent on the value of the", "<code>" + this.serviceParam_.getName() + "</code>", "parameter:", "<ul>", formatsDescrip.toString(), "</ul>", "</p>"});
    }

    @Override
    public String getSkySystem() {
        return "ICRS";
    }

    @Override
    public Parameter[] getParameters() {
        return new Parameter[]{this.serviceParam_, this.urlParam_, this.verbParam_, this.formatParam_, this.believeemptyParam_, this.codingParam_};
    }

    @Override
    public void configureParams(Environment env, Parameter srParam) throws TaskException {
        ((ServiceType)this.serviceParam_.objectValue(env)).configureParams(srParam);
    }

    @Override
    public boolean useDistanceFilter(Environment env) throws TaskException {
        return ((ServiceType)this.serviceParam_.objectValue(env)).useDistanceFilter();
    }

    @Override
    public ConeSearcher createSearcher(Environment env, boolean bestOnly) throws TaskException {
        ServiceType serviceType = (ServiceType)this.serviceParam_.objectValue(env);
        URL url = (URL)this.urlParam_.objectValue(env);
        boolean believeEmpty = this.believeemptyParam_.booleanValue(env);
        StarTableFactory tfact = LineTableEnvironment.getTableFactory(env);
        ContentCoding coding = this.codingParam_.codingValue(env);
        return serviceType.createSearcher(env, url.toString(), believeEmpty, tfact, coding);
    }

    @Override
    public Coverage getCoverage(Environment env) throws TaskException {
        ServiceType serviceType = (ServiceType)this.serviceParam_.objectValue(env);
        URL url = (URL)this.urlParam_.objectValue(env);
        return serviceType.getCoverage(url, this.nside_);
    }

    public void setNside(int nside) {
        this.nside_ = nside;
    }

    private class SsaServiceType
    extends ServiceType {
        SsaServiceType() {
            super("ssa");
        }

        @Override
        String getDescription() {
            return new StringBuffer().append("Simple Spectral Access protocol ").append(" - returns a table of spectra near each location.\n").append("See <webref url='").append("http://www.ivoa.net/Documents/latest/SSA.html").append("'>SSA standard</webref>.").toString();
        }

        @Override
        String getFormatDescription() {
            return new StringBuffer().append("gives the MIME type of spectra referenced in the ").append("output table, also special values ").append("\"<code>votable</code>\", ").append("\"<code>fits</code>\", ").append("\"<code>compliant</code>\", ").append("\"<code>graphic</code>\", ").append("\"<code>all</code>\", and others\n").append("(value of the SSA FORMAT parameter).").toString();
        }

        @Override
        public void configureParams(Parameter srParam) {
            srParam.setNullPermitted(true);
        }

        @Override
        public boolean useDistanceFilter() {
            return true;
        }

        @Override
        public ConeSearcher createSearcher(Environment env, String url, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            String format = ConeSearchConer.this.formatParam_.stringValue(env);
            return new SsaConeSearcher(url, format, believeEmpty, tfact, coding){

                @Override
                protected String getInconsistentEmptyAdvice() {
                    return ConeSearchConer.INCONSISTENT_EMPTY_ADVICE;
                }
            };
        }

        @Override
        public Coverage getCoverage(URL url, int nside) {
            return null;
        }
    }

    private class SiaServiceType
    extends ServiceType {
        SiaServiceType() {
            super("sia");
        }

        @Override
        String getDescription() {
            return new StringBuffer().append("Simple Image Access protocol ").append("- returns a table of images near each location.\n").append("See <webref url='").append("http://www.ivoa.net/Documents/latest/SIA.html").append("'>SIA standard</webref>.").toString();
        }

        @Override
        String getFormatDescription() {
            return new StringBuffer().append("gives the MIME type of images referenced in the ").append("output table, also special values ").append("\"<code>GRAPHIC</code>\" and \"<code>ALL</code>\".").append("(value of the SIA FORMAT parameter)").toString();
        }

        @Override
        public void configureParams(Parameter srParam) {
            srParam.setStringDefault("0");
            srParam.setNullPermitted(false);
        }

        @Override
        public boolean useDistanceFilter() {
            return false;
        }

        @Override
        public ConeSearcher createSearcher(Environment env, String url, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            ConeSearchConer.this.formatParam_.setStringDefault("image/fits");
            String format = ConeSearchConer.this.formatParam_.stringValue(env);
            return new SiaConeSearcher(url, format, believeEmpty, tfact, coding){

                @Override
                protected String getInconsistentEmptyAdvice() {
                    return ConeSearchConer.INCONSISTENT_EMPTY_ADVICE;
                }
            };
        }

        @Override
        public Coverage getCoverage(URL url, int nside) {
            return null;
        }
    }

    private class ConeServiceType
    extends ServiceType {
        ConeServiceType() {
            super("cone");
        }

        @Override
        String getDescription() {
            return new StringBuffer().append("Cone Search protocol ").append("- returns a table of objects found ").append("near each location.\n").append("See <webref url='").append("http://www.ivoa.net/Documents/latest/ConeSearch.html").append("'>Cone Search standard</webref>.").toString();
        }

        @Override
        String getFormatDescription() {
            return "not used";
        }

        @Override
        public void configureParams(Parameter srParam) {
            srParam.setNullPermitted(false);
        }

        @Override
        public boolean useDistanceFilter() {
            return true;
        }

        @Override
        public ConeSearcher createSearcher(Environment env, String url, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) throws TaskException {
            return new ServiceConeSearcher(new ConeSearch(url, coding), this.getVerbosity(env), believeEmpty, tfact){

                @Override
                protected String getInconsistentEmptyAdvice() {
                    return ConeSearchConer.INCONSISTENT_EMPTY_ADVICE;
                }
            };
        }

        @Override
        public Coverage getCoverage(URL url, int nside) {
            return UrlMocCoverage.getServiceMoc(url, nside);
        }
    }

    private abstract class ServiceType {
        private final String name_;

        ServiceType(String name) {
            this.name_ = name;
        }

        abstract String getDescription();

        abstract String getFormatDescription();

        abstract void configureParams(Parameter var1);

        abstract boolean useDistanceFilter();

        abstract ConeSearcher createSearcher(Environment var1, String var2, boolean var3, StarTableFactory var4, ContentCoding var5) throws TaskException;

        abstract Coverage getCoverage(URL var1, int var2);

        public String toString() {
            return this.name_;
        }

        int getVerbosity(Environment env) throws TaskException {
            String sverb = ConeSearchConer.this.verbParam_.stringValue(env);
            if (sverb == null) {
                return -1;
            }
            try {
                return Integer.parseInt(sverb);
            }
            catch (NumberFormatException e) {
                assert (false);
                throw new ParameterValueException((Parameter)ConeSearchConer.this.verbParam_, e.getMessage(), (Throwable)e);
            }
        }
    }
}

