/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.cone.AngleUnits;
import uk.ac.starlink.ttools.cone.SkyBox;
import uk.ac.starlink.ttools.cone.SkyTiling;

public abstract class ConeSelector {
    private final double unitFactor_;
    final String preamble_;
    final String postamble_;
    final RangeClause decClause_;
    final RangeClause middleRaClause_;
    final RangeClause equinoxRaClause_;
    private static final RaRegime ALL_REGIME = new RaRegime("all");
    private static final RaRegime MIDDLE_REGIME = new RaRegime("middle");
    private static final RaRegime EQUINOX_REGIME = new RaRegime("equinox");
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");

    protected ConeSelector(Connection connection, String tableName, String raCol, String decCol, AngleUnits units, String cols, String where) throws SQLException {
        this.unitFactor_ = units.getCircle() / AngleUnits.DEGREES.getCircle();
        String quote = connection.getMetaData().getIdentifierQuoteString();
        this.preamble_ = new StringBuffer().append("SELECT").append(' ').append(cols).append(' ').append("FROM").append(' ').append(tableName).append(' ').append("WHERE").append(' ').toString();
        this.postamble_ = where != null && where.trim().length() > 0 ? new StringBuffer().append(' ').append("AND ( ").append(where).append(" )").toString() : "";
        this.decClause_ = new BetweenClause(quote + decCol + quote);
        this.middleRaClause_ = new BetweenClause(quote + raCol + quote);
        this.equinoxRaClause_ = new OutsideClause(quote + raCol + quote);
    }

    public abstract ResultSet executeQuery(double var1, double var3, double var5) throws SQLException;

    double fromDegrees(double angle) {
        return this.unitFactor_ * angle;
    }

    public static ConeSelector createSelector(Connection connection, String tableName, String raCol, String decCol, AngleUnits units, String cols, String where, boolean usePrepared) throws SQLException {
        if (usePrepared) {
            return new PreparedSelector(connection, tableName, raCol, decCol, units, cols, where, 0, null){

                @Override
                protected void setExtraParameters(PreparedStatement stmt, int ipar, double ra, double dec, double sr) {
                }
            };
        }
        return new UnpreparedSelector(connection, tableName, raCol, decCol, units, cols, where){

            @Override
            protected String getExtraClause(double ra, double dec, double sr) {
                return null;
            }
        };
    }

    public static ConeSelector createTiledSelector(Connection connection, String tableName, String raCol, String decCol, AngleUnits units, String cols, String where, String tileCol, final SkyTiling tiling, boolean usePrepared) throws SQLException {
        String quote = connection.getMetaData().getIdentifierQuoteString();
        final BetweenClause tileClause = new BetweenClause(quote + tileCol + quote);
        if (usePrepared) {
            return new PreparedSelector(connection, tableName, raCol, decCol, units, cols, where, 2, tileClause.toSql("?", "?")){

                @Override
                protected void setExtraParameters(PreparedStatement stmt, int ipar, double ra, double dec, double sr) throws SQLException {
                    long hitile;
                    long[] range = tiling.getTileRange(ra, dec, sr);
                    long lotile = range == null ? Long.MIN_VALUE : range[0];
                    long l = hitile = range == null ? Long.MAX_VALUE : range[1];
                    if (range != null) {
                        logger_.info(tileClause.toSql(Long.toString(lotile), Long.toString(hitile)));
                    }
                    stmt.setLong(++ipar, lotile);
                    stmt.setLong(++ipar, hitile);
                }
            };
        }
        return new UnpreparedSelector(connection, tableName, raCol, decCol, units, cols, where){

            @Override
            protected String getExtraClause(double ra, double dec, double sr) {
                long[] range = tiling.getTileRange(ra, dec, sr);
                return range == null ? null : tileClause.toSql(Long.toString(range[0]), Long.toString(range[1]));
            }
        };
    }

    private static SkyBox getConeBoxDegrees(double ra, double dec, double sr) {
        return SkyBox.getConeBox(Math.toRadians(ra), Math.toRadians(dec), Math.toRadians(sr)).toDegrees();
    }

    private static RaRegime getRegime(double[] raRange) {
        double ra1 = raRange[0];
        double ra2 = raRange[1];
        if (ra1 <= 0.0 && ra2 >= 360.0) {
            return ALL_REGIME;
        }
        if (ra1 < 0.0 || ra2 > 360.0) {
            throw new IllegalArgumentException();
        }
        if (ra1 <= ra2) {
            return MIDDLE_REGIME;
        }
        if (ra1 > ra2) {
            return EQUINOX_REGIME;
        }
        throw new AssertionError();
    }

    private static class RaRegime {
        private final String name_;

        private RaRegime(String name) {
            this.name_ = name;
        }
    }

    private static class OutsideClause
    extends RangeClause {
        OutsideClause(String value) {
            super("( " + value + " > ", " OR " + value + " < ", " )");
        }
    }

    private static class BetweenClause
    extends RangeClause {
        BetweenClause(String value) {
            super("( " + value + " BETWEEN ", " AND ", " )");
        }
    }

    private static class RangeClause {
        private final String pre_;
        private final String mid_;
        private final String post_;

        RangeClause(String pre, String mid, String post) {
            this.pre_ = pre;
            this.mid_ = mid;
            this.post_ = post;
        }

        public String toSql(String x1, String x2) {
            return new StringBuffer().append(this.pre_).append(x1).append(this.mid_).append(x2).append(this.post_).toString();
        }
    }

    private static abstract class PreparedSelector
    extends ConeSelector {
        private PreparedStatement allRaStatement_;
        private PreparedStatement middleRaStatement_;
        private PreparedStatement equinoxRaStatement_;
        private final int nExtraParams_;

        PreparedSelector(Connection connection, String tableName, String raCol, String decCol, AngleUnits units, String cols, String where, int nExtraParams, String extraTemplate) throws SQLException {
            super(connection, tableName, raCol, decCol, units, cols, where);
            this.nExtraParams_ = nExtraParams;
            StringBuffer allRaBuf = new StringBuffer(this.preamble_);
            if (extraTemplate != null && extraTemplate.length() > 0) {
                allRaBuf.append("( ").append(extraTemplate).append(" )").append(" AND ");
            }
            allRaBuf.append(this.decClause_.toSql("?", "?"));
            String allRaSql = allRaBuf.toString();
            String middleRaSql = new StringBuffer().append(allRaSql).append(" AND ").append(this.middleRaClause_.toSql("?", "?")).toString();
            String equinoxRaSql = new StringBuffer().append(allRaSql).append(" AND ").append(this.equinoxRaClause_.toSql("?", "?")).toString();
            logger_.info(allRaSql);
            this.allRaStatement_ = connection.prepareStatement(allRaSql);
            logger_.info(middleRaSql);
            this.middleRaStatement_ = connection.prepareStatement(middleRaSql);
            logger_.info(equinoxRaSql);
            this.equinoxRaStatement_ = connection.prepareStatement(equinoxRaSql);
        }

        protected abstract void setExtraParameters(PreparedStatement var1, int var2, double var3, double var5, double var7) throws SQLException;

        @Override
        public ResultSet executeQuery(double ra, double dec, double sr) throws SQLException {
            boolean useRa;
            PreparedStatement stmt;
            SkyBox coneBox = ConeSelector.getConeBoxDegrees(ra, dec, sr);
            double ra1 = this.fromDegrees(coneBox.getRaRange()[0]);
            double ra2 = this.fromDegrees(coneBox.getRaRange()[1]);
            double dec1 = this.fromDegrees(coneBox.getDecRange()[0]);
            double dec2 = this.fromDegrees(coneBox.getDecRange()[1]);
            RaRegime regime = ConeSelector.getRegime(coneBox.getRaRange());
            if (regime == ALL_REGIME) {
                stmt = this.allRaStatement_;
                useRa = false;
            } else if (regime == MIDDLE_REGIME) {
                stmt = this.middleRaStatement_;
                logger_.info(this.middleRaClause_.toSql(Double.toString(ra1), Double.toString(ra2)));
                useRa = true;
            } else if (regime == EQUINOX_REGIME) {
                stmt = this.equinoxRaStatement_;
                logger_.info(this.equinoxRaClause_.toSql(Double.toString(ra1), Double.toString(ra2)));
                useRa = true;
            } else {
                throw new AssertionError();
            }
            stmt.clearParameters();
            int ipar = 0;
            this.setExtraParameters(stmt, ipar, ra, dec, sr);
            ipar += this.nExtraParams_;
            logger_.info(this.decClause_.toSql(Double.toString(dec1), Double.toString(dec2)));
            stmt.setDouble(++ipar, dec1);
            stmt.setDouble(++ipar, dec2);
            if (useRa) {
                stmt.setDouble(++ipar, ra1);
                stmt.setDouble(++ipar, ra2);
            }
            assert (stmt.getParameterMetaData().getParameterCount() == ipar);
            return stmt.executeQuery();
        }
    }

    private static abstract class UnpreparedSelector
    extends ConeSelector {
        private final Statement stmt_;

        UnpreparedSelector(Connection connection, String tableName, String raCol, String decCol, AngleUnits units, String cols, String where) throws SQLException {
            super(connection, tableName, raCol, decCol, units, cols, where);
            this.stmt_ = connection.createStatement();
        }

        protected abstract String getExtraClause(double var1, double var3, double var5);

        @Override
        public ResultSet executeQuery(double ra, double dec, double sr) throws SQLException {
            StringBuffer sqlBuf = new StringBuffer(this.preamble_);
            String extra = this.getExtraClause(ra, dec, sr);
            if (extra != null && extra.trim().length() > 0) {
                sqlBuf.append("( ").append(extra).append(" )").append(" AND ");
            }
            SkyBox coneBox = ConeSelector.getConeBoxDegrees(ra, dec, sr);
            RaRegime regime = ConeSelector.getRegime(coneBox.getRaRange());
            double ra1 = this.fromDegrees(coneBox.getRaRange()[0]);
            double ra2 = this.fromDegrees(coneBox.getRaRange()[1]);
            if (regime != ALL_REGIME) {
                if (regime == MIDDLE_REGIME) {
                    sqlBuf.append(this.middleRaClause_.toSql(Double.toString(ra1), Double.toString(ra2))).append(" AND ");
                } else if (regime == EQUINOX_REGIME) {
                    sqlBuf.append(this.equinoxRaClause_.toSql(Double.toString(ra1), Double.toString(ra2))).append(" AND ");
                }
            }
            double dec1 = this.fromDegrees(coneBox.getDecRange()[0]);
            double dec2 = this.fromDegrees(coneBox.getDecRange()[1]);
            sqlBuf.append(this.decClause_.toSql(Double.toString(dec1), Double.toString(dec2)));
            String sql = sqlBuf.toString();
            logger_.info(sql);
            return this.stmt_.executeQuery(sql);
        }
    }
}

