/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class DalConeSearcher {
    private final boolean believeEmpty_;
    private final String stdName_;
    private final String stdVers_;
    private Class[] colTypes_;
    private Boolean typesFromEmpty_;
    private boolean warned_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");

    public DalConeSearcher(String stdName, String stdVers, boolean believeEmpty) {
        this.believeEmpty_ = believeEmpty;
        this.stdName_ = stdName;
        this.stdVers_ = stdVers;
    }

    protected StarTable getConsistentTable(StarTable table) throws IOException {
        boolean isEmpty = DalConeSearcher.isEmpty(table = Tables.randomTable((StarTable)table));
        if (isEmpty && !this.believeEmpty_) {
            return null;
        }
        Object[] ctypes = DalConeSearcher.getColumnTypes(table);
        if (this.colTypes_ == null) {
            this.colTypes_ = ctypes;
            this.typesFromEmpty_ = isEmpty;
        }
        assert (this.colTypes_ != null);
        assert (this.typesFromEmpty_ != null);
        boolean isConsistent = Arrays.equals(this.colTypes_, ctypes);
        if (isConsistent) {
            return table;
        }
        if (this.typesFromEmpty_.booleanValue() && !isEmpty) {
            String message = "Non-empty and empty queries to the same service seem to return incompatible tables - " + this.getInconsistentEmptyAdvice();
            if (!this.warned_) {
                logger_.warning(message);
            }
            throw new IOException(message);
        }
        throw new IOException("Different queries to the same service return incompatible tables");
    }

    public int getUcd1RaIndex(StarTable table) {
        ColumnInfo info;
        int icol;
        String raUcd1 = "POS_EQ_RA_MAIN";
        for (icol = 0; icol < table.getColumnCount(); ++icol) {
            info = table.getColumnInfo(icol);
            if (!raUcd1.equals(info.getUCD())) continue;
            if (Number.class.isAssignableFrom(info.getContentClass())) {
                return icol;
            }
            logger_.warning("Non-numeric " + raUcd1 + " column");
        }
        logger_.warning("No " + raUcd1 + " column" + " (service violates " + this.stdName_ + " " + this.stdVers_ + " standard) - clutching at straws");
        for (icol = 0; icol < table.getColumnCount(); ++icol) {
            info = table.getColumnInfo(icol);
            if (!Number.class.isAssignableFrom(info.getContentClass())) continue;
            String ucd = info.getUCD();
            String name = info.getName();
            if (ucd != null && ucd.startsWith("pos.eq.ra")) {
                return icol;
            }
            if (name == null || !name.equalsIgnoreCase("ra") && !name.equalsIgnoreCase("ra2000")) continue;
            return icol;
        }
        return -1;
    }

    public int getUcd1DecIndex(StarTable table) {
        ColumnInfo info;
        int icol;
        String decUcd1 = "POS_EQ_DEC_MAIN";
        for (icol = 0; icol < table.getColumnCount(); ++icol) {
            info = table.getColumnInfo(icol);
            if (!decUcd1.equals(info.getUCD())) continue;
            if (Number.class.isAssignableFrom(info.getContentClass())) {
                return icol;
            }
            logger_.warning("Non-numeric " + decUcd1 + " column");
        }
        logger_.warning("No " + decUcd1 + " column" + " (service violates " + this.stdName_ + " " + this.stdVers_ + " standard) - clutching at straws");
        for (icol = 0; icol < table.getColumnCount(); ++icol) {
            info = table.getColumnInfo(icol);
            if (!Number.class.isAssignableFrom(info.getContentClass())) continue;
            String ucd = info.getUCD();
            String name = info.getName();
            if (ucd != null && ucd.startsWith("pos.eq.dec")) {
                return icol;
            }
            if (name == null || !name.equalsIgnoreCase("dec") && !name.equalsIgnoreCase("dec2000")) continue;
            return icol;
        }
        return -1;
    }

    protected String getInconsistentEmptyAdvice() {
        return "try believeEmpty=false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEmpty(StarTable table) throws IOException {
        long nr = table.getRowCount();
        if (nr >= 0L) {
            return nr == 0L;
        }
        RowSequence rseq = table.getRowSequence();
        try {
            boolean bl = rseq.next();
            return bl;
        }
        finally {
            rseq.close();
        }
    }

    private static Class[] getColumnTypes(StarTable table) {
        int ncol = table.getColumnCount();
        Class[] types = new Class[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            types[icol] = table.getColumnInfo(icol).getContentClass();
        }
        return types;
    }
}

