/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.SelectorStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.jdbc.SequentialResultSetStarTable;
import uk.ac.starlink.ttools.cone.AngleUnits;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.ConeSelector;
import uk.ac.starlink.ttools.cone.SkyTiling;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.filter.CalculatorColumnSupplement;
import uk.ac.starlink.ttools.filter.PermutedColumnSupplement;
import uk.ac.starlink.ttools.func.CoordsDegrees;

public class JdbcConeSearcher
implements ConeSearcher {
    private final ConeSelector selector_;
    private final String raCol_;
    private final String decCol_;
    private final AngleUnits units_;
    private final String tileCol_;
    private final SkyTiling tiling_;
    private final Connection connectionToClose_;
    private boolean first_ = true;
    private int raIndex_ = -1;
    private int decIndex_ = -1;
    private int raRsetIndex_ = -1;
    private int decRsetIndex_ = -1;
    private int tileRsetIndex_ = -1;
    private static final ValueInfo RADEG_INFO = new DefaultValueInfo("RA_DEGREES", Double.class, "Right ascension in degrees");
    private static final ValueInfo DECDEG_INFO = new DefaultValueInfo("DEC_DEGREES", Double.class, "Declination in degrees");
    private static final Logger logger_;

    public JdbcConeSearcher(Connection connection, String tableName, String raCol, String decCol, AngleUnits units, String tileCol, SkyTiling tiling, String cols, String where, boolean bestOnly, boolean prepareSql, boolean closeConnection) throws SQLException {
        this.raCol_ = raCol;
        this.decCol_ = decCol;
        this.units_ = units;
        this.tileCol_ = tileCol;
        this.tiling_ = tiling;
        this.connectionToClose_ = closeConnection ? connection : null;
        this.selector_ = tiling != null && tileCol != null ? ConeSelector.createTiledSelector(connection, tableName, raCol, decCol, units, cols, where, tileCol, tiling, prepareSql) : ConeSelector.createSelector(connection, tableName, raCol, decCol, units, cols, where, prepareSql);
    }

    @Override
    public StarTable performSearch(final double ra, final double dec, final double sr) throws IOException {
        boolean addDegCols;
        SequentialResultSetStarTable rsetTable;
        ResultSet rset;
        try {
            rset = this.selector_.executeQuery(ra, dec, sr);
        }
        catch (SQLException e) {
            throw (IOException)new IOException("Error executing SQL statement: " + e.getMessage()).initCause(e);
        }
        try {
            rsetTable = new SequentialResultSetStarTable(rset);
        }
        catch (SQLException e) {
            throw (IOException)new IOException("Error retrieving data from SQL statement: " + e.getMessage()).initCause(e);
        }
        int ncolRset = rsetTable.getColumnCount();
        boolean convertAngles = !AngleUnits.DEGREES.equals(this.units_);
        final double angleFactor = AngleUnits.DEGREES.getCircle() / this.units_.getCircle();
        if (this.first_) {
            this.first_ = false;
            try {
                this.raRsetIndex_ = rset.findColumn(this.raCol_) - 1;
                this.decRsetIndex_ = rset.findColumn(this.decCol_) - 1;
                if (convertAngles) {
                    this.raIndex_ = ncolRset;
                    this.decIndex_ = ncolRset + 1;
                } else {
                    this.raIndex_ = this.raRsetIndex_;
                    this.decIndex_ = this.decRsetIndex_;
                }
            }
            catch (SQLException e) {
                logger_.warning("Cannot identify ra/dec columns");
                this.raRsetIndex_ = -1;
                this.decRsetIndex_ = -1;
                this.raIndex_ = -1;
                this.decIndex_ = -1;
            }
            if (this.tileCol_ != null) {
                try {
                    this.tileRsetIndex_ = rset.findColumn(this.tileCol_) - 1;
                }
                catch (SQLException e) {
                    logger_.warning("Cannot identify tile column");
                    this.tileRsetIndex_ = -1;
                }
            }
        }
        SelectorStarTable coneTable = new SelectorStarTable((StarTable)rsetTable){

            public boolean isIncluded(RowSequence rseq) throws IOException {
                Object raCell = rseq.getCell(JdbcConeSearcher.this.raRsetIndex_);
                Object decCell = rseq.getCell(JdbcConeSearcher.this.decRsetIndex_);
                double rowRa = raCell instanceof Number ? ((Number)raCell).doubleValue() * angleFactor : Double.NaN;
                double rowDec = decCell instanceof Number ? ((Number)decCell).doubleValue() * angleFactor : Double.NaN;
                double dist = CoordsDegrees.skyDistanceDegrees(ra, dec, rowRa, rowDec);
                return !(dist > sr);
            }
        };
        ArrayList<ColumnInfo> outInfoList = new ArrayList<ColumnInfo>();
        boolean bl = addDegCols = convertAngles && this.raRsetIndex_ >= 0 && this.decRsetIndex_ >= 0;
        if (addDegCols) {
            outInfoList.add(new ColumnInfo(RADEG_INFO));
            outInfoList.add(new ColumnInfo(DECDEG_INFO));
        }
        final int nAddCol = outInfoList.size();
        final boolean hasTiles = this.tileRsetIndex_ >= 0;
        Object result = coneTable;
        if (nAddCol > 0 || hasTiles) {
            int[] nArray;
            if (hasTiles) {
                int[] nArray2 = new int[3];
                nArray2[0] = this.raRsetIndex_;
                nArray2[1] = this.decRsetIndex_;
                nArray = nArray2;
                nArray2[2] = this.tileRsetIndex_;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = this.raRsetIndex_;
                nArray = nArray3;
                nArray3[1] = this.decRsetIndex_;
            }
            int[] colMap = nArray;
            PermutedColumnSupplement radecSup = new PermutedColumnSupplement((StarTable)result, colMap);
            ColumnInfo[] addInfos = outInfoList.toArray(new ColumnInfo[0]);
            CalculatorColumnSupplement addSup = new CalculatorColumnSupplement(radecSup, addInfos){

                @Override
                protected Object[] calculate(Object[] inValues) {
                    long calcTile;
                    long gotTile;
                    Object raObj = inValues[0];
                    Object decObj = inValues[1];
                    Object tileObj = hasTiles ? inValues[2] : null;
                    Object[] calcValues = new Object[nAddCol];
                    int icol = 0;
                    double raDeg = 2.getDouble(raObj) * angleFactor;
                    double decDeg = 2.getDouble(decObj) * angleFactor;
                    if (addDegCols) {
                        calcValues[icol++] = new Double(raDeg);
                        calcValues[icol++] = new Double(decDeg);
                    }
                    if (hasTiles && (gotTile = ((Number)tileObj).longValue()) != (calcTile = JdbcConeSearcher.this.tiling_.getPositionTile(raDeg, decDeg))) {
                        logger_.warning("Tiling equivalence fails: " + calcTile + " != " + gotTile);
                    }
                    assert (icol == calcValues.length);
                    return calcValues;
                }
            };
            result = new AddColumnsTable((StarTable)result, addSup);
        }
        return result;
    }

    @Override
    public int getRaIndex(StarTable result) {
        return this.raIndex_;
    }

    @Override
    public int getDecIndex(StarTable result) {
        return this.decIndex_;
    }

    @Override
    public void close() {
        if (this.connectionToClose_ != null) {
            try {
                this.connectionToClose_.close();
            }
            catch (SQLException e) {
                logger_.warning("Error closing connection: " + e);
            }
        }
    }

    static {
        ((DefaultValueInfo)RADEG_INFO).setUnitString("deg");
        ((DefaultValueInfo)DECDEG_INFO).setUnitString("deg");
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");
    }
}

