/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.AngleUnits;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.Coner;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.cone.JdbcConeSearcher;
import uk.ac.starlink.ttools.cone.SkyTiling;
import uk.ac.starlink.ttools.cone.TilingParameter;
import uk.ac.starlink.ttools.task.ConnectionParameter;

public class JdbcConer
implements Coner {
    private final ConnectionParameter connParam_;
    private final StringParameter dbtableParam_;
    private final StringParameter dbraParam_;
    private final StringParameter dbdecParam_;
    private final StringParameter dbtileParam_;
    private final TilingParameter tilingParam_;
    private final StringParameter colsParam_;
    private final StringParameter whereParam_;
    private final ChoiceParameter<AngleUnits> dbunitParam_;
    private final BooleanParameter prepareParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");

    public JdbcConer() {
        String sys = this.getSkySystem();
        sys = sys == null ? "" : sys + " ";
        this.connParam_ = new ConnectionParameter("db");
        this.dbtableParam_ = new StringParameter("dbtable");
        this.dbtableParam_.setUsage("<table-name>");
        this.dbtableParam_.setPrompt("Name of table in database");
        this.dbtableParam_.setDescription(new String[]{"<p>The name of the table in the SQL database which provides", "the remote data.", "</p>"});
        this.dbunitParam_ = new ChoiceParameter("dbunit", AngleUnits.class);
        this.dbunitParam_.addOption((Object)AngleUnits.DEGREES, "deg");
        this.dbunitParam_.addOption((Object)AngleUnits.RADIANS, "rad");
        this.dbunitParam_.setStringDefault("deg");
        this.dbunitParam_.setPrompt("Units of ra/dec values in database");
        this.dbunitParam_.setDescription(new String[]{"<p>Units of the right ascension and declination columns", "identified in the database table.", "May be either deg[rees] (the default) or rad[ians].", "</p>"});
        this.dbraParam_ = new StringParameter("dbra");
        this.dbraParam_.setUsage("<sql-col>");
        this.dbraParam_.setPrompt("Name of right ascension column in database");
        this.dbraParam_.setDescription(new String[]{"<p>The name of a column in the SQL database table", "<code>" + this.dbtableParam_.getName() + "</code>", "which gives the " + sys + "right ascension.", "Units are given by <code>" + this.dbunitParam_.getName() + "</code>.", "</p>"});
        this.dbdecParam_ = new StringParameter("dbdec");
        this.dbdecParam_.setUsage("<sql-col>");
        this.dbdecParam_.setPrompt("Name of declination column in database");
        this.dbdecParam_.setDescription(new String[]{"<p>The name of a column in the SQL database table", "<code>" + this.dbtableParam_.getName() + "</code>", "which gives the " + sys + "declination.", "Units are given by <code>" + this.dbunitParam_.getName() + "</code>.", "</p>"});
        this.tilingParam_ = new TilingParameter("tiling");
        this.dbtileParam_ = new StringParameter("dbtile");
        this.dbtileParam_.setUsage("<sql-col>");
        this.dbtileParam_.setNullPermitted(true);
        this.dbtileParam_.setPrompt("Name of tiling column in database");
        this.dbtileParam_.setDescription(new String[]{"<p>The name of a column in the SQL database table", "<code>" + this.dbtableParam_.getName() + "</code>", "which contains a sky tiling pixel index.", "The tiling scheme is given by the " + this.tilingParam_.getName(), "parameter.", "Use of a tiling column is optional, but if present", "(and if the column is indexed in the database table)", "it may serve to speed up searches.", "Set to null if the database table contains no tiling column", "or if you do not wish to use one.", "</p>"});
        this.colsParam_ = new StringParameter("selectcols");
        this.colsParam_.setUsage("<sql-cols>");
        this.colsParam_.setPrompt("Database columns to select");
        this.colsParam_.setDescription(new String[]{"<p>An SQL expression for the list of columns to be selected", "from the table in the database.", "A value of \"<code>*</code>\" retrieves all columns.", "</p>"});
        this.colsParam_.setStringDefault("*");
        this.whereParam_ = new StringParameter("where");
        this.whereParam_.setUsage("<sql-condition>");
        this.whereParam_.setPrompt("Additional WHERE restriction on selection");
        this.whereParam_.setNullPermitted(true);
        this.whereParam_.setDescription(new String[]{"<p>An SQL expression further limiting the rows to be selected", "from the database.  This will be combined with the constraints", "on position implied by the cone search centres and radii.", "The value of this parameter should just be a condition,", "it should not contain the <code>WHERE</code> keyword.", "A null value indicates no additional criteria.", "</p>"});
        this.prepareParam_ = new BooleanParameter("preparesql");
        this.prepareParam_.setPrompt("Use JDBC PreparedStatements?");
        this.prepareParam_.setDescription(new String[]{"<p>If true, the JDBC connection will use", "<code>PreparedStatement</code>s for the SQL SELECTs", "otherwise it will use simple <code>Statement</code>s.", "This is a tuning parameter and affects only performance.", "On some database/driver combinations it's a lot faster set", "false (the default); on others it may be faster, who knows?", "</p>"});
        this.prepareParam_.setBooleanDefault(false);
    }

    @Override
    public String getSkySystem() {
        return "";
    }

    @Override
    public Parameter[] getParameters() {
        ArrayList<Object> pList = new ArrayList<Object>();
        pList.add((Object)this.connParam_);
        pList.addAll(Arrays.asList(this.connParam_.getAssociatedParameters()));
        pList.add(this.dbtableParam_);
        pList.add(this.dbraParam_);
        pList.add(this.dbdecParam_);
        pList.add(this.dbunitParam_);
        pList.add((Object)this.tilingParam_);
        pList.add(this.dbtileParam_);
        pList.add(this.colsParam_);
        pList.add(this.whereParam_);
        pList.add(this.prepareParam_);
        return pList.toArray(new Parameter[0]);
    }

    @Override
    public void configureParams(Environment env, Parameter srParam) {
    }

    @Override
    public boolean useDistanceFilter(Environment env) {
        return true;
    }

    @Override
    public ConeSearcher createSearcher(Environment env, boolean bestOnly) throws TaskException {
        Connection connection = (Connection)this.connParam_.objectValue(env);
        String table = this.dbtableParam_.stringValue(env);
        String raCol = this.dbraParam_.stringValue(env);
        String decCol = this.dbdecParam_.stringValue(env);
        String tileCol = this.dbtileParam_.stringValue(env);
        SkyTiling tiling = tileCol == null ? null : this.tilingParam_.tilingValue(env);
        AngleUnits units = (AngleUnits)this.dbunitParam_.objectValue(env);
        String cols = this.colsParam_.stringValue(env);
        String where = this.whereParam_.stringValue(env);
        boolean prepareSql = this.prepareParam_.booleanValue(env);
        if (where != null && where.toLowerCase().trim().startsWith("where")) {
            String msg = "Omit <code>WHERE</code> keyword from <code>" + this.whereParam_.getName() + "</code> parameter";
            throw new ParameterValueException((Parameter)this.whereParam_, msg);
        }
        try {
            return new JdbcConeSearcher(connection, table, raCol, decCol, units, tileCol, tiling, cols, where, bestOnly, prepareSql, true);
        }
        catch (SQLException e) {
            throw new TaskException("Error preparing SQL statement: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Coverage getCoverage(Environment env) {
        return null;
    }
}

