/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import cds.moc.HealpixImpl;
import cds.moc.HealpixMoc;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.cone.PixtoolsHealpix;

public abstract class MocCoverage
implements Coverage {
    private final HealpixImpl hpi_;
    private volatile HealpixMoc moc_;
    private volatile Coverage.Amount amount_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");

    protected MocCoverage(HealpixImpl hpi) {
        this.hpi_ = hpi;
    }

    protected abstract HealpixMoc createMoc() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initCoverage() throws IOException {
        if (this.amount_ == null) {
            assert (this.moc_ == null);
            try {
                this.moc_ = this.createMoc();
            }
            finally {
                this.amount_ = MocCoverage.determineAmount(this.moc_);
                assert (this.amount_ != null);
            }
        }
    }

    @Override
    public Coverage.Amount getAmount() {
        return this.amount_;
    }

    @Override
    public boolean discOverlaps(double alphaDeg, double deltaDeg, double radiusDeg) {
        this.checkInitialised();
        Boolean knownResult = this.amount_.getKnownResult();
        if (knownResult != null) {
            return knownResult;
        }
        int mocOrder = this.moc_.getMaxOrder();
        try {
            long centerPixel = this.hpi_.ang2pix(mocOrder, alphaDeg, deltaDeg);
            if (this.moc_.isIntersecting(mocOrder, centerPixel)) {
                return true;
            }
            if (radiusDeg == 0.0) {
                return false;
            }
            int discOrder = Math.min(PixtoolsHealpix.nsideToOrder(PixtoolsHealpix.getInstance().sizeToNside(radiusDeg)), mocOrder);
            long[] discPixels = this.hpi_.queryDisc(discOrder, alphaDeg, deltaDeg, radiusDeg);
            for (int i = 0; i < discPixels.length; ++i) {
                if (!this.moc_.isIntersecting(discOrder, discPixels[i])) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger_.log(Level.WARNING, "Unexpected MOC error - fail safe", e);
            return true;
        }
    }

    public HealpixMoc getMoc() {
        return this.moc_;
    }

    private void checkInitialised() {
        if (this.amount_ == null) {
            throw new IllegalStateException("Not initialised");
        }
    }

    static String summariseMoc(HealpixMoc moc) {
        return new StringBuffer().append("Amount: ").append((float)moc.getCoverage()).append(", ").append("Pixels: ").append(moc.getSize()).append(", ").append("Bytes: ").append(moc.getMem()).toString();
    }

    private static Coverage.Amount determineAmount(HealpixMoc moc) {
        if (moc == null) {
            return Coverage.Amount.NO_DATA;
        }
        double frac = moc.getCoverage();
        if (frac == 0.0) {
            return Coverage.Amount.NO_SKY;
        }
        if (frac == 1.0) {
            return Coverage.Amount.ALL_SKY;
        }
        return Coverage.Amount.SOME_SKY;
    }
}

