/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import cds.moc.HealpixImpl;
import gov.fnal.eag.healpix.PixTools;
import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Vector3d;

public class PixtoolsHealpix
implements HealpixImpl {
    private final PixTools pixTools_ = PixTools.getInstance();
    private static final PixtoolsHealpix instance_ = new PixtoolsHealpix();

    private PixtoolsHealpix() {
    }

    @Override
    public long ang2pix(int order, double lonDeg, double latDeg) {
        long nside = PixtoolsHealpix.orderToNside(order);
        double thetaRad = Math.toRadians(90.0 - latDeg);
        double phiRad = Math.toRadians(lonDeg);
        return this.pixTools_.ang2pix_nest(nside, thetaRad, phiRad);
    }

    @Override
    public double[] pix2ang(int order, long ipix) {
        double lonDeg;
        long nside = PixtoolsHealpix.orderToNside(order);
        double[] coords = this.pixTools_.pix2ang_nest(nside, ipix);
        double thetaRad = coords[0];
        double phiRad = coords[1];
        double latDeg = 90.0 - Math.toDegrees(thetaRad);
        coords[0] = lonDeg = Math.toDegrees(phiRad);
        coords[1] = latDeg;
        return coords;
    }

    @Override
    public long[] queryDisc(int order, double lonDeg, double latDeg, double radiusDeg) {
        long nside = PixtoolsHealpix.orderToNside(order);
        double thetaRad = Math.toRadians(90.0 - latDeg);
        double phiRad = Math.toRadians(lonDeg);
        double radiusRad = Math.toRadians(radiusDeg);
        Vector3d vec = this.pixTools_.Ang2Vec(thetaRad, phiRad);
        ArrayList pixList = this.pixTools_.query_disc(nside, vec, radiusRad, 1, 1);
        long[] pixs = new long[pixList.size()];
        int ip = 0;
        Iterator it = pixList.iterator();
        while (it.hasNext()) {
            pixs[ip++] = ((Number)it.next()).longValue();
        }
        assert (ip == pixs.length);
        return pixs;
    }

    public int sizeToNside(double sizeDeg) {
        return (int)this.pixTools_.GetNSide(sizeDeg * 3600.0);
    }

    public static long orderToNside(int order) {
        return 1L << order;
    }

    public static int nsideToOrder(long nside) {
        double order = Math.log(nside) / Math.log(2.0);
        int iorder = (int)order;
        if ((double)iorder == order) {
            return iorder;
        }
        throw new IllegalArgumentException("nside " + nside + " not a power of 2");
    }

    public static PixtoolsHealpix getInstance() {
        return instance_;
    }
}

