/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.cone.ConeErrorPolicy;
import uk.ac.starlink.ttools.cone.ConeMatcher;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.ConeResultRowSequence;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.Coverage;

public class SequentialResultRowSequence
implements ConeResultRowSequence {
    private final ConeQueryRowSequence querySeq_;
    private final ConeSearcher coneSearcher_;
    private final ConeErrorPolicy errAct_;
    private final Coverage coverage_;
    private final boolean bestOnly_;
    private final boolean distFilter_;
    private final String distanceCol_;
    private int nQuery_;
    private int nSkip_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.cone");

    public SequentialResultRowSequence(ConeQueryRowSequence querySeq, ConeSearcher coneSearcher, ConeErrorPolicy errAct, Coverage coverage, boolean bestOnly, boolean distFilter, String distanceCol) {
        this.querySeq_ = querySeq;
        this.coneSearcher_ = coneSearcher;
        this.errAct_ = errAct;
        this.coverage_ = coverage;
        this.bestOnly_ = bestOnly;
        this.distFilter_ = distFilter;
        this.distanceCol_ = distanceCol;
    }

    @Override
    public StarTable getConeResult() throws IOException {
        boolean excluded;
        double ra = this.querySeq_.getRa();
        double dec = this.querySeq_.getDec();
        double radius = this.querySeq_.getRadius();
        boolean bl = excluded = this.nQuery_ + this.nSkip_ > 0 && this.coverage_ != null && !this.coverage_.discOverlaps(ra, dec, radius);
        if (excluded) {
            Level level = Level.CONFIG;
            if (logger_.isLoggable(level)) {
                logger_.log(level, "Skipping cone query for point outside coverage (" + (float)ra + "," + (float)dec + ")+" + (float)radius);
            }
            ++this.nSkip_;
            return null;
        }
        ++this.nQuery_;
        return ConeMatcher.getConeResult(this.coneSearcher_, this.errAct_, this.bestOnly_, this.distFilter_, this.distanceCol_, ra, dec, radius);
    }

    public boolean next() throws IOException {
        return this.querySeq_.next();
    }

    public Object getCell(int icol) throws IOException {
        return this.querySeq_.getCell(icol);
    }

    public Object[] getRow() throws IOException {
        return this.querySeq_.getRow();
    }

    public void close() throws IOException {
        this.querySeq_.close();
        if (this.coverage_ != null) {
            logger_.info("Submitted " + this.nQuery_ + ", " + "skipped " + this.nSkip_ + " queries to service");
        }
    }

    @Override
    public double getDec() throws IOException {
        return this.querySeq_.getDec();
    }

    @Override
    public double getRa() throws IOException {
        return this.querySeq_.getRa();
    }

    @Override
    public double getRadius() throws IOException {
        return this.querySeq_.getRadius();
    }

    @Override
    public long getIndex() throws IOException {
        return this.querySeq_.getIndex();
    }
}

