/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import java.io.IOException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.ttools.cone.ConeSearcher;
import uk.ac.starlink.ttools.cone.DalConeSearcher;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.DalQuery;

public class SiaConeSearcher
extends DalConeSearcher
implements ConeSearcher {
    private final String serviceUrl_;
    private final String imgFormat_;
    private final StarTableFactory tfact_;
    private final ContentCoding coding_;

    public SiaConeSearcher(String serviceUrl, String imgFormat, boolean believeEmpty, StarTableFactory tfact, ContentCoding coding) {
        super("SIA", "1.0", believeEmpty);
        this.serviceUrl_ = serviceUrl;
        this.imgFormat_ = imgFormat;
        this.tfact_ = tfact;
        this.coding_ = coding;
    }

    @Override
    public StarTable performSearch(double ra, double dec, double sr) throws IOException {
        DalQuery query = new DalQuery(this.serviceUrl_, "SIA", ra, dec, sr * 2.0, this.coding_);
        if (this.imgFormat_ != null && this.imgFormat_.trim().length() > 0) {
            query.addArgument("FORMAT", this.imgFormat_);
        }
        StarTable table = query.execute(this.tfact_);
        return this.getConsistentTable(table);
    }

    @Override
    public int getRaIndex(StarTable result) {
        return this.getUcd1RaIndex(result);
    }

    @Override
    public int getDecIndex(StarTable result) {
        return this.getUcd1DecIndex(result);
    }

    @Override
    public void close() {
    }
}

