/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

public class SkyBox {
    private final double[] raRange_;
    private final double[] decRange_;

    SkyBox(double[] raRange, double[] decRange) {
        this.raRange_ = raRange;
        this.decRange_ = decRange;
    }

    public double[] getRaRange() {
        return this.raRange_;
    }

    public double[] getDecRange() {
        return this.decRange_;
    }

    public SkyBox toDegrees() {
        return new SkyBox(new double[]{Math.toDegrees(this.raRange_[0]), Math.toDegrees(this.raRange_[1])}, new double[]{Math.toDegrees(this.decRange_[0]), Math.toDegrees(this.decRange_[1])});
    }

    public SkyBox toRadians() {
        return new SkyBox(new double[]{Math.toRadians(this.raRange_[0]), Math.toRadians(this.raRange_[1])}, new double[]{Math.toRadians(this.decRange_[0]), Math.toRadians(this.decRange_[1])});
    }

    public static SkyBox getConeBox(double ra, double dec, double sr) {
        double[] raRange;
        double deltaDec = sr;
        double minDec = Math.max(dec - deltaDec, -1.5707963267948966);
        double maxDec = Math.min(dec + deltaDec, 1.5707963267948966);
        double[] decRange = new double[]{minDec, maxDec};
        assert (decRange[0] >= -1.5707963267948966 && decRange[0] <= 1.5707963267948966);
        assert (decRange[1] >= -1.5707963267948966 && decRange[1] <= 1.5707963267948966);
        double deltaRa = SkyBox.calculateDeltaRa(dec, sr);
        double minRa = ra - deltaRa;
        double maxRa = ra + deltaRa;
        if (deltaRa >= Math.PI) {
            raRange = new double[]{0.0, Math.PI * 2};
            assert (raRange[0] <= raRange[1]);
        } else if (minRa >= 0.0 && maxRa <= Math.PI * 2) {
            raRange = new double[]{minRa, maxRa};
            assert (raRange[0] <= raRange[1]);
        } else {
            double min = maxRa % (Math.PI * 2);
            double max = (minRa + Math.PI * 2) % (Math.PI * 2);
            raRange = new double[]{max, min};
            assert (raRange[0] >= raRange[1]);
        }
        assert (raRange[0] >= 0.0 && raRange[0] <= Math.PI * 2);
        assert (raRange[1] >= 0.0 && raRange[1] <= Math.PI * 2);
        return new SkyBox(raRange, decRange);
    }

    public static double calculateDeltaRa(double dec, double sr) {
        double hypArc = 1.5707963267948966 - Math.abs(dec);
        if (sr >= hypArc) {
            return Math.PI;
        }
        return Math.asin(Math.cos(1.5707963267948966 - sr) / Math.sin(hypArc));
    }
}

