/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cone;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.HealpixTiling;
import uk.ac.starlink.ttools.cone.HtmTiling;
import uk.ac.starlink.ttools.cone.SkyTiling;

public class TilingParameter
extends Parameter<SkyTiling> {
    private static final String HEALPIX_NEST_PREFIX2 = "hpx";
    private static final String HEALPIX_NEST_PREFIX = "healpixnest";
    private static final String HEALPIX_RING_PREFIX = "healpixring";
    private static final String HTM_PREFIX = "htm";

    public TilingParameter(String name) {
        super(name, SkyTiling.class, true);
        this.setPrompt("Sky tiling scheme");
        this.setUsage("hpx<K>|healpixnest<K>|healpixring<K>|htm<K>");
        this.setNullPermitted(true);
        this.setDescription(new String[]{"<p>Describes the sky tiling scheme that is in use.", "One of the following values may be used:", "<ul>", "<li><code>hpxK</code>:", "alias for <code>healpixnestK</code></li>", "<li><code>healpixnestK</code>:", "HEALPix using the Nest scheme at order <code>K</code></li>", "<li><code>healpixringK</code>:", "HEALPix using the Ring scheme at order <code>K</code></li>", "<li><code>htmK</code>:", "Hierarchical Triangular Mesh at level <code>K</code></li>", "</ul>", "So for instance", "<code>hpx5</code> or", "<code>healpixnest5</code>", "would both indicate the HEALPix NEST tiling scheme at order 5.", "</p>", "<p>At level K, there are 12*4^K HEALPix pixels,", "or 8*4^K HTM pixels on the sky.", "More information about these tiling schemes can be found at", "the <webref url='http://healpix.jpl.nasa.gov/'>HEALPix</webref>", "and <webref url='http://www.skyserver.org/htm/'>HTM</webref>", "web sites.", "</p>"});
    }

    public SkyTiling stringToObject(Environment env, String svalue) throws TaskException {
        String lvalue = svalue.toLowerCase();
        if (lvalue.startsWith(HEALPIX_NEST_PREFIX2)) {
            int k = this.getNumberSuffix(svalue, HEALPIX_NEST_PREFIX2);
            return new HealpixTiling(k, true);
        }
        if (lvalue.startsWith(HEALPIX_NEST_PREFIX)) {
            int k = this.getNumberSuffix(svalue, HEALPIX_NEST_PREFIX);
            return new HealpixTiling(k, true);
        }
        if (lvalue.startsWith(HEALPIX_RING_PREFIX)) {
            int k = this.getNumberSuffix(svalue, HEALPIX_RING_PREFIX);
            return new HealpixTiling(k, false);
        }
        if (lvalue.startsWith(HTM_PREFIX)) {
            int level = this.getNumberSuffix(svalue, HTM_PREFIX);
            return new HtmTiling(level);
        }
        throw new ParameterValueException((Parameter)this, "Unknown tiling scheme \"" + svalue + "\"");
    }

    public SkyTiling tilingValue(Environment env) throws TaskException {
        return (SkyTiling)this.objectValue(env);
    }

    public void setHealpixNestDefault(int k) {
        this.setStringDefault(k >= 0 ? HEALPIX_NEST_PREFIX2 + k : null);
    }

    private int getNumberSuffix(String value, String prefix) throws TaskException {
        String svalue = value.substring(prefix.length());
        try {
            return Integer.parseInt(svalue);
        }
        catch (NumberFormatException e) {
            throw new ParameterValueException((Parameter)this, "\"" + svalue + "\" " + "not numeric");
        }
    }
}

