/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.convert;

import java.util.Calendar;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.convert.Iso8601Converter;

public class Iso8601ToDecimalYear
extends Iso8601Converter {
    public Iso8601ToDecimalYear(ValueInfo isoInfo) {
        super(isoInfo, Iso8601ToDecimalYear.getDecimalYearInfo(isoInfo));
    }

    @Override
    protected double toMjd(double number) {
        return Iso8601ToDecimalYear.decYearToMjd(number);
    }

    @Override
    protected double fromMjd(double mjd) {
        return Iso8601ToDecimalYear.mjdToDecYear(mjd);
    }

    public String toString() {
        return "ISO-8601->Decimal year";
    }

    private static double decYearToMjd(double decYear) {
        int year = (int)Math.floor(decYear);
        double frac = decYear - (double)year;
        Calendar cal = Iso8601ToDecimalYear.getKit().calendar_;
        cal.clear();
        cal.set(1, year);
        long y0 = cal.getTimeInMillis();
        cal.set(1, year + 1);
        long y1 = cal.getTimeInMillis();
        long t = y0 + Math.round(frac * (double)(y1 - y0));
        return Iso8601ToDecimalYear.unixMillisToMjd(t);
    }

    private static double mjdToDecYear(double mjd) {
        Calendar cal = Iso8601ToDecimalYear.getKit().calendar_;
        cal.clear();
        long t = Iso8601ToDecimalYear.mjdToUnixMillis(mjd);
        cal.setTimeInMillis(t);
        int year = cal.get(1);
        cal.clear();
        cal.set(1, year);
        long y0 = cal.getTimeInMillis();
        cal.set(1, year + 1);
        long y1 = cal.getTimeInMillis();
        return (double)year + (double)(t - y0) / (double)(y1 - y0);
    }

    private static ValueInfo getDecimalYearInfo(ValueInfo isoInfo) {
        DefaultValueInfo numInfo = new DefaultValueInfo(isoInfo);
        numInfo.setContentClass(Double.class);
        numInfo.setUnitString("year");
        numInfo.setDescription("Decimal Year");
        numInfo.setNullable(true);
        return numInfo;
    }
}

