/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.copy;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.table.OnceRowPipe;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.UnrepeatableSequenceException;
import uk.ac.starlink.ttools.copy.SAXWriter;
import uk.ac.starlink.ttools.copy.SquashAttributeHandler;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.TableContentHandler;
import uk.ac.starlink.votable.TableHandler;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOTableVersion;

public class VotCopyHandler
implements ContentHandler,
LexicalHandler,
TableHandler {
    private final DataFormat format_;
    private final VOTableVersion version_;
    private final boolean inline_;
    private final boolean squashMagic_;
    private final String baseLoc_;
    private final boolean strict_;
    private final TableContentHandler votParser_;
    private final SAXWriter saxWriter_;
    private final ContentHandler discardHandler_;
    private final HandlerStack handlerStack_;
    private final TableHandler tableHandler_;
    private ContentHandler handler_;
    private BufferedWriter out_;
    private Locator locator_;
    private int iTable_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.copy");

    public VotCopyHandler(boolean strict, DataFormat format, VOTableVersion version, boolean inline, boolean squashMagic, String base, boolean cache, StoragePolicy policy) {
        if (!inline && base == null) {
            throw new IllegalArgumentException("Must specify base location for out-of-line tables");
        }
        this.format_ = format;
        this.version_ = version;
        this.inline_ = inline;
        this.squashMagic_ = squashMagic;
        this.baseLoc_ = base;
        this.strict_ = strict;
        this.votParser_ = new TableContentHandler(strict);
        this.votParser_.setReadHrefTables(true);
        this.votParser_.setTableHandler((TableHandler)this);
        this.saxWriter_ = new SAXWriter();
        this.discardHandler_ = new DefaultHandler();
        this.handlerStack_ = new HandlerStack();
        this.handler_ = this.saxWriter_;
        this.setOutput(new OutputStreamWriter(System.out));
        this.tableHandler_ = this.format_ == null ? new EmptyTableHandler() : (cache ? new CacheTableHandler(policy) : new StreamTableHandler());
    }

    public void setOutput(Writer out) {
        this.out_ = new BufferedWriter(out);
        this.saxWriter_.setOutput(this.out_);
    }

    public void startTable(StarTable meta) throws SAXException {
        assert (this.handler_ == this.discardHandler_);
        this.tableHandler_.startTable(meta);
    }

    public void rowData(Object[] row) throws SAXException {
        assert (this.handler_ == this.discardHandler_);
        this.tableHandler_.rowData(row);
    }

    public void endTable() throws SAXException {
        assert (this.handler_ == this.discardHandler_);
        this.tableHandler_.endTable();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
        this.votParser_.setDocumentLocator(locator);
        this.saxWriter_.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.votParser_.startDocument();
        this.saxWriter_.startDocument();
        this.iTable_ = 0;
    }

    @Override
    public void endDocument() throws SAXException {
        this.votParser_.endDocument();
        this.saxWriter_.endDocument();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.votParser_.startElement(namespaceURI, localName, qName, atts);
        if ("VOTABLE".equals(localName) && this.version_ != null) {
            AttributesImpl newAtts = new AttributesImpl(atts);
            VotCopyHandler.fixAttribute(newAtts, "version", this.version_.getVersionNumber());
            VotCopyHandler.fixAttribute(newAtts, "xmlns", this.version_.getXmlNamespace());
            int ixsl = newAtts.getIndex("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            if (ixsl >= 0) {
                newAtts.setValue(ixsl, this.version_.getXmlNamespace() + " " + this.version_.getSchemaLocation());
            }
            atts = newAtts;
        } else if ("DATA".equals(localName)) {
            this.handlerStack_.push(this.handler_);
            this.handler_ = this.discardHandler_;
            this.saxWriter_.flush();
        } else if ("FIELD".equals(localName)) {
            String datatype = atts.getValue("datatype");
            if ("bit".equals(datatype)) {
                AttributesImpl newAtts = new AttributesImpl(atts);
                int itype = newAtts.getIndex("datatype");
                newAtts.setValue(itype, "boolean");
                atts = newAtts;
                this.log(Level.WARNING, "FIELD datatype has been changed from bit to boolean");
            }
            if (("char".equals(datatype) || "unicodeChar".equals(datatype)) && atts.getValue("arraysize") == null) {
                String arraysize;
                if (this.strict_) {
                    arraysize = "1";
                    this.log(Level.INFO, "Inserted arraysize=\"1\" attribute to reduce confusion");
                } else {
                    arraysize = "*";
                    this.log(Level.WARNING, "Inserted assumed arrraysize=\"*\"attribute");
                }
                AttributesImpl newAtts = new AttributesImpl(atts);
                newAtts.addAttribute("", "arraysize", "arraysize", "CDATA", arraysize);
                atts = newAtts;
            }
        } else if ("VALUES".equals(localName) && this.squashMagic_) {
            this.handlerStack_.push(this.handler_);
            this.saxWriter_.flush();
            this.handler_ = new SquashAttributeHandler(this.out_, "null", true);
        }
        this.handler_.startElement(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.votParser_.endElement(namespaceURI, localName, qName);
        this.handler_.endElement(namespaceURI, localName, qName);
        if ("DATA".equals(localName)) {
            this.handler_ = this.handlerStack_.pop();
        } else if ("VALUES".equals(localName) && this.handler_ instanceof SquashAttributeHandler) {
            ((SquashAttributeHandler)this.handler_).flush();
            this.handler_ = this.handlerStack_.pop();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.votParser_.characters(ch, start, length);
        this.handler_.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.votParser_.ignorableWhitespace(ch, start, length);
        this.handler_.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.votParser_.startPrefixMapping(prefix, uri);
        this.handler_.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.votParser_.endPrefixMapping(prefix);
        this.handler_.endPrefixMapping(prefix);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.votParser_.skippedEntity(name);
        this.handler_.skippedEntity(name);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.votParser_.processingInstruction(target, data);
        this.handler_.processingInstruction(target, data);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.handler_ instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.handler_)).comment(ch, start, length);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.handler_ instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.handler_)).startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.handler_ instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.handler_)).endCDATA();
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.handlerStack_.push(this.handler_);
        this.handler_ = this.discardHandler_;
        if (this.handler_ instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.handler_)).startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.handler_ instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.handler_)).endDTD();
        }
        this.handler_ = this.handlerStack_.pop();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.handler_ instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.handler_)).startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.handler_ instanceof LexicalHandler) {
            ((LexicalHandler)((Object)this.handler_)).endEntity(name);
        }
    }

    public void writeDataElement(StarTable table) throws IOException {
        ++this.iTable_;
        VOTableVersion serVers = this.version_ != null ? this.version_ : VOTableVersion.V13;
        VOSerializer voser = VOSerializer.makeSerializer((DataFormat)this.format_, (VOTableVersion)serVers, (StarTable)table);
        String ext = this.format_ == DataFormat.BINARY ? ".bin" : (this.format_ == DataFormat.BINARY2 ? ".bin2" : (this.format_ == DataFormat.FITS ? ".fits" : null));
        if (ext != null && !this.inline_ && this.baseLoc_ != null) {
            File file = new File(this.baseLoc_ + "-" + this.iTable_ + ext);
            if (file.exists()) {
                this.log(Level.WARNING, "Overwriting file " + file + " for table " + this.iTable_ + " data");
            } else {
                this.log(Level.INFO, "Writing data for table " + this.iTable_ + " in file " + file);
            }
            String href = file.toString();
            DataOutputStream datstrm = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            voser.writeHrefDataElement(this.out_, href, (DataOutput)datstrm);
            datstrm.flush();
            datstrm.close();
        } else {
            voser.writeInlineDataElement(this.out_);
        }
    }

    private void log(Level level, String msg) {
        StringBuffer buf = new StringBuffer();
        if (this.locator_ != null) {
            int line = this.locator_.getLineNumber();
            int col = this.locator_.getColumnNumber();
            if (line >= 0) {
                buf.append("l." + line);
                if (col >= 0) {
                    buf.append(", c." + col);
                }
                buf.append(": ");
            }
        }
        buf.append(msg);
        logger_.log(level, buf.toString());
    }

    private static void fixAttribute(AttributesImpl atts, String name, String value) {
        int iatt = atts.getIndex(name);
        if (iatt >= 0) {
            atts.setValue(iatt, value);
        } else {
            atts.addAttribute("", name, name, "CDATA", value);
        }
    }

    private static class HandlerStack {
        private final List stack_ = new ArrayList();
        private ContentHandler top_;

        private HandlerStack() {
        }

        public void push(ContentHandler handler) {
            this.stack_.add(handler);
            this.top_ = handler;
        }

        public ContentHandler pop() {
            int n = this.stack_.size();
            this.top_ = n > 1 ? (ContentHandler)this.stack_.get(n - 2) : null;
            return (ContentHandler)this.stack_.remove(n - 1);
        }
    }

    private class CacheTableHandler
    implements TableHandler {
        private final StoragePolicy policy_;
        private RowStore rowStore_;

        public CacheTableHandler(StoragePolicy policy) {
            this.policy_ = policy;
        }

        public void startTable(StarTable meta) throws SAXException {
            assert (this.rowStore_ == null);
            this.rowStore_ = this.policy_.makeRowStore();
            try {
                this.rowStore_.acceptMetadata(meta);
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), VotCopyHandler.this.locator_).initCause(e);
            }
        }

        public void rowData(Object[] row) throws SAXException {
            try {
                this.rowStore_.acceptRow(row);
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), VotCopyHandler.this.locator_).initCause(e);
            }
        }

        public void endTable() throws SAXException {
            try {
                this.rowStore_.endRows();
                VotCopyHandler.this.writeDataElement(this.rowStore_.getStarTable());
                this.rowStore_ = null;
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), VotCopyHandler.this.locator_).initCause(e);
            }
        }
    }

    private class StreamTableHandler
    implements TableHandler {
        private Thread streamThread_;
        private OnceRowPipe streamStore_;
        private IOException error_;

        private StreamTableHandler() {
        }

        public void startTable(StarTable meta) throws SAXException {
            assert (this.streamThread_ == null);
            this.streamStore_ = new OnceRowPipe();
            this.streamStore_.acceptMetadata(meta);
            this.streamThread_ = new Thread("Table Streamer"){

                @Override
                public void run() {
                    try {
                        VotCopyHandler.this.writeDataElement(StreamTableHandler.this.streamStore_.waitForStarTable());
                    }
                    catch (IOException e) {
                        StreamTableHandler.this.error_ = e;
                    }
                }
            };
            this.streamThread_.start();
        }

        public void rowData(Object[] row) throws SAXException {
            try {
                this.streamStore_.acceptRow(row);
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), VotCopyHandler.this.locator_).initCause(e);
            }
        }

        public void endTable() throws SAXException {
            this.streamStore_.endRows();
            try {
                this.streamThread_.join();
            }
            catch (InterruptedException e) {
                throw (SAXException)new SAXParseException("Interrupted", VotCopyHandler.this.locator_).initCause(e);
            }
            this.streamThread_ = null;
            this.streamStore_ = null;
            if (this.error_ != null) {
                String msg = this.error_ instanceof UnrepeatableSequenceException ? "Can't stream, table requires multiple reads for metadata - try with caching" : this.error_.getMessage();
                throw (SAXException)new SAXParseException(msg, VotCopyHandler.this.locator_).initCause(this.error_);
            }
        }
    }

    private class EmptyTableHandler
    implements TableHandler {
        private EmptyTableHandler() {
        }

        public void startTable(StarTable meta) {
            try {
                VotCopyHandler.this.out_.write("<!-- no data -->");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void rowData(Object[] row) {
        }

        public void endTable() {
        }
    }
}

