/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.AsciiTableBuilder;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class AllWiseAsciiStarTable
extends StreamStarTable {
    private final StringBuffer cellBuf_ = new StringBuffer();
    private final DataSource datsrc_;
    private final URL schemaUrl_;
    private final long nrow_;
    private final int ncol_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.examples");
    private static final RowEvaluator.Decoder DOUBLE_DECODER = new WiseDecoder<Double>(Double.class){

        @Override
        Double decodeNonEmpty(String value) {
            return Double.valueOf(value);
        }

        @Override
        void attemptDecode(String value) {
            Double.parseDouble(value);
        }
    };
    private static final RowEvaluator.Decoder FLOAT_DECODER = new WiseDecoder<Float>(Float.class){

        @Override
        Float decodeNonEmpty(String value) {
            return Float.valueOf(value);
        }

        @Override
        void attemptDecode(String value) {
            Float.parseFloat(value);
        }
    };
    private static final RowEvaluator.Decoder SHORT_DECODER = new WiseDecoder<Short>(Short.class){

        @Override
        Short decodeNonEmpty(String value) {
            return Short.valueOf(value);
        }

        @Override
        void attemptDecode(String value) {
            Short.parseShort(value);
        }
    };
    private static final RowEvaluator.Decoder INT_DECODER = new WiseDecoder<Integer>(Integer.class){

        @Override
        Integer decodeNonEmpty(String value) {
            return Integer.valueOf(value);
        }

        @Override
        void attemptDecode(String value) {
            Integer.parseInt(value);
        }
    };
    private static final RowEvaluator.Decoder LONG_DECODER = new WiseDecoder<Long>(Long.class){

        @Override
        Long decodeNonEmpty(String value) {
            return Long.valueOf(value);
        }

        @Override
        void attemptDecode(String value) {
            Long.parseLong(value);
        }
    };
    private static final RowEvaluator.Decoder CHAR_DECODER = new RowEvaluator.Decoder(String.class){

        public Object decode(String value) {
            return value.length() == 0 ? null : value;
        }

        public boolean isValid(String value) {
            return true;
        }
    };

    public AllWiseAsciiStarTable(DataSource datsrc, URL schemaUrl, long nrow) throws IOException {
        this.datsrc_ = datsrc;
        this.schemaUrl_ = schemaUrl;
        this.nrow_ = nrow;
        this.init(datsrc);
        this.ncol_ = this.getColumnCount();
    }

    protected List readRow(PushbackInputStream in) throws TableFormatException, IOException {
        int icol = 0;
        this.cellBuf_.setLength(0);
        Object[] row = new Object[this.ncol_];
        boolean endsWithDelimiter = true;
        block5: while (true) {
            char c = (char)in.read();
            switch (c) {
                case '\uffff': {
                    return null;
                }
                case '\n': {
                    this.cellBuf_.setLength(0);
                    if (icol != this.ncol_) {
                        throw new TableFormatException("Wrong num of cols");
                    }
                    return Arrays.asList(row);
                }
                case '|': {
                    row[icol++] = this.cellBuf_.toString();
                    this.cellBuf_.setLength(0);
                    continue block5;
                }
            }
            this.cellBuf_.append(c);
        }
    }

    protected RowEvaluator.Metadata obtainMetadata() throws IOException {
        return this.readSchema(DataSource.makeDataSource((URL)this.schemaUrl_));
    }

    protected RowEvaluator.Metadata readSchema(DataSource datsrc) throws IOException {
        StarTable metaTable = new AsciiTableBuilder().makeStarTable(datsrc, true, StoragePolicy.PREFER_MEMORY);
        RowSequence rseq = metaTable.getRowSequence();
        Pattern typeRegex = Pattern.compile("([a-z0-9]+)(\\(([0-9,]+)\\))?");
        ArrayList<RowEvaluator.Decoder> decoderList = new ArrayList<RowEvaluator.Decoder>();
        ArrayList<ColumnInfo> infoList = new ArrayList<ColumnInfo>();
        while (rseq.next()) {
            RowEvaluator.Decoder decoder;
            Object[] row = rseq.getRow();
            String name = row[0].toString();
            String fulltype = row[1].toString();
            String unit = row[2].toString();
            String hasnull = row[3].toString();
            String descrip = row[4].toString();
            Matcher typeMatcher = typeRegex.matcher(fulltype);
            if (!typeMatcher.matches()) {
                throw new IOException("bad type: " + fulltype);
            }
            String type = typeMatcher.group(1);
            String ssiz = typeMatcher.group(3);
            Number badnum = null;
            if ("decimal".equals(type)) {
                decoder = DOUBLE_DECODER;
            } else if ("smallfloat".equals(type)) {
                decoder = FLOAT_DECODER;
            } else if ("smallint".equals(type)) {
                decoder = SHORT_DECODER;
                badnum = new Short(Short.MIN_VALUE);
            } else if ("integer".equals(type)) {
                decoder = INT_DECODER;
                badnum = new Integer(Integer.MIN_VALUE);
            } else if ("int8".equals(type) || "serial8".equals(type)) {
                decoder = LONG_DECODER;
                badnum = new Long(Long.MIN_VALUE);
            } else if ("char".equals(type)) {
                decoder = CHAR_DECODER;
            } else {
                throw new TableFormatException("Unknown schema type " + type);
            }
            decoderList.add(decoder);
            ColumnInfo info = decoder.createColumnInfo(name);
            if (info.getContentClass().equals(String.class) && info.getElementSize() <= 0) {
                try {
                    info.setElementSize(Integer.parseInt(ssiz));
                }
                catch (NumberFormatException e) {
                    logger_.warning("Can't parse element size " + ssiz + " for column " + name);
                }
            }
            if (unit.length() > 0 && !unit.matches("^-+$")) {
                info.setUnitString(unit);
            }
            if (descrip.length() > 0) {
                info.setDescription(descrip);
            }
            if ("yes".equals(hasnull)) {
                info.setNullable(true);
                info.setAuxDatum(new DescribedValue(Tables.NULL_VALUE_INFO, (Object)badnum));
            } else {
                info.setNullable(false);
            }
            infoList.add(info);
        }
        rseq.close();
        logger_.info("Got " + infoList.size() + " allwise columns");
        return new RowEvaluator.Metadata(infoList.toArray(new ColumnInfo[0]), decoderList.toArray(new RowEvaluator.Decoder[0]), this.nrow_);
    }

    private static abstract class WiseDecoder<T>
    extends RowEvaluator.Decoder {
        WiseDecoder(Class<T> clazz) {
            super(clazz);
        }

        public T decode(String value) {
            return value.length() == 0 ? null : (T)this.decodeNonEmpty(value);
        }

        public boolean isValid(String value) {
            if (value.length() == 0) {
                return true;
            }
            try {
                this.attemptDecode(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        abstract T decodeNonEmpty(String var1);

        abstract void attemptDecode(String var1) throws NumberFormatException;
    }
}

