/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.ttools.example.AllWiseAsciiStarTable;
import uk.ac.starlink.util.DataSource;

public class AllWiseTableBuilder
implements TableBuilder {
    private final String name_;
    private final boolean preCount_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.examples");

    public AllWiseTableBuilder() {
        this("allwise", true);
    }

    public AllWiseTableBuilder(String name, boolean preCount) {
        this.name_ = name;
        this.preCount_ = preCount;
    }

    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    public String getFormatName() {
        return this.name_;
    }

    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        long nrow;
        URL schema = this.getClass().getResource("allwise-meta-full.txt");
        if (schema == null) {
            throw new IOException("No schema found");
        }
        if (this.preCount_) {
            logger_.info("Counting allwise lines");
            nrow = AllWiseTableBuilder.countLines(datsrc);
            logger_.info("Got " + nrow + " allwise rows");
        } else {
            nrow = -1L;
        }
        return new AllWiseAsciiStarTable(datsrc, schema, nrow);
    }

    public void streamStarTable(InputStream in, TableSink sink, String pos) {
        throw new UnsupportedOperationException();
    }

    public static long countLines(DataSource datsrc) throws IOException {
        int n;
        int buflen = 0x100000;
        InputStream in = datsrc.getInputStream();
        byte[] buf = new byte[buflen];
        long nrow = 0L;
        while ((n = in.read(buf, 0, buflen)) >= 0) {
            for (int i = 0; i < n; ++i) {
                if (buf[i] != 10) continue;
                ++nrow;
            }
        }
        in.close();
        return nrow;
    }

    public static class Count
    extends AllWiseTableBuilder {
        public Count() {
            super("allwise-count", true);
        }
    }

    public static class NoCount
    extends AllWiseTableBuilder {
        public NoCount() {
            super("allwise-nocount", false);
        }
    }
}

