/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.awt.Color;
import java.io.IOException;
import javax.swing.Icon;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.example.PlotGenerator;
import uk.ac.starlink.ttools.example.SinePlot;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.BasicCaptioner;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.ShadeAxisFactory;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.SimpleDataStoreFactory;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneDataGeom;
import uk.ac.starlink.ttools.plot2.geom.PlaneNavigator;
import uk.ac.starlink.ttools.plot2.geom.PlanePlotType;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.HistogramPlotter;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.ColumnDataSpec;
import uk.ac.starlink.ttools.plot2.task.PlotDisplay;

public class ApiPlanePlotter
implements SinePlot.PlanePlotter {
    @Override
    public PlotDisplay createPlotComponent(StarTable table, boolean dataMayChange) throws InterruptedException, IOException {
        PlotGenerator<PlaneSurfaceFactory.Profile, PlaneAspect> plotGen = this.createPlotGenerator(table);
        Navigator<PlaneAspect> navigator = this.createPlaneNavigator();
        boolean surfaceAuxRange = false;
        boolean caching = !dataMayChange;
        return plotGen.createPlotDisplay(navigator, surfaceAuxRange, caching);
    }

    private PlotGenerator<PlaneSurfaceFactory.Profile, PlaneAspect> createPlotGenerator(StarTable table) throws IOException, InterruptedException {
        PlanePlotType plotType = PlanePlotType.getInstance();
        DataGeom geom = plotType.getPointDataGeoms()[0];
        PlaneSurfaceFactory surfFact = new PlaneSurfaceFactory();
        boolean xlog = false;
        boolean ylog = false;
        boolean xflip = false;
        boolean yflip = false;
        String xlabel = "X axis";
        String ylabel = "Y axis";
        BasicCaptioner captioner = new BasicCaptioner();
        double xyfactor = Double.NaN;
        boolean grid = false;
        double xcrowd = 1.0;
        double ycrowd = 1.0;
        boolean minor = true;
        Color gridColor = Color.BLACK;
        Color axlabelColor = Color.BLACK;
        PlaneSurfaceFactory.Profile profile = new PlaneSurfaceFactory.Profile(xlog, ylog, xflip, yflip, xlabel, ylabel, captioner, xyfactor, grid, xcrowd, ycrowd, minor, gridColor, axlabelColor);
        double[] xlimits = new double[]{0.0, 1.0};
        double[] ylimits = new double[]{-1.2, 1.2};
        PlaneAspect aspect = new PlaneAspect(xlimits, ylimits);
        Icon legend = null;
        float[] legPos = null;
        String title = null;
        ShadeAxisFactory shadeFact = null;
        Range shadeFixRange = null;
        PlotLayer[] layers = new PlotLayer[]{this.createScatterLayer(geom, table)};
        int nl = layers.length;
        DataSpec[] dataSpecs = new DataSpec[nl];
        for (int il = 0; il < nl; ++il) {
            dataSpecs[il] = layers[il].getDataSpec();
        }
        SimpleDataStoreFactory storeFact = new SimpleDataStoreFactory();
        DataStore dataStore = storeFact.readDataStore(dataSpecs, null);
        Compositor compositor = Compositor.SATURATION;
        PaperTypeSelector ptSel = plotType.getPaperTypeSelector();
        int xpix = 500;
        int ypix = 400;
        Padding padding = new Padding();
        return new PlotGenerator<PlaneSurfaceFactory.Profile, PlaneAspect>(layers, surfFact, profile, aspect, legend, legPos, title, shadeFact, shadeFixRange, ptSel, compositor, dataStore, xpix, ypix, padding);
    }

    private Navigator<PlaneAspect> createPlaneNavigator() {
        double zoomFactor = StyleKeys.ZOOM_FACTOR.getDefaultValue();
        boolean xZoom = true;
        boolean yZoom = true;
        boolean xPan = true;
        boolean yPan = true;
        double xAnchor = Double.NaN;
        double yAnchor = Double.NaN;
        return new PlaneNavigator(zoomFactor, xZoom, yZoom, xPan, yPan, xAnchor, yAnchor);
    }

    private PlotLayer createScatterLayer(DataGeom geom, StarTable table) {
        ColumnDataSpec dataSpec = new ColumnDataSpec(table, geom.getPosCoords(), new int[][]{{0}, {1}});
        MarkShape shape = MarkShape.OPEN_CIRCLE;
        int size = 2;
        Outliner outliner = MarkForm.createMarkOutliner(shape, size);
        ShapeMode.FlatStamper stamper = new ShapeMode.FlatStamper(Color.RED);
        ShapeStyle style = new ShapeStyle(outliner, stamper);
        ShapePlotter plotter = ShapePlotter.createFlat2dPlotter(MarkForm.SINGLE);
        return plotter.createLayer(geom, (DataSpec)dataSpec, style);
    }

    private PlotLayer createHistogramLayer(DataGeom geom, StarTable table) {
        ColumnDataSpec dataSpec = new ColumnDataSpec(table, new Coord[]{PlaneDataGeom.X_COORD}, new int[][]{{1}});
        Color color = Color.BLUE;
        BarStyle.Form barForm = BarStyle.FORM_OPEN;
        BarStyle.Placement placement = BarStyle.PLACE_ADJACENT;
        boolean cumulative = true;
        Normalisation norm = Normalisation.NONE;
        int thick = 1;
        float[] dash = null;
        BinSizer sizer = BinSizer.createCountBinSizer(16.0);
        double phase = 0.0;
        HistogramPlotter.HistoStyle style = new HistogramPlotter.HistoStyle(color, barForm, placement, cumulative, norm, thick, dash, sizer, phase);
        HistogramPlotter plotter = new HistogramPlotter(PlaneDataGeom.X_COORD, false, StyleKeys.NORMALISE);
        return plotter.createLayer(geom, (DataSpec)dataSpec, style);
    }
}

