/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ShadeAxisFactory;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.SimpleDataStoreFactory;
import uk.ac.starlink.ttools.plot2.geom.PlanePlotType;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.CoordValue;
import uk.ac.starlink.ttools.plot2.task.JELDataSpec;
import uk.ac.starlink.ttools.plot2.task.PlotCaching;
import uk.ac.starlink.ttools.plot2.task.PlotDisplay;
import uk.ac.starlink.ttools.plot2.task.PointSelectionEvent;
import uk.ac.starlink.ttools.plot2.task.PointSelectionListener;

public class BasicPlotGui<P, A, S extends Style>
extends JPanel {
    private final PlotType plotType_;
    private final SurfaceFactory<P, A> sfact_;
    private final Plotter<S> plotter_;
    private final DataGeom geom_;
    private final DataStoreFactory dstoreFact_;
    private final InputPanel inputPanel_;
    private PlotDisplay<P, A> plotDisplay_;
    private DataStore dataStore_;

    public BasicPlotGui(PlotType plotType, SurfaceFactory<P, A> sfact, Plotter<S> plotter, StarTable table) {
        super(new BorderLayout());
        this.plotType_ = plotType;
        this.sfact_ = sfact;
        this.plotter_ = plotter;
        this.geom_ = plotType.getPointDataGeoms()[0];
        this.dstoreFact_ = new SimpleDataStoreFactory();
        this.inputPanel_ = BasicPlotGui.createInputPanel(plotter, this.geom_, this.sfact_, table);
        final JPanel plotPanel = new JPanel(new BorderLayout());
        final PointSelectionListener psl = new PointSelectionListener(){

            @Override
            public void pointSelected(PointSelectionEvent evt) {
                BasicPlotGui.this.reportPoint(evt);
            }
        };
        AbstractAction plotAction = new AbstractAction("(Re)Plot"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (BasicPlotGui.this.plotDisplay_ != null) {
                    BasicPlotGui.this.plotDisplay_.removePointSelectionListener(psl);
                    plotPanel.remove(BasicPlotGui.this.plotDisplay_);
                    BasicPlotGui.this.plotDisplay_ = null;
                }
                try {
                    BasicPlotGui.this.plotDisplay_ = BasicPlotGui.this.createPlotDisplay();
                }
                catch (Exception e) {
                    System.err.println("Plot error: " + e);
                    return;
                }
                BasicPlotGui.this.plotDisplay_.addPointSelectionListener(psl);
                plotPanel.add((Component)BasicPlotGui.this.plotDisplay_, "Center");
                plotPanel.revalidate();
                plotPanel.repaint();
            }
        };
        plotPanel.setPreferredSize(new Dimension(400, 300));
        this.inputPanel_.setPreferredSize(new Dimension(400, 300));
        JSplitPane splitter = new JSplitPane(0);
        splitter.setBottomComponent(this.inputPanel_);
        splitter.setTopComponent(plotPanel);
        this.add((Component)splitter, "Center");
        this.add((Component)new JButton(plotAction), "South");
    }

    private PlotDisplay<P, A> createPlotDisplay() throws ConfigException, IOException, InterruptedException {
        DataStore dataStore;
        ConfigMap config = this.inputPanel_.getConfig();
        DataSpec dataSpec = this.inputPanel_.getDataSpec();
        S style = this.plotter_.createStyle(config);
        DataSpec[] dataSpecs = new DataSpec[]{dataSpec};
        PlotLayer layer = this.plotter_.createLayer(this.geom_, dataSpec, style);
        PlotLayer[] layers = new PlotLayer[]{layer};
        DataStore prevStore = this.dataStore_;
        this.dataStore_ = dataStore = this.dstoreFact_.readDataStore(dataSpecs, prevStore);
        Icon legend = null;
        float[] legPos = null;
        String title = null;
        ShadeAxisFactory shadeFact = null;
        Range shadeFixRange = null;
        PaperTypeSelector ptSel = this.plotType_.getPaperTypeSelector();
        Compositor compositor = Compositor.SATURATION;
        Padding padding = new Padding();
        boolean surfaceAuxRange = true;
        boolean navigable = true;
        PlotCaching caching = PlotCaching.createFullyCached();
        return PlotDisplay.createPlotDisplay(layers, this.sfact_, config, legend, legPos, title, shadeFact, shadeFixRange, ptSel, compositor, padding, dataStore, navigable, caching);
    }

    private void reportPoint(PointSelectionEvent evt) {
        double[] dpos;
        long irow = evt.getClosestRows()[0];
        String txt = irow >= 0L ? "Point #" + irow : "(no point)";
        Point gpos = evt.getPoint();
        int isurf = evt.getSurfaceIndex();
        Surface surface = this.plotDisplay_.getSurfaces()[isurf];
        if (surface != null && (dpos = surface.graphicsToData(gpos, null)) != null) {
            txt = txt + " at (" + surface.formatPosition(dpos) + ")";
        }
        System.err.println("\t" + txt);
    }

    private static InputPanel createInputPanel(Plotter plotter, DataGeom geom, SurfaceFactory sfact, StarTable table) {
        CoordGroup cgrp = plotter.getCoordGroup();
        ArrayList<Coord> coordList = new ArrayList<Coord>();
        for (int ipos = 0; ipos < cgrp.getPositionCount(); ++ipos) {
            coordList.addAll(Arrays.asList(geom.getPosCoords()));
        }
        coordList.addAll(Arrays.asList(cgrp.getExtraCoords()));
        InputPanel inputPanel = new InputPanel();
        inputPanel.addCoords("Data", coordList.toArray(new Coord[0]), table);
        inputPanel.addConfigKeys("Style", plotter.getStyleKeys());
        inputPanel.addConfigKeys("Profile", sfact.getProfileKeys());
        inputPanel.addConfigKeys("Aspect", sfact.getAspectKeys());
        inputPanel.addConfigKeys("Navigator", sfact.getNavigatorKeys());
        return inputPanel;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("usage: " + BasicPlotGui.class.getName() + " " + "<table-location>");
            System.exit(1);
        }
        StarTable table = new StarTableFactory().makeStarTable(args[0]);
        PlanePlotType plotType = PlanePlotType.getInstance();
        SurfaceFactory sfact = plotType.getSurfaceFactory();
        Plotter plotter = plotType.getPlotters()[0];
        BasicPlotGui gui = new BasicPlotGui(plotType, sfact, plotter, table);
        JFrame frm = new JFrame();
        frm.getContentPane().add(gui);
        frm.pack();
        frm.setVisible(true);
        System.out.println();
        System.out.println("  PlotType: " + plotType.getClass().getName());
        System.out.println("  Plot layer: " + plotter.getPlotterName());
        System.out.println("  --> Select columns, configure options, then hit the \"(Re)Plot\" button");
        System.out.println("  --> You can navigate the plot using the mouse");
        System.out.println("  --> Click on a point to identify it on stdout");
        System.out.println();
    }

    private static class InputPanel
    extends JPanel {
        private final JTabbedPane tabber_ = new JTabbedPane();
        private final List<KeySpec<?>> klist_ = new ArrayList();
        private final List<CoordInput> clist_ = new ArrayList<CoordInput>();

        InputPanel() {
            super(new BorderLayout());
            this.add((Component)this.tabber_, "Center");
        }

        public void addConfigKeys(String title, ConfigKey[] keys) {
            LabelledComponentStack stack = new LabelledComponentStack();
            for (ConfigKey key : keys) {
                KeySpec kspec = InputPanel.createKeySpec(key);
                this.klist_.add(kspec);
                ConfigMeta meta = key.getMeta();
                stack.addLine(meta.getShortName(), (Component)kspec.specifier_.getComponent());
            }
            this.addTab(title, (JComponent)stack);
        }

        public ConfigMap getConfig() {
            ConfigMap map = new ConfigMap();
            for (KeySpec<?> k : this.klist_) {
                k.putValue(map);
            }
            return map;
        }

        public void addCoords(String title, Coord[] coords, StarTable table) {
            LabelledComponentStack stack = new LabelledComponentStack();
            for (Coord coord : coords) {
                CoordInput cinput = new CoordInput(coord, table);
                this.clist_.add(cinput);
                Input[] inputs = coord.getInputs();
                for (int ii = 0; ii < inputs.length; ++ii) {
                    InputMeta meta = inputs[ii].getMeta();
                    stack.addLine(meta.getShortName(), (Component)cinput.entryBoxes_[ii]);
                }
            }
            Box box = Box.createVerticalBox();
            box.add(new JLabel("Choose columns or enter expressions"));
            box.add((Component)stack);
            this.addTab(title, box);
        }

        public DataSpec getDataSpec() {
            int nc = this.clist_.size();
            CoordValue[] cvals = new CoordValue[nc];
            for (int ic = 0; ic < nc; ++ic) {
                CoordInput cinput = this.clist_.get(ic);
                JComboBox[] entryBoxes = cinput.entryBoxes_;
                int nin = entryBoxes.length;
                String[] inExprs = new String[nin];
                for (int ii = 0; ii < nin; ++ii) {
                    inExprs[ii] = (String)entryBoxes[ii].getSelectedItem();
                }
                cvals[ic] = new CoordValue(cinput.coord_, inExprs);
            }
            StarTable table = this.clist_.get((int)0).table_;
            try {
                return new JELDataSpec(table, null, cvals);
            }
            catch (TaskException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Bad Coordinate Value", 0);
                return null;
            }
        }

        private void addTab(String title, JComponent comp) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)comp, "North");
            this.tabber_.add(title, new JScrollPane(panel));
        }

        private static <T> KeySpec<T> createKeySpec(ConfigKey<T> key) {
            return new KeySpec<T>(key);
        }

        private static class CoordInput {
            final StarTable table_;
            final Coord coord_;
            final JComboBox[] entryBoxes_;

            CoordInput(Coord coord, StarTable table) {
                this.coord_ = coord;
                this.table_ = table;
                Input[] inputs = coord.getInputs();
                this.entryBoxes_ = new JComboBox[inputs.length];
                for (int i = 0; i < inputs.length; ++i) {
                    this.entryBoxes_[i] = CoordInput.createColumnEntryBox(table, inputs[i].getValueClass());
                }
            }

            private static JComboBox createColumnEntryBox(StarTable table, Class clazz) {
                int ncol = table.getColumnCount();
                ArrayList<String> cnameList = new ArrayList<String>();
                cnameList.add(null);
                for (int ic = 0; ic < ncol; ++ic) {
                    ColumnInfo info = table.getColumnInfo(ic);
                    if (!clazz.isAssignableFrom(info.getContentClass())) continue;
                    cnameList.add(info.getName());
                }
                JComboBox<String> combo = new JComboBox<String>(cnameList.toArray(new String[0]));
                combo.setEditable(true);
                combo.setSelectedItem(null);
                return combo;
            }
        }

        private static class KeySpec<T> {
            final ConfigKey<T> key_;
            final Specifier<T> specifier_;

            KeySpec(ConfigKey<T> key) {
                this.key_ = key;
                this.specifier_ = this.key_.createSpecifier();
                this.specifier_.setSpecifiedValue(this.key_.getDefaultValue());
            }

            void putValue(ConfigMap map) {
                map.put(this.key_, this.specifier_.getSpecifiedValue());
            }
        }
    }
}

