/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxisFactory;
import uk.ac.starlink.ttools.plot2.SingleGanger;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.PlotCaching;
import uk.ac.starlink.ttools.plot2.task.PlotDisplay;

public class PlotGenerator<P, A> {
    private final PlotLayer[] layers_;
    private final SurfaceFactory<P, A> surfFact_;
    private final P profile_;
    private final A aspect_;
    private final Icon legend_;
    private final float[] legPos_;
    private final String title_;
    private final ShadeAxisFactory shadeFact_;
    private final Range shadeFixRange_;
    private final PaperTypeSelector ptSel_;
    private final Compositor compositor_;
    private final DataStore dataStore_;
    private final int xpix_;
    private final int ypix_;
    private final Padding padding_;

    public PlotGenerator(PlotLayer[] layers, SurfaceFactory<P, A> surfFact, P profile, A aspect, Icon legend, float[] legPos, String title, ShadeAxisFactory shadeFact, Range shadeFixRange, PaperTypeSelector ptSel, Compositor compositor, DataStore dataStore, int xpix, int ypix, Padding padding) {
        this.layers_ = layers;
        this.surfFact_ = surfFact;
        this.profile_ = profile;
        this.aspect_ = aspect;
        this.legend_ = legend;
        this.legPos_ = legPos;
        this.title_ = title;
        this.shadeFact_ = shadeFact;
        this.shadeFixRange_ = shadeFixRange;
        this.ptSel_ = ptSel;
        this.compositor_ = compositor;
        this.dataStore_ = dataStore;
        this.xpix_ = xpix;
        this.ypix_ = ypix;
        this.padding_ = padding;
    }

    public PlotDisplay<P, A> createPlotDisplay(Navigator<A> navigator, boolean surfaceAuxRange, boolean cacheImage) {
        PlotCaching cachePolicy = new PlotCaching();
        cachePolicy.setReuseRanges(!surfaceAuxRange);
        cachePolicy.setCacheImage(cacheImage);
        cachePolicy.setUsePlans(true);
        PlotDisplay<P, A> display = new PlotDisplay<P, A>(this.surfFact_, this.layers_, this.profile_, this.legend_, this.legPos_, this.title_, this.aspect_, this.shadeFact_, this.shadeFixRange_, navigator, this.ptSel_, this.compositor_, this.padding_, this.dataStore_, cachePolicy);
        display.setPreferredSize(new Dimension(this.xpix_, this.ypix_));
        return display;
    }

    public void exportPlot(GraphicExporter exporter, OutputStream out) throws IOException {
        boolean forceBitmap = false;
        Picture pic = PlotUtil.toPicture(this.createIcon(forceBitmap));
        BufferedOutputStream bufOut = new BufferedOutputStream(out);
        exporter.exportGraphic(pic, bufOut);
        ((OutputStream)bufOut).flush();
    }

    public Icon createIcon(boolean forceBitmap) {
        return AbstractPlot2Task.createPlotIcon(new SingleGanger(this.padding_), this.surfFact_, 1, new ZoneContent[]{new ZoneContent(this.layers_, this.legend_, this.legPos_, this.title_)}, PlotUtil.singletonArray(this.profile_), PlotUtil.singletonArray(this.aspect_), new ShadeAxisFactory[]{this.shadeFact_}, new Range[]{this.shadeFixRange_}, this.ptSel_, this.compositor_, this.dataStore_, this.xpix_, this.ypix_, forceBitmap);
    }
}

