/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.RowEvaluator;
import uk.ac.starlink.table.formats.StreamStarTable;
import uk.ac.starlink.util.DataSource;

public class PostgresAsciiStarTable
extends StreamStarTable {
    private final StringBuffer cellBuf_ = new StringBuffer();
    private final URL schemaUrl_;
    private final int ncol_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.table.formats");
    private static RowEvaluator.Decoder DOUBLE_DECODER = new RowEvaluator.Decoder(Double.class){

        public Object decode(String value) {
            return "\\N".equals(value) ? null : Double.valueOf(value);
        }

        public boolean isValid(String value) {
            if ("\\N".equals(value)) {
                return true;
            }
            try {
                Double.parseDouble(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static RowEvaluator.Decoder REAL_DECODER = new RowEvaluator.Decoder(Float.class){

        public Object decode(String value) {
            return "\\N".equals(value) ? null : Float.valueOf(value);
        }

        public boolean isValid(String value) {
            if ("\\N".equals(value)) {
                return true;
            }
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static RowEvaluator.Decoder SMALLINT_DECODER = new RowEvaluator.Decoder(Short.class){

        public Object decode(String value) {
            return "\\N".equals(value) ? null : Short.valueOf(value);
        }

        public boolean isValid(String value) {
            if ("\\N".equals(value)) {
                return true;
            }
            try {
                Short.parseShort(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static RowEvaluator.Decoder INTEGER_DECODER = new RowEvaluator.Decoder(Integer.class){

        public Object decode(String value) {
            return "\\N".equals(value) ? null : Integer.valueOf(value);
        }

        public boolean isValid(String value) {
            if ("\\N".equals(value)) {
                return true;
            }
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static RowEvaluator.Decoder DATE_DECODER = new RowEvaluator.Decoder(String.class){

        public Object decode(String value) {
            return "\\N".equals(value) ? null : value;
        }

        public boolean isValid(String value) {
            return RowEvaluator.ISO8601_REGEX.matcher(value).matches();
        }

        public ColumnInfo createColumnInfo(String name) {
            ColumnInfo info = super.createColumnInfo(name);
            info.setElementSize(10);
            info.setUnitString("iso-8601");
            return info;
        }
    };
    private static RowEvaluator.Decoder CHARACTER_DECODER = new RowEvaluator.Decoder(String.class){

        public Object decode(String value) {
            return "\\N".equals(value) ? null : value;
        }

        public boolean isValid(String value) {
            return true;
        }
    };

    public PostgresAsciiStarTable(DataSource datsrc, URL schemaUrl) throws IOException {
        this.schemaUrl_ = schemaUrl;
        this.init(datsrc);
        this.ncol_ = this.getColumnCount();
    }

    protected List readRow(PushbackInputStream in) throws TableFormatException, IOException {
        int icol = 0;
        this.cellBuf_.setLength(0);
        Object[] row = new Object[this.ncol_];
        block5: while (true) {
            char c = (char)in.read();
            switch (c) {
                case '\uffff': {
                    return null;
                }
                case '\n': {
                    row[icol++] = this.cellBuf_.toString();
                    this.cellBuf_.setLength(0);
                    if (icol != this.ncol_) {
                        throw new TableFormatException("Wrong num of cols");
                    }
                    return Arrays.asList(row);
                }
                case '|': {
                    row[icol++] = this.cellBuf_.toString();
                    this.cellBuf_.setLength(0);
                    continue block5;
                }
            }
            this.cellBuf_.append(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RowEvaluator.Metadata obtainMetadata() throws IOException {
        InputStream in = this.schemaUrl_.openStream();
        try {
            RowEvaluator.Metadata metadata = this.readSchema(in);
            return metadata;
        }
        finally {
            in.close();
        }
    }

    protected RowEvaluator.Metadata readSchema(InputStream in) throws IOException {
        String line;
        Pattern regex = Pattern.compile("^ +([a-z_]+) ([a-z ]+)(\\(([0-9]+)\\))?,? *$");
        BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
        ArrayList<RowEvaluator.Decoder> decoderList = new ArrayList<RowEvaluator.Decoder>();
        ArrayList<ColumnInfo> infoList = new ArrayList<ColumnInfo>();
        while ((line = rdr.readLine()) != null) {
            RowEvaluator.Decoder decoder;
            Matcher matcher = regex.matcher(line);
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            String type = matcher.group(2);
            String ssiz = matcher.group(4);
            if ("double precision".equals(type)) {
                decoder = DOUBLE_DECODER;
            } else if ("real".equals(type)) {
                decoder = REAL_DECODER;
            } else if ("smallint".equals(type)) {
                decoder = SMALLINT_DECODER;
            } else if ("integer".equals(type)) {
                decoder = INTEGER_DECODER;
            } else if ("date".equals(type)) {
                decoder = DATE_DECODER;
            } else if ("character".equals(type)) {
                decoder = CHARACTER_DECODER;
            } else {
                throw new TableFormatException("Unknown schema type " + type);
            }
            decoderList.add(decoder);
            ColumnInfo info = decoder.createColumnInfo(name);
            if (info.getContentClass().equals(String.class) && info.getElementSize() <= 0) {
                try {
                    info.setElementSize(Integer.parseInt(ssiz));
                }
                catch (NumberFormatException e) {
                    logger_.warning("Can't parse element size " + ssiz + " for column " + name);
                }
            }
            infoList.add(info);
        }
        return new RowEvaluator.Metadata(infoList.toArray(new ColumnInfo[0]), decoderList.toArray(new RowEvaluator.Decoder[0]), -1L);
    }
}

