/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.example.ApiPlanePlotter;
import uk.ac.starlink.ttools.example.EnvPlanePlotter;
import uk.ac.starlink.ttools.plot2.task.PlotDisplay;

public class SinePlot {
    private final int count_;
    private final double[] xs_;
    private final double[] ys_;
    private final StarTable table_;
    private PlanePlotter planePlotter_;

    public SinePlot(PlanePlotter planePlotter, int count) throws Exception {
        this.planePlotter_ = planePlotter;
        this.count_ = count;
        this.xs_ = new double[count];
        this.ys_ = new double[count];
        ColumnStarTable table = ColumnStarTable.makeTableWithRows((long)count);
        table.addColumn((ColumnData)ArrayColumn.makeColumn((String)"x", (Object)this.xs_));
        table.addColumn((ColumnData)ArrayColumn.makeColumn((String)"y", (Object)this.ys_));
        this.table_ = table;
        this.updateTableData();
    }

    public void run(int updateMillis) throws Exception {
        boolean dataWillChange = updateMillis >= 0;
        final PlotDisplay plotComp = this.planePlotter_.createPlotComponent(this.table_, dataWillChange);
        if (dataWillChange) {
            new Timer(true).schedule(new TimerTask(){

                @Override
                public void run() {
                    SinePlot.this.updateTableData();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            plotComp.repaint();
                        }
                    });
                }
            }, 0L, (long)updateMillis);
        }
        JFrame frame = new JFrame(SinePlot.class.getName());
        frame.getContentPane().add(plotComp);
        frame.pack();
        frame.setVisible(true);
    }

    private void updateTableData() {
        double rc = 1.0 / (double)this.count_;
        Random rnd = new Random();
        for (int i = 0; i < this.count_; ++i) {
            double x;
            this.xs_[i] = x = (double)i * rc;
            this.ys_[i] = Math.sin(Math.PI * 2 * x) + rnd.nextGaussian() * 0.1;
        }
    }

    public static void main(String[] args) throws Exception {
        String usage = new StringBuffer().append("\n   ").append("Usage: ").append("\n      ").append(SinePlot.class.getName().replaceFirst(".*\\.", "")).append(" [-[no]move]").append(" [-api/-env]").append(" [-count npoint]").append(" [-verbose [-verbose]]").append("\n").toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean move = true;
        boolean isApi = true;
        int count = 1000;
        int verbLevel = 0;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-move")) {
                it.remove();
                move = true;
                continue;
            }
            if (arg.equals("-nomove")) {
                it.remove();
                move = false;
                continue;
            }
            if (arg.equals("-api")) {
                it.remove();
                isApi = true;
                continue;
            }
            if (arg.equals("-env")) {
                it.remove();
                isApi = false;
                continue;
            }
            if (arg.equals("-count")) {
                it.remove();
                count = Integer.parseInt((String)it.next());
                it.remove();
                continue;
            }
            if (arg.equals("-verbose")) {
                it.remove();
                ++verbLevel;
                continue;
            }
            if (!arg.startsWith("-h")) continue;
            it.remove();
            System.out.println(usage);
            return;
        }
        if (argList.size() > 0) {
            System.err.println(usage);
            System.exit(1);
        }
        int updateMillis = move ? 100 : -1;
        Logger.getLogger("uk.ac.starlink.ttools").setLevel((new Level[]{Level.WARNING, Level.INFO, Level.CONFIG})[verbLevel]);
        PlanePlotter planePlotter = isApi ? new ApiPlanePlotter() : new EnvPlanePlotter();
        new SinePlot(planePlotter, count).run(updateMillis);
    }

    public static interface PlanePlotter {
        public PlotDisplay createPlotComponent(StarTable var1, boolean var2) throws Exception;
    }
}

