/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.example;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.jdbc.SequentialResultSetStarTable;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOTableVersion;

public class TapWriter {
    private final DataFormat dfmt_;
    private final VOTableVersion version_;
    private final long maxrec_;

    public TapWriter(DataFormat dfmt, VOTableVersion version, long maxrec) {
        this.dfmt_ = dfmt;
        this.version_ = version;
        this.maxrec_ = maxrec;
    }

    public void writeVOTable(ResultSet rset, OutputStream ostrm) throws IOException, SQLException {
        LimitedResultSetStarTable table = new LimitedResultSetStarTable(rset, this.maxrec_);
        VOSerializer voser = VOSerializer.makeSerializer((DataFormat)this.dfmt_, (VOTableVersion)this.version_, (StarTable)table);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(ostrm));
        out.write("<VOTABLE" + VOSerializer.formatAttribute((String)"version", (String)this.version_.getVersionNumber()) + VOSerializer.formatAttribute((String)"xmlns", (String)this.version_.getXmlNamespace()) + ">");
        out.newLine();
        out.write("<RESOURCE>");
        out.newLine();
        out.write("<INFO name='QUERY_STATUS' value='OK'/>");
        out.newLine();
        voser.writeInlineTableElement(out);
        if (table.lastSequenceOverflowed()) {
            out.write("<INFO name='QUERY_STATUS' value='OVERFLOW'/>");
            out.newLine();
        }
        out.write("</RESOURCE>");
        out.newLine();
        out.write("</VOTABLE>");
        out.newLine();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, SQLException {
        String usage = "\nUsage: " + TapWriter.class.getName() + " [-maxrec <n>]" + " <jdbc-url>" + " <sql-query>" + "\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        long maxrec = -1L;
        String url = null;
        String sql = null;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            it.remove();
            if (arg.startsWith("-h")) {
                System.err.println(usage);
                return;
            }
            if ("-maxrec".equals(arg)) {
                maxrec = Long.parseLong((String)it.next());
                it.remove();
                continue;
            }
            if (url == null) {
                url = arg;
                continue;
            }
            if (sql != null) continue;
            sql = arg;
        }
        if (url == null || sql == null || !argList.isEmpty()) {
            System.err.println(usage);
            System.exit(1);
        }
        Connection conn = DriverManager.getConnection(url);
        Statement stmt = conn.createStatement();
        ResultSet rset = stmt.executeQuery(sql);
        TapWriter writer = new TapWriter(DataFormat.TABLEDATA, VOTableVersion.V12, maxrec);
        try {
            writer.writeVOTable(rset, System.out);
        }
        finally {
            rset.close();
        }
    }

    private static class LimitedResultSetStarTable
    extends SequentialResultSetStarTable {
        private final long maxrec_;
        private boolean overflow_;

        LimitedResultSetStarTable(ResultSet rset, long maxrec) throws SQLException {
            super(rset);
            this.maxrec_ = maxrec;
        }

        public boolean lastSequenceOverflowed() {
            return this.overflow_;
        }

        public RowSequence getRowSequence() throws IOException {
            this.overflow_ = false;
            RowSequence baseSeq = super.getRowSequence();
            if (this.maxrec_ < 0L) {
                return baseSeq;
            }
            return new WrapperRowSequence(baseSeq){
                long irow;
                {
                    this.irow = -1L;
                }

                public boolean next() throws IOException {
                    ++this.irow;
                    if (this.irow < LimitedResultSetStarTable.this.maxrec_) {
                        return super.next();
                    }
                    if (this.irow == LimitedResultSetStarTable.this.maxrec_) {
                        LimitedResultSetStarTable.this.overflow_ = super.next();
                    }
                    return false;
                }
            };
        }
    }
}

