/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.JELColumnSupplement;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class AddColumnFilter
extends BasicFilter {
    public AddColumnFilter() {
        super("addcol", "[-after <col-id> | -before <col-id>]\n[-units <units>] [-ucd <ucd>] [-utype <utype>] [-desc <descrip>]\n<col-name> <expr>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Add a new column called <code>&lt;col-name&gt;</code> defined", "by the algebraic expression <code>&lt;expr&gt;</code>.", "By default the new column appears after the last column", "of the table, but you can position it either before or", "after a specified column using the <code>-before</code>", "or <code>-after</code> flags respectively.", "The <code>-units</code>, <code>-ucd</code> <code>-utype</code>", "and <code>-desc</code> flags can be used to define", "metadata values for the new column.", "</p>", AddColumnFilter.explainSyntax(new String[]{"expr", "col-id"})};
    }

    @Override
    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String posId = null;
        String colName = null;
        String expr = null;
        String units = null;
        String ucd = null;
        String utype = null;
        String description = null;
        boolean after = false;
        while (argIt.hasNext() && (colName == null || expr == null)) {
            String arg = (String)argIt.next();
            if (arg.equals("-after") && posId == null && argIt.hasNext()) {
                argIt.remove();
                after = true;
                posId = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-before") && posId == null && argIt.hasNext()) {
                argIt.remove();
                after = false;
                posId = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-units") && argIt.hasNext()) {
                argIt.remove();
                units = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-ucd") && argIt.hasNext()) {
                argIt.remove();
                ucd = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-utype") && argIt.hasNext()) {
                argIt.remove();
                utype = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-desc") && argIt.hasNext()) {
                argIt.remove();
                description = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (colName == null) {
                argIt.remove();
                colName = arg;
                continue;
            }
            if (expr != null) continue;
            argIt.remove();
            expr = arg;
        }
        if (colName != null && expr != null) {
            ColumnInfo colinfo = new ColumnInfo(colName);
            if (units != null) {
                colinfo.setUnitString(units);
            }
            if (ucd != null) {
                colinfo.setUCD(ucd);
            }
            if (utype != null) {
                colinfo.setUtype(utype);
            }
            if (description != null) {
                colinfo.setDescription(description);
            }
            return new AddColumnStep(expr, colinfo, posId, after);
        }
        throw new ArgException("Bad " + this.getName() + " specification");
    }

    private static class AddColumnStep
    implements ProcessingStep {
        final String expr_;
        final ColumnInfo cinfo_;
        final String placeColid_;
        final boolean after_;

        AddColumnStep(String expr, ColumnInfo cinfo, String placeColid, boolean after) {
            this.cinfo_ = cinfo;
            this.expr_ = expr;
            this.placeColid_ = placeColid;
            this.after_ = after;
        }

        @Override
        public StarTable wrap(StarTable base) throws IOException {
            int ipos;
            if (this.placeColid_ != null) {
                int iplace = new ColumnIdentifier(base).getColumnIndex(this.placeColid_);
                ipos = this.after_ ? iplace + 1 : iplace;
            } else {
                ipos = base.getColumnCount();
            }
            JELColumnSupplement jelSup = new JELColumnSupplement(base, this.expr_, this.cinfo_);
            return new AddColumnsTable(base, jelSup, ipos);
        }
    }
}

