/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.ttools.filter.ColumnSupplement;
import uk.ac.starlink.ttools.filter.SupplementSequence;

public abstract class CalculatorColumnSupplement
implements ColumnSupplement {
    private final ColumnSupplement baseSup_;
    private final ColumnInfo[] outColInfos_;
    private Object[] currentOutRow_;
    private long iCurrentRow_;

    public CalculatorColumnSupplement(ColumnSupplement baseSup, ColumnInfo[] outColInfos) {
        this.baseSup_ = baseSup;
        this.outColInfos_ = outColInfos;
        this.iCurrentRow_ = -1L;
    }

    protected abstract Object[] calculate(Object[] var1) throws IOException;

    @Override
    public int getColumnCount() {
        return this.outColInfos_.length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.outColInfos_[icol];
    }

    @Override
    public synchronized Object[] getRow(long irow) throws IOException {
        return this.calculate(this.baseSup_.getRow(irow));
    }

    @Override
    public synchronized Object getCell(long irow, int icol) throws IOException {
        if (irow != this.iCurrentRow_) {
            this.currentOutRow_ = this.getRow(irow);
            this.iCurrentRow_ = irow;
        }
        return this.currentOutRow_[icol];
    }

    @Override
    public SupplementSequence createSequence(RowSequence rseq) throws IOException {
        final SupplementSequence sseq = this.baseSup_.createSequence(rseq);
        return new SupplementSequence(){
            private long iSeq_ = -1L;
            private Object[] row_;

            @Override
            public Object[] getRow(long irow) throws IOException {
                if (irow != this.iSeq_) {
                    this.row_ = CalculatorColumnSupplement.this.calculate(sseq.getRow(irow));
                    this.iSeq_ = irow;
                }
                return this.row_;
            }

            @Override
            public Object getCell(long irow, int icol) throws IOException {
                Object[] row = this.getRow(irow);
                assert (row == this.row_);
                return row[icol];
            }
        };
    }

    public static double getDouble(Object value) {
        return value instanceof Number ? ((Number)value).doubleValue() : Double.NaN;
    }
}

