/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class ColumnMetadataFilter
extends BasicFilter {
    public ColumnMetadataFilter() {
        super("colmeta", "[-name <name>] [-units <units>] [-ucd <ucd>] [-utype <utype>]\n[-desc <descrip>]\n<colid-list>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Modifies the metadata of one or more columns.", "Some or all of the name, units, ucd, utype and description of ", "the column(s), identified by <code>&lt;colid-list&gt;</code>", "can be set by using some or all of the listed flags.", "Typically, <code>&lt;colid-list&gt;</code> will simply be", "the name of a single column.", "</p>", ColumnMetadataFilter.explainSyntax(new String[]{"colid-list"})};
    }

    @Override
    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String colidList = null;
        String rename = null;
        String units = null;
        String ucd = null;
        String utype = null;
        String desc = null;
        while (argIt.hasNext() && colidList == null) {
            String arg = (String)argIt.next();
            if (arg.equals("-name") && argIt.hasNext()) {
                argIt.remove();
                rename = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.startsWith("-unit") && argIt.hasNext()) {
                argIt.remove();
                units = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-ucd") && argIt.hasNext()) {
                argIt.remove();
                ucd = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-utype") && argIt.hasNext()) {
                argIt.remove();
                utype = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-desc") && argIt.hasNext()) {
                argIt.remove();
                desc = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.startsWith("-")) {
                argIt.remove();
                throw new ArgException("No such flag " + arg);
            }
            if (colidList != null) continue;
            colidList = arg;
            argIt.remove();
        }
        if (colidList == null) {
            throw new ArgException("No columns specified");
        }
        return new ColMetaStep(colidList, rename, units, ucd, utype, desc);
    }

    private static class ColMetaStep
    implements ProcessingStep {
        final String colidList_;
        final String name_;
        final String units_;
        final String ucd_;
        final String utype_;
        final String desc_;

        public ColMetaStep(String colidList, String name, String units, String ucd, String utype, String desc) {
            this.colidList_ = colidList;
            this.name_ = name;
            this.units_ = units;
            this.ucd_ = ucd;
            this.utype_ = utype;
            this.desc_ = desc;
        }

        @Override
        public StarTable wrap(StarTable base) throws IOException {
            int ncol = base.getColumnCount();
            boolean[] colFlags = new ColumnIdentifier(base).getColumnFlags(this.colidList_);
            assert (colFlags.length == ncol);
            final ColumnInfo[] colInfos = new ColumnInfo[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo info = new ColumnInfo(base.getColumnInfo(icol));
                if (colFlags[icol]) {
                    if (this.name_ != null) {
                        info.setName(this.name_);
                    }
                    if (this.units_ != null) {
                        info.setUnitString(this.units_);
                    }
                    if (this.ucd_ != null) {
                        info.setUCD(this.ucd_);
                    }
                    if (this.utype_ != null) {
                        info.setUtype(this.utype_);
                    }
                    if (this.desc_ != null) {
                        info.setDescription(this.desc_);
                    }
                }
                colInfos[icol] = info;
            }
            return new WrapperStarTable(base){

                public ColumnInfo getColumnInfo(int icol) {
                    return colInfos[icol];
                }
            };
        }
    }
}

