/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class FixNamesFilter
extends BasicFilter
implements ProcessingStep {
    public FixNamesFilter() {
        super("fixcolnames", "");
    }

    @Override
    public String[] getDescriptionLines() {
        return new String[]{"<p>Renames all columns and parameters in the input table", "so that they have names which have convenient syntax for STILTS.", "For the most part this means replacing spaces and other", "non-alphanumeric characters with underscores.", "This is a convenience which lets you use column names in", "algebraic expressions and other STILTS syntax.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        return this;
    }

    @Override
    public StarTable wrap(StarTable base) {
        return new FixNamesTable(base);
    }

    public String fixName(String name) {
        if (name == null || name.trim().length() == 0) {
            return "_unnamed_";
        }
        name = name.trim();
        StringBuffer sbuf = new StringBuffer(name.length());
        for (int ic = 0; ic < name.length(); ++ic) {
            char ch = name.charAt(ic);
            sbuf.append((ic == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch)) ? (char)ch : (char)'_');
        }
        return sbuf.toString();
    }

    private class FixNamesTable
    extends WrapperStarTable {
        private final ColumnInfo[] colInfos_;
        private final List paramList_;

        FixNamesTable(StarTable base) {
            super(base);
            int ncol = base.getColumnCount();
            this.colInfos_ = new ColumnInfo[ncol];
            for (int icol = 0; icol < ncol; ++icol) {
                ColumnInfo info = new ColumnInfo(base.getColumnInfo(icol));
                info.setName(FixNamesFilter.this.fixName(info.getName()));
                this.colInfos_[icol] = info;
            }
            DescribedValue[] params = base.getParameters().toArray(new DescribedValue[0]);
            this.paramList_ = new ArrayList(params.length);
            for (int ip = 0; ip < params.length; ++ip) {
                DefaultValueInfo info = new DefaultValueInfo(params[ip].getInfo());
                info.setName(FixNamesFilter.this.fixName(info.getName()));
                Object value = params[ip].getValue();
                this.paramList_.add(new DescribedValue((ValueInfo)info, value));
            }
        }

        public ColumnInfo getColumnInfo(int icol) {
            return this.colInfos_[icol];
        }

        public List getParameters() {
            return this.paramList_;
        }

        public DescribedValue getParameterByName(String parName) {
            for (DescribedValue param : this.paramList_) {
                if (!param.getInfo().getName().equals(parName)) continue;
                return param;
            }
            return null;
        }

        public void setParameter(DescribedValue dval) {
            this.paramList_.remove(this.getParameterByName(dval.getInfo().getName()));
            this.paramList_.add(dval);
        }
    }
}

