/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ColumnSupplement;
import uk.ac.starlink.ttools.filter.SupplementSequence;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.RandomJELRowReader;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;

public class JELColumnSupplement
implements ColumnSupplement {
    private final StarTable inTable_;
    private final String[] exprs_;
    private final int ncol_;
    private final ColumnInfo[] outColInfos_;
    private final RandomJELRowReader randomReader_;
    private final CompiledExpression[] randomCompexs_;

    public JELColumnSupplement(StarTable inTable, String[] exprs, ColumnInfo[] colInfos) throws IOException {
        this.inTable_ = inTable;
        this.ncol_ = exprs.length;
        if (colInfos == null) {
            colInfos = new ColumnInfo[this.ncol_];
            for (int ic = 0; ic < this.ncol_; ++ic) {
                colInfos[ic] = new ColumnInfo("col" + (ic + 1), Object.class, null);
            }
        } else if (colInfos.length != this.ncol_) {
            throw new IllegalArgumentException("How many output columns?");
        }
        this.exprs_ = (String[])exprs.clone();
        this.randomReader_ = new RandomJELRowReader(this.inTable_);
        Library randomLib = JELUtils.getLibrary(this.randomReader_);
        this.randomCompexs_ = new CompiledExpression[this.ncol_];
        this.outColInfos_ = new ColumnInfo[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String expr = exprs[icol];
            try {
                this.randomCompexs_[icol] = JELUtils.compile(randomLib, this.inTable_, expr);
                Class primType = JELUtils.getExpressionType(randomLib, this.inTable_, expr);
                Class clazz = JELUtils.getWrapperType(primType);
                this.outColInfos_[icol] = new ColumnInfo(colInfos[icol]);
                this.outColInfos_[icol].setContentClass(clazz);
                continue;
            }
            catch (CompilationException e) {
                throw JELUtils.toIOException(e, expr);
            }
        }
    }

    public JELColumnSupplement(StarTable inTable, String expr, ColumnInfo colInfo) throws IOException {
        ColumnInfo[] columnInfoArray;
        String[] stringArray = new String[]{expr};
        if (colInfo == null) {
            columnInfoArray = null;
        } else {
            ColumnInfo[] columnInfoArray2 = new ColumnInfo[1];
            columnInfoArray = columnInfoArray2;
            columnInfoArray2[0] = colInfo;
        }
        this(inTable, stringArray, columnInfoArray);
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.outColInfos_[icol];
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        return this.evaluateRandom(irow, this.randomCompexs_[icol]);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = this.getCell(irow, icol);
        }
        return row;
    }

    @Override
    public SupplementSequence createSequence(RowSequence rseq) {
        return new JELSupplementSequence(this.inTable_, this.exprs_, rseq);
    }

    private Object evaluateRandom(long irow, CompiledExpression compex) throws IOException {
        try {
            return this.randomReader_.evaluateAtRow(compex, irow);
        }
        catch (RuntimeException e) {
            return null;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private static class JELSupplementSequence
    extends StarTableJELRowReader
    implements SupplementSequence {
        private final RowSequence rseq_;
        private final CompiledExpression[] seqCompexs_;
        private final int ncol_;
        private long lrow_ = -1L;

        JELSupplementSequence(StarTable table, String[] exprs, RowSequence rseq) {
            super(table);
            this.rseq_ = rseq;
            this.ncol_ = exprs.length;
            this.seqCompexs_ = new CompiledExpression[this.ncol_];
            Library lib = JELUtils.getLibrary(this);
            for (int icol = 0; icol < this.ncol_; ++icol) {
                try {
                    this.seqCompexs_[icol] = JELUtils.compile(lib, table, exprs[icol]);
                    continue;
                }
                catch (CompilationException e) {
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Well it compiled OK last time"))).initCause(e));
                }
            }
        }

        @Override
        public long getCurrentRow() {
            return this.lrow_;
        }

        @Override
        public Object getCell(int icol) throws IOException {
            return this.rseq_.getCell(icol);
        }

        @Override
        public Object getCell(long irow, int icol) throws IOException {
            this.lrow_ = irow;
            return this.evaluateAtCurrentRow(this.seqCompexs_[icol]);
        }

        @Override
        public Object[] getRow(long irow) throws IOException {
            this.lrow_ = irow;
            Object[] row = new Object[this.ncol_];
            for (int icol = 0; icol < this.ncol_; ++icol) {
                row[icol] = this.evaluateAtCurrentRow(this.seqCompexs_[icol]);
            }
            return row;
        }

        private Object evaluateAtCurrentRow(CompiledExpression compex) throws IOException {
            try {
                return this.evaluate(compex);
            }
            catch (RuntimeException e) {
                return null;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
    }
}

