/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.UCD;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.ValueInfoMapGroupTable;
import uk.ac.starlink.util.MapGroup;

public class MetadataFilter
extends BasicFilter {
    public static final ValueInfo INDEX_INFO = new DefaultValueInfo("Index", Integer.class, "Position of column in table");
    public static final ValueInfo NAME_INFO = new DefaultValueInfo("Name", String.class, "Column name");
    public static final ValueInfo CLASS_INFO = new DefaultValueInfo("Class", String.class, "Data type of objects in column");
    public static final ValueInfo SHAPE_INFO = new DefaultValueInfo("Shape", int[].class, "Shape of array values");
    public static final ValueInfo ELSIZE_INFO = new DefaultValueInfo("ElSize", Integer.class, "Size of each element in column (mostly useful for strings)");
    public static final ValueInfo UNIT_INFO = new DefaultValueInfo("Units", String.class, "Unit string");
    public static final ValueInfo DESCRIPTION_INFO = new DefaultValueInfo("Description", String.class, "Description of data in the column");
    public static final ValueInfo UCD_INFO = new DefaultValueInfo("UCD", String.class, "Unified Content Descriptor");
    public static final ValueInfo UCDDESC_INFO = new DefaultValueInfo("UCD_desc", String.class, "Textual description of UCD");
    public static final ValueInfo UTYPE_INFO = new DefaultValueInfo("Utype", String.class, "Type in data model");
    public static final ValueInfo[] KNOWN_INFOS = new ValueInfo[]{INDEX_INFO, NAME_INFO, CLASS_INFO, SHAPE_INFO, ELSIZE_INFO, UNIT_INFO, DESCRIPTION_INFO, UCD_INFO, UCDDESC_INFO, UTYPE_INFO};
    private static final ValueInfo[] DEFAULT_INFOS = new ValueInfo[]{INDEX_INFO, NAME_INFO, CLASS_INFO, SHAPE_INFO, ELSIZE_INFO, UNIT_INFO, DESCRIPTION_INFO, UCD_INFO, UTYPE_INFO};

    public MetadataFilter() {
        super("meta", "[<item> ...]");
    }

    @Override
    protected String[] getDescriptionLines() {
        ArrayList<ValueInfo> extras = new ArrayList<ValueInfo>(Arrays.asList(KNOWN_INFOS));
        extras.removeAll(Arrays.asList(DEFAULT_INFOS));
        ValueInfo[] extraKnownInfos = extras.toArray(new ValueInfo[0]);
        return new String[]{"<p>Provides information about the metadata for each column.", "This filter turns the table sideways, so that each row", "of the output corresponds to a column of the input.", "The columns of the output table contain metadata items", "such as column name, units, UCD etc corresponding to each", "column of the input table.", "</p>", "<p>By default the output table contains columns for the", "following items:", DocUtils.listInfos(DEFAULT_INFOS), "as well as any table-specific column metadata items that", "the table contains.", "</p>", "<p>However, the output may be customised by supplying", "one or more <code>&lt;item&gt;</code> headings.", "These may be selected from the above as well as the following:", DocUtils.listInfos(extraKnownInfos), "as well as any table-specific metadata.  It is not an error", "to specify an item for which no metadata exists in any of", "the columns (such entries will result in empty columns).", "</p>", "<p>Any table parameters of the input table are propagated", "to the output one.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String[] items;
        if (argIt.hasNext()) {
            ArrayList itemList = new ArrayList();
            while (argIt.hasNext()) {
                itemList.add(argIt.next());
                argIt.remove();
            }
            items = itemList.toArray(new String[0]);
        } else {
            items = null;
        }
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable base) {
                MapGroup group = MetadataFilter.metadataMapGroup(base);
                ArrayList<ValueInfo> seq = new ArrayList<ValueInfo>();
                seq.addAll(Arrays.asList(DEFAULT_INFOS));
                for (Object aux : base.getColumnAuxDataInfos()) {
                    if (!(aux instanceof ValueInfo)) continue;
                    seq.add((ValueInfo)aux);
                }
                group.setKeyOrder(seq);
                group.setKnownKeys(Arrays.asList(MetadataFilter.getKeys(group, items)));
                ValueInfoMapGroupTable table = new ValueInfoMapGroupTable(group);
                table.setParameters(base.getParameters());
                return table;
            }
        };
    }

    public static MapGroup metadataMapGroup(StarTable table) {
        int icol;
        MapGroup group = new MapGroup();
        int ncol = table.getColumnCount();
        HashMap<String, ValueInfo> auxInfos = new HashMap<String, ValueInfo>();
        for (icol = 0; icol < ncol; ++icol) {
            for (Object item : table.getColumnInfo(icol).getAuxData()) {
                if (!(item instanceof DescribedValue)) continue;
                DescribedValue dval = (DescribedValue)item;
                ValueInfo info = dval.getInfo();
                String name = info.getName();
                if (auxInfos.containsKey(name)) {
                    info = DefaultValueInfo.generalise((ValueInfo)((ValueInfo)auxInfos.get(name)), (ValueInfo)info);
                }
                auxInfos.put(name, info);
            }
        }
        for (icol = 0; icol < ncol; ++icol) {
            UCD u;
            ColumnInfo info = table.getColumnInfo(icol);
            HashMap<ValueInfo, Object> map = new HashMap<ValueInfo, Object>();
            map.put(INDEX_INFO, new Integer(icol + 1));
            map.put(NAME_INFO, info.getName());
            map.put(CLASS_INFO, DefaultValueInfo.formatClass((Class)info.getContentClass()));
            map.put(UNIT_INFO, info.getUnitString());
            map.put(SHAPE_INFO, info.getShape());
            int elsize = info.getElementSize();
            if (elsize >= 0) {
                map.put(ELSIZE_INFO, info.getElementSize());
            }
            map.put(DESCRIPTION_INFO, info.getDescription());
            String ucd = info.getUCD();
            map.put(UCD_INFO, ucd);
            if (ucd != null && (u = UCD.getUCD((String)ucd)) != null) {
                map.put(UCDDESC_INFO, u.getDescription());
            }
            map.put(UTYPE_INFO, info.getUtype());
            if (!auxInfos.isEmpty()) {
                for (Object item : info.getAuxData()) {
                    if (!(item instanceof DescribedValue)) continue;
                    DescribedValue dval = (DescribedValue)item;
                    ValueInfo auxInfo = (ValueInfo)auxInfos.get(dval.getInfo().getName());
                    map.put(auxInfo, dval.getValue());
                }
            }
            group.addMap(map);
        }
        return group;
    }

    private static ValueInfo[] getKeys(MapGroup group, String[] itemNames) {
        ValueInfo[] keys;
        Map[] maps = group.getMaps().toArray(new Map[0]);
        if (itemNames == null) {
            ArrayList<ValueInfo> keyList = new ArrayList<ValueInfo>();
            for (ValueInfo info : group.getKnownKeys()) {
                boolean hasSome = false;
                for (int imap = 0; !hasSome && imap < maps.length; ++imap) {
                    hasSome = hasSome || !Tables.isBlank(maps[imap].get(info));
                }
                if (!hasSome) continue;
                keyList.add(info);
            }
            keys = keyList.toArray(new ValueInfo[0]);
        } else {
            keys = new ValueInfo[itemNames.length];
            for (int i = 0; i < itemNames.length; ++i) {
                String item = itemNames[i];
                DefaultValueInfo itemInfo = null;
                Iterator it = group.getKnownKeys().iterator();
                while (it.hasNext() && itemInfo == null) {
                    ValueInfo info = (ValueInfo)it.next();
                    if (!info.getName().equalsIgnoreCase(item)) continue;
                    itemInfo = info;
                }
                if (itemInfo == null) {
                    itemInfo = new DefaultValueInfo(item, String.class);
                }
                keys[i] = itemInfo;
            }
        }
        return keys;
    }
}

