/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ColumnSupplement;
import uk.ac.starlink.ttools.filter.SupplementSequence;
import uk.ac.starlink.ttools.filter.UnitColumnSupplement;

public class PermutedColumnSupplement
implements ColumnSupplement {
    private final ColumnSupplement baseSup_;
    private final int[] colMap_;
    private final int ncol_;

    public PermutedColumnSupplement(ColumnSupplement baseSup, int[] colMap) {
        this.baseSup_ = baseSup;
        this.colMap_ = colMap;
        this.ncol_ = colMap.length;
    }

    public PermutedColumnSupplement(StarTable baseTable, int[] colMap) {
        this(new UnitColumnSupplement(baseTable), colMap);
    }

    @Override
    public int getColumnCount() {
        return this.colMap_.length;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.baseSup_.getColumnInfo(this.colMap_[icol]);
    }

    @Override
    public Object getCell(long irow, int icol) throws IOException {
        return this.baseSup_.getCell(irow, this.colMap_[icol]);
    }

    @Override
    public Object[] getRow(long irow) throws IOException {
        Object[] row = new Object[this.ncol_];
        for (int ic = 0; ic < this.ncol_; ++ic) {
            row[ic] = this.baseSup_.getCell(irow, this.colMap_[ic]);
        }
        return row;
    }

    @Override
    public SupplementSequence createSequence(RowSequence rseq) throws IOException {
        final SupplementSequence sseq = this.baseSup_.createSequence(rseq);
        return new SupplementSequence(){

            @Override
            public Object getCell(long irow, int icol) throws IOException {
                return sseq.getCell(irow, PermutedColumnSupplement.this.colMap_[icol]);
            }

            @Override
            public Object[] getRow(long irow) throws IOException {
                Object[] row = new Object[PermutedColumnSupplement.this.ncol_];
                for (int ic = 0; ic < PermutedColumnSupplement.this.ncol_; ++ic) {
                    row[ic] = sseq.getCell(irow, PermutedColumnSupplement.this.colMap_[ic]);
                }
                return row;
            }
        };
    }
}

