/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import uk.ac.starlink.table.Tables;

public abstract class QuantCalc {
    public static final double MAD_SCALE = 1.4826;
    private final Class clazz_;

    protected QuantCalc(Class clazz) {
        if (!Number.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " not number");
        }
        this.clazz_ = clazz;
    }

    public abstract void acceptDatum(Object var1);

    public abstract void ready();

    public abstract Number getQuantile(double var1);

    public abstract long getValueCount();

    public abstract Iterator<Number> getValueIterator();

    public static QuantCalc createInstance(Class clazz, long nrow) throws IOException {
        if (clazz == Byte.class) {
            return new ByteSlotQuantCalc();
        }
        if (clazz == Short.class && (nrow < 0L || nrow > 65536L)) {
            return new ShortSlotQuantCalc();
        }
        if (clazz == Integer.class) {
            return new CountMapQuantCalc(Integer.class);
        }
        if (clazz == Long.class) {
            return new CountMapQuantCalc(Long.class);
        }
        if (nrow >= 0L && nrow < Integer.MAX_VALUE) {
            return new FloatArrayQuantCalc(clazz, (int)nrow);
        }
        if (nrow >= Integer.MAX_VALUE) {
            throw new IOException("Sorry, too many rows for quantile calculation (" + nrow + " > " + Integer.MAX_VALUE);
        }
        return new ObjectListQuantCalc(clazz);
    }

    public static double calculateMedianAbsoluteDeviation(QuantCalc qcalc) throws IOException {
        double median = qcalc.getQuantile(0.5).doubleValue();
        QuantCalc madCalc = QuantCalc.createInstance(Double.class, qcalc.getValueCount());
        Iterator<Number> it = qcalc.getValueIterator();
        while (it.hasNext()) {
            double val = it.next().doubleValue();
            madCalc.acceptDatum(Math.abs(val - median));
        }
        madCalc.ready();
        return madCalc.getQuantile(0.5).doubleValue();
    }

    static class CountMapQuantCalc
    extends QuantCalc {
        private final Class clazz_;
        private Map<Number, Integer> countMap_;
        private long count_;
        private static final Integer ONE = new Integer(1);

        public CountMapQuantCalc(Class<? extends Number> clazz) {
            super(clazz);
            this.clazz_ = clazz;
            this.countMap_ = new HashMap<Number, Integer>();
        }

        @Override
        public void acceptDatum(Object obj) {
            if (obj != null && obj.getClass() == this.clazz_ && !Tables.isBlank((Object)obj)) {
                ++this.count_;
                Number num = (Number)obj;
                Integer value = this.countMap_.get(obj);
                if (value == null) {
                    this.countMap_.put(num, ONE);
                } else {
                    this.countMap_.put(num, new Integer(value + 1));
                }
            }
        }

        @Override
        public void ready() {
            this.countMap_ = new TreeMap<Number, Integer>(this.countMap_);
        }

        @Override
        public long getValueCount() {
            return this.count_;
        }

        @Override
        public Number getQuantile(double quant) {
            long point = Math.min((long)(quant * (double)this.count_), this.count_ - 1L);
            long nval = 0L;
            for (Map.Entry<Number, Integer> entry : this.countMap_.entrySet()) {
                if ((nval += (long)entry.getValue().intValue()) <= point) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public Iterator<Number> getValueIterator() {
            return new Iterator<Number>(){
                Iterator<Map.Entry<Number, Integer>> countIt;
                int ic;
                Number num;
                {
                    this.countIt = CountMapQuantCalc.this.countMap_.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.ic == 0 && this.countIt.hasNext()) {
                        Map.Entry<Number, Integer> entry = this.countIt.next();
                        this.num = entry.getKey();
                        this.ic = entry.getValue();
                    }
                    return this.ic > 0;
                }

                @Override
                public Number next() {
                    if (this.hasNext()) {
                        --this.ic;
                        return this.num;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class ShortSlotQuantCalc
    extends QuantCalc {
        private final int offset_ = 32768;
        private final int[] slots_ = new int[65536];
        private long count_;

        public ShortSlotQuantCalc() {
            super(Short.class);
        }

        @Override
        public void acceptDatum(Object obj) {
            if (obj instanceof Short) {
                short sval = (Short)obj;
                ++this.count_;
                int n = sval + 32768;
                this.slots_[n] = this.slots_[n] + 1;
            }
        }

        @Override
        public void ready() {
        }

        @Override
        public long getValueCount() {
            return this.count_;
        }

        @Override
        public Number getQuantile(double quant) {
            long point = Math.min((long)(quant * (double)this.count_), this.count_ - 1L);
            long nval = 0L;
            for (short sval = Short.MIN_VALUE; sval < 32768; sval = (short)(sval + 1)) {
                if ((nval += (long)this.slots_[sval + 32768]) <= point) continue;
                return new Short(sval);
            }
            return null;
        }

        @Override
        public Iterator<Number> getValueIterator() {
            return new Iterator<Number>(){
                int is;
                int ic;
                Short sval;

                @Override
                public boolean hasNext() {
                    while (this.ic == 0 && this.is < ShortSlotQuantCalc.this.slots_.length) {
                        this.sval = new Short((short)(this.is - 32768));
                        this.ic = ShortSlotQuantCalc.this.slots_[this.is++];
                    }
                    return this.ic > 0;
                }

                @Override
                public Number next() {
                    if (this.hasNext()) {
                        --this.ic;
                        return this.sval;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class ByteSlotQuantCalc
    extends QuantCalc {
        private final int offset_ = 128;
        private final int[] slots_ = new int[256];
        private long count_;

        public ByteSlotQuantCalc() {
            super(Byte.class);
        }

        @Override
        public void acceptDatum(Object obj) {
            if (obj instanceof Byte) {
                byte bval = (Byte)obj;
                ++this.count_;
                int n = bval + 128;
                this.slots_[n] = this.slots_[n] + 1;
            }
        }

        @Override
        public void ready() {
        }

        @Override
        public long getValueCount() {
            return this.count_;
        }

        @Override
        public Number getQuantile(double quant) {
            long point = Math.min((long)(quant * (double)this.count_), this.count_ - 1L);
            long nval = 0L;
            for (byte bval = -128; bval < 128; bval = (byte)(bval + 1)) {
                if ((nval += (long)this.slots_[bval + 128]) <= point) continue;
                return new Byte(bval);
            }
            return null;
        }

        @Override
        public Iterator<Number> getValueIterator() {
            return new Iterator<Number>(){
                int is;
                int ic;
                Byte bval;

                @Override
                public boolean hasNext() {
                    while (this.ic == 0 && this.is < ByteSlotQuantCalc.this.slots_.length) {
                        this.bval = new Byte((byte)(this.is - 128));
                        this.ic = ByteSlotQuantCalc.this.slots_[this.is++];
                    }
                    return this.ic > 0;
                }

                @Override
                public Number next() {
                    if (this.hasNext()) {
                        --this.ic;
                        return this.bval;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class FloatArrayQuantCalc
    extends QuantCalc {
        final float[] array_;
        final Class clazz_;
        int irow_;

        public FloatArrayQuantCalc(Class clazz, int nrow) {
            super(clazz);
            this.clazz_ = clazz;
            this.array_ = new float[nrow];
        }

        @Override
        public void acceptDatum(Object obj) {
            float fval;
            if (this.irow_ < this.array_.length && obj instanceof Number && !Float.isNaN(fval = ((Number)obj).floatValue())) {
                this.array_[this.irow_++] = fval;
            }
        }

        @Override
        public void ready() {
            Arrays.sort(this.array_, 0, this.irow_);
        }

        @Override
        public long getValueCount() {
            return this.irow_;
        }

        @Override
        public Number getQuantile(double quant) {
            if (this.irow_ == 0) {
                return null;
            }
            float quantile = this.array_[Math.min((int)(quant * (double)this.irow_), this.irow_ - 1)];
            if (this.clazz_ == Float.class || this.clazz_ == Double.class) {
                return new Float(quantile);
            }
            if (this.clazz_ == Byte.class) {
                return new Byte((byte)quantile);
            }
            if (this.clazz_ == Short.class) {
                return new Short((short)quantile);
            }
            if (this.clazz_ == Integer.class) {
                return new Integer((int)quantile);
            }
            if (this.clazz_ == Long.class) {
                return new Long((long)quantile);
            }
            return null;
        }

        @Override
        public Iterator<Number> getValueIterator() {
            return new Iterator<Number>(){
                int i;

                @Override
                public boolean hasNext() {
                    return this.i < FloatArrayQuantCalc.this.irow_;
                }

                @Override
                public Number next() {
                    return new Float(FloatArrayQuantCalc.this.array_[this.i++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class ObjectListQuantCalc
    extends QuantCalc {
        final Class clazz_;
        final List<Number> list_;

        public ObjectListQuantCalc(Class clazz) {
            super(clazz);
            this.clazz_ = clazz;
            this.list_ = new ArrayList<Number>();
        }

        @Override
        public void acceptDatum(Object obj) {
            Number num;
            double dval;
            if (obj != null && obj.getClass().equals(this.clazz_) && !Double.isNaN(dval = (num = (Number)obj).doubleValue())) {
                this.list_.add(num);
            }
        }

        @Override
        public void ready() {
            Collections.sort(this.list_);
        }

        @Override
        public long getValueCount() {
            return this.list_.size();
        }

        @Override
        public Number getQuantile(double quant) {
            return this.list_.isEmpty() ? (Number)null : (Number)this.list_.get(Math.min((int)(quant * (double)this.list_.size()), this.list_.size() - 1));
        }

        @Override
        public Iterator<Number> getValueIterator() {
            return this.list_.iterator();
        }
    }
}

