/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class RandomViewFilter
extends BasicFilter
implements ProcessingStep {
    public RandomViewFilter() {
        super("randomview", null);
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Ensures that steps downstream only use random access methods", "for table access.", "If the table is sequential only, this will result in an error.", "Only useful for debugging.", "</p>"};
    }

    @Override
    public ProcessingStep createStep(Iterator argIt) {
        return this;
    }

    @Override
    public StarTable wrap(final StarTable base) throws IOException {
        if (base.isRandom()) {
            return new WrapperStarTable(base){

                public RowSequence getRowSequence() {
                    return new RandomRowSequence(base);
                }
            };
        }
        throw new IOException("Table is not random");
    }
}

