/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;

public class RangeFilter
extends BasicFilter {
    public RangeFilter() {
        super("rowrange", "<first> <last>|+<count>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Includes only rows in a given range.", "The range can either be supplied as", "\"<code>&lt;first&gt; &lt;last&gt;</code>\",", "where row indices are inclusive, or", "\"<code>&lt;first&gt; +&lt;count&gt;</code>\".", "In either case, the first row is numbered 1.", "</p>", "<p>Thus, to get the first hundred rows, use either", "\"<code>rowrange 1 100</code>\" or", "\"<code>rowrange 1 +100</code>\"", "and to get the second hundred, either", "\"<code>rowrange 101 200</code>\" or", "\"<code>rowrange 101 +100</code>\"", "</p>"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        long ilast;
        if (!argIt.hasNext()) throw new ArgException("Arg <first> not given");
        String iStr = (String)argIt.next();
        argIt.remove();
        if (!iStr.matches("[1-9][0-9]*")) {
            throw new ArgException("Row index " + iStr + " must be integer >0");
        }
        long ifirst = Long.parseLong(iStr);
        if (!argIt.hasNext()) throw new ArgException("Arg <last>|+<count> not given");
        String iStr2 = (String)argIt.next();
        argIt.remove();
        if (iStr2.matches("\\+[0-9]+")) {
            ilast = ifirst + Long.parseLong(iStr2.substring(1)) - 1L;
        } else {
            if (!iStr2.matches("[0-9]+")) throw new ArgException("Row index " + iStr2 + " not numeric");
            ilast = Long.parseLong(iStr2);
            if (ifirst > ilast) {
                throw new ArgException(ifirst + " > " + ilast);
            }
        }
        final long ifrom = ifirst - 1L;
        final long ito = ilast;
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable base) {
                return new RangeTable(base, ifrom, ito);
            }
        };
    }

    private static class RangeTable
    extends WrapperStarTable {
        private final long ifrom_;
        private final long ito_;

        RangeTable(StarTable base, long ifrom, long ito) {
            super(base);
            this.ifrom_ = ifrom;
            this.ito_ = ito;
        }

        public long getRowCount() {
            long nbase = super.getRowCount();
            return nbase > 0L ? Math.min(nbase, this.ito_) - this.ifrom_ : -1L;
        }

        public Object getCell(long irow, int icol) throws IOException {
            return super.getCell(this.convertRow(irow), icol);
        }

        public Object[] getRow(long irow) throws IOException {
            return super.getRow(this.convertRow(irow));
        }

        public RowSequence getRowSequence() throws IOException {
            if (this.getRowCount() == 0L) {
                return EmptyRowSequence.getInstance();
            }
            if (this.isRandom()) {
                return new RandomRowSequence((StarTable)this);
            }
            RowSequence baseSeq = super.getRowSequence();
            for (long i = 0L; i < this.ifrom_ && baseSeq.next(); ++i) {
            }
            return new WrapperRowSequence(baseSeq){
                long nleft;
                {
                    this.nleft = RangeTable.this.ito_ - RangeTable.this.ifrom_;
                }

                public boolean next() throws IOException {
                    return this.nleft-- > 0L && super.next();
                }
            };
        }

        private long convertRow(long irow) {
            if (irow >= 0L && irow < this.ito_ - this.ifrom_) {
                return irow + this.ifrom_;
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

