/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class RepeatTable
extends WrapperStarTable {
    private final long count_;
    private final boolean byrow_;

    public RepeatTable(StarTable base, long count, boolean byrow) {
        super(base);
        this.count_ = count;
        this.byrow_ = byrow;
    }

    public long getRowCount() {
        long baseNrow = super.getRowCount();
        return baseNrow >= 0L ? this.count_ * baseNrow : baseNrow;
    }

    public Object getCell(long irow, int icol) throws IOException {
        return super.getCell(this.getBaseRow(irow), icol);
    }

    public Object[] getRow(long irow) throws IOException {
        return super.getRow(this.getBaseRow(irow));
    }

    public RowSequence getRowSequence() throws IOException {
        if (this.byrow_) {
            return new WrapperRowSequence(super.getRowSequence()){
                private long iseq_;
                {
                    this.iseq_ = 0L;
                }

                public boolean next() throws IOException {
                    boolean hasNext;
                    boolean bl = hasNext = this.iseq_ > 0L || super.next();
                    if (hasNext) {
                        this.iseq_ = (this.iseq_ + 1L) % RepeatTable.this.count_;
                    }
                    return hasNext;
                }
            };
        }
        return new RowSequence(){
            private long remaining_;
            private RowSequence rseq_;
            {
                this.remaining_ = RepeatTable.this.count_;
                this.rseq_ = EmptyRowSequence.getInstance();
            }

            public boolean next() throws IOException {
                if (this.rseq_.next()) {
                    return true;
                }
                if (this.remaining_ > 0L) {
                    --this.remaining_;
                    this.rseq_.close();
                    this.rseq_ = RepeatTable.this.getBaseTable().getRowSequence();
                    return this.rseq_.next();
                }
                return false;
            }

            public Object getCell(int icol) throws IOException {
                return this.rseq_.getCell(icol);
            }

            public Object[] getRow() throws IOException {
                return this.rseq_.getRow();
            }

            public void close() throws IOException {
                this.rseq_.close();
            }
        };
    }

    private long getBaseRow(long irow) {
        long baseNrow = super.getRowCount();
        if (baseNrow < 0L) {
            throw new UnsupportedOperationException("Not random access");
        }
        if (baseNrow == 0L) {
            throw new IllegalArgumentException("Table has no rows");
        }
        if (irow / baseNrow < this.count_) {
            return this.byrow_ ? irow / this.count_ : irow % baseNrow;
        }
        throw new IllegalArgumentException("No such row " + irow);
    }
}

