/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.JELColumnSupplement;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class ReplaceColumnFilter
extends BasicFilter {
    public ReplaceColumnFilter() {
        super("replacecol", "[-name <name>] [-units <units>] [-ucd <ucd>] [-utype <utype>]\n[-desc <descrip>]\n<col-id> <expr>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Replaces the content of a column with the value of an", "algebraic expression.", "The old values are discarded in favour of the result of", "evaluating <code>&lt;expr&gt;</code>.", "You can specify the metadata for the new column using the", "<code>-name</code>, <code>-units</code>, <code>-ucd</code>,", "<code>-utype</code>", "and <code>-desc</code> flags; for any of these items which you", "do not specify, they will take the values from the column", "being replaced.", "</p>", "<p>It is legal to reference the replaced column in the", "expression,", "so for example \"<code>replacecol pixsize pixsize*2</code>\"", "just multiplies the values in column <code>pixsize</code> by 2.", "</p>", ReplaceColumnFilter.explainSyntax(new String[]{"col-id", "expr"})};
    }

    @Override
    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String colId = null;
        String expr = null;
        String rename = null;
        String units = null;
        String ucd = null;
        String utype = null;
        String description = null;
        while (argIt.hasNext() && (colId == null || expr == null)) {
            String arg = (String)argIt.next();
            if (arg.equals("-name") && argIt.hasNext()) {
                argIt.remove();
                rename = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-units") && argIt.hasNext()) {
                argIt.remove();
                units = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-ucd") && argIt.hasNext()) {
                argIt.remove();
                ucd = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-utype") && argIt.hasNext()) {
                argIt.remove();
                utype = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (arg.equals("-desc") && argIt.hasNext()) {
                argIt.remove();
                description = (String)argIt.next();
                argIt.remove();
                continue;
            }
            if (colId == null) {
                argIt.remove();
                colId = arg;
                continue;
            }
            if (expr != null) continue;
            argIt.remove();
            expr = arg;
        }
        if (colId != null && expr != null) {
            return new ReplaceColumnStep(colId, expr, rename, units, ucd, utype, description);
        }
        throw new ArgException("Bad " + this.getName() + " specification");
    }

    private static class ReplaceColumnStep
    implements ProcessingStep {
        final String colId_;
        final String expr_;
        final String name_;
        final String units_;
        final String ucd_;
        final String utype_;
        final String description_;

        ReplaceColumnStep(String colId, String expr, String name, String units, String ucd, String utype, String description) {
            this.colId_ = colId;
            this.expr_ = expr;
            this.name_ = name;
            this.units_ = units;
            this.ucd_ = ucd;
            this.utype_ = utype;
            this.description_ = description;
        }

        @Override
        public StarTable wrap(StarTable base) throws IOException {
            int icol = new ColumnIdentifier(base).getColumnIndex(this.colId_);
            ColumnInfo cinfo = new ColumnInfo(base.getColumnInfo(icol));
            if (this.name_ != null) {
                cinfo.setName(this.name_);
            }
            if (this.units_ != null) {
                cinfo.setUnitString(this.units_);
            }
            if (this.ucd_ != null) {
                cinfo.setUCD(this.ucd_);
            }
            if (this.utype_ != null) {
                cinfo.setUtype(this.utype_);
            }
            if (this.description_ != null) {
                cinfo.setDescription(this.description_);
            }
            cinfo.setNullable(true);
            cinfo.setElementSize(-1);
            cinfo.setShape(new int[]{-1});
            JELColumnSupplement jelSup = new JELColumnSupplement(base, this.expr_, cinfo);
            AddColumnsTable addTable = new AddColumnsTable(base, jelSup, icol);
            ColumnPermutedStarTable removed = ColumnPermutedStarTable.deleteColumns((StarTable)addTable, (int[])new int[]{icol + 1});
            return removed;
        }
    }
}

