/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BadValueFilter;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.ReplaceValueTable;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class ReplaceValueFilter
extends BasicFilter {
    public ReplaceValueFilter() {
        super("replaceval", "<old-val> <new-val> <colid-list>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>For each column specified in <code>&lt;colid-list&gt;</code>", "any instance of <code>&lt;old-val&gt;</code> is replaced by", "<code>&lt;new-val&gt;</code>.", "The value string '<code>null</code>' can be used for either", "<code>&lt;old-value&gt;</code> or <code>&lt;new-value&gt;</code>", "to indicate a blank value", "(but see also the " + DocUtils.filterRef(new BadValueFilter()), "filter).", "</p>", ReplaceValueFilter.explainSyntax(new String[]{"colid-list"})};
    }

    @Override
    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String oldStr = null;
        String newStr = null;
        String colIdList = null;
        while (argIt.hasNext()) {
            String arg = (String)argIt.next();
            if (oldStr == null) {
                oldStr = arg;
                argIt.remove();
                continue;
            }
            if (newStr == null) {
                newStr = arg;
                argIt.remove();
                continue;
            }
            if (colIdList != null) break;
            colIdList = arg;
            argIt.remove();
        }
        if (oldStr != null && newStr != null && colIdList != null) {
            final String fOldStr = oldStr.equals("null") ? null : oldStr;
            final String fNewStr = newStr.equals("null") ? null : newStr;
            final String fColIdList = colIdList;
            return new ProcessingStep(){

                @Override
                public StarTable wrap(StarTable base) throws IOException {
                    return new ReplaceValueTable(base, new ColumnIdentifier(base).getColumnFlags(fColIdList), fOldStr, fNewStr);
                }
            };
        }
        throw new ArgException("Bad " + this.getName() + " specification");
    }
}

