/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.table.WrapperStarTable;

public class ReplaceValueTable
extends WrapperStarTable {
    private static final Replacer unitReplacer_ = new Replacer(true){

        @Override
        public Object replaceValue(Object obj) {
            return obj;
        }
    };
    private static final double FLOAT_TOL = (double)2.8E-45f;
    private static final double DOUBLE_TOL = 9.9E-324;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.filter");
    private final Replacer[] replacers_;

    public ReplaceValueTable(StarTable baseTable, boolean[] colFlags, String oldStr, String newStr) throws IOException {
        super(baseTable);
        int ncol = baseTable.getColumnCount();
        this.replacers_ = new Replacer[ncol];
        for (int i = 0; i < ncol; ++i) {
            this.replacers_[i] = colFlags[i] ? ReplaceValueTable.createReplacer(baseTable.getColumnInfo(i), oldStr, newStr) : unitReplacer_;
        }
    }

    public ReplaceValueTable(StarTable baseTable, int[] icols, String[] oldStrs, String[] newStrs) throws IOException {
        super(baseTable);
        int ncol = baseTable.getColumnCount();
        this.replacers_ = new Replacer[ncol];
        Arrays.fill(this.replacers_, unitReplacer_);
        for (int i = 0; i < icols.length; ++i) {
            int icol = icols[i];
            this.replacers_[icol] = ReplaceValueTable.createReplacer(baseTable.getColumnInfo(icol), oldStrs[i], newStrs[i]);
        }
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.replacers_[icol].adjustColumnInfo(super.getColumnInfo(icol));
    }

    public Object getCell(long irow, int icol) throws IOException {
        return this.replacers_[icol].replaceValue(super.getCell(irow, icol));
    }

    public Object[] getRow(long irow) throws IOException {
        Object[] row = super.getRow(irow);
        for (int icol = 0; icol < row.length; ++icol) {
            row[icol] = this.replacers_[icol].replaceValue(row[icol]);
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        return new WrapperRowSequence(super.getRowSequence()){

            public Object getCell(int icol) throws IOException {
                return ReplaceValueTable.this.replacers_[icol].replaceValue(super.getCell(icol));
            }

            public Object[] getRow() throws IOException {
                Object[] row = super.getRow();
                for (int icol = 0; icol < row.length; ++icol) {
                    row[icol] = ReplaceValueTable.this.replacers_[icol].replaceValue(row[icol]);
                }
                return row;
            }
        };
    }

    private static Replacer createReplacer(ColumnInfo info, String oldStr, String newStr) throws IOException {
        try {
            Object oldVal;
            Object newValue;
            Class clazz = info.getContentClass();
            boolean oldBlank = ReplaceValueTable.isBlank(oldStr, (ValueInfo)info);
            boolean newBlank = ReplaceValueTable.isBlank(newStr, (ValueInfo)info);
            Object object = newValue = newBlank ? null : info.unformatString(newStr);
            if (oldBlank) {
                return new Replacer(newBlank){

                    @Override
                    public Object replaceValue(Object obj) {
                        return Tables.isBlank((Object)obj) ? newValue : obj;
                    }
                };
            }
            if (clazz == Double.class) {
                final double oldVal2 = Double.parseDouble(oldStr);
                return new Replacer(true){

                    @Override
                    public Object replaceValue(Object obj) {
                        if (obj instanceof Double) {
                            double value = (Double)obj;
                            return value == oldVal2 || Math.abs(value - oldVal2) <= 9.9E-324 ? newValue : obj;
                        }
                        return obj;
                    }
                };
            }
            if (clazz == Float.class) {
                final float oldVal3 = Float.parseFloat(oldStr);
                return new Replacer(true){

                    @Override
                    public Object replaceValue(Object obj) {
                        if (obj instanceof Float) {
                            float value = ((Float)obj).floatValue();
                            return value == oldVal3 || (double)Math.abs(value - oldVal3) <= (double)2.8E-45f ? newValue : obj;
                        }
                        return obj;
                    }
                };
            }
            try {
                oldVal = info.unformatString(oldStr);
            }
            catch (IllegalArgumentException e) {
                logger_.info("No replacements in column " + info.getName() + " (" + oldStr + " not " + ColumnInfo.formatClass((Class)info.getContentClass()) + ")");
                return unitReplacer_;
            }
            return new Replacer(newBlank){

                @Override
                public Object replaceValue(Object obj) {
                    return oldVal.equals(obj) ? newValue : obj;
                }
            };
        }
        catch (IllegalArgumentException e) {
            String msg = "Can't replace \"" + oldStr + "\" with \"" + newStr + "\" in " + ColumnInfo.formatClass((Class)info.getContentClass()) + " column " + info.getName();
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    private static boolean isBlank(String str, ValueInfo info) {
        if (str == null || str.length() == 0 || Tables.isBlank((Object)str) || "NULL".equals(str)) {
            return true;
        }
        return (Float.class.equals((Object)info.getContentClass()) || Double.class.equals((Object)info.getContentClass())) && "NaN".equals(str);
    }

    private static abstract class Replacer {
        private final boolean keepShape_;

        Replacer(boolean keepShape) {
            this.keepShape_ = keepShape;
        }

        public abstract Object replaceValue(Object var1);

        public ColumnInfo adjustColumnInfo(ColumnInfo info) {
            if (!this.keepShape_) {
                info = new ColumnInfo(info);
                info.setElementSize(-1);
            }
            return info;
        }
    }
}

