/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import uk.ac.starlink.table.RowPermutedStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Tokenizer;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.RandomJELRowReader;

public class SortFilter
extends BasicFilter {
    public SortFilter() {
        super("sort", "[-down] [-nullsfirst] <key-list>");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Sorts the table according to the value of one or more", "algebraic expressions.", "The sort key expressions appear,", "as separate (space-separated) words,", "in <code>&lt;key-list&gt;</code>; sorting is done on the", "first expression first, but if that results in a tie then", "the second one is used, and so on.", "</p>", "<p>Each expression must evaluate to a type that", "it makes sense to sort, for instance numeric.", "If the <code>-down</code> flag is used, the sort order is", "descending rather than ascending.", "</p>", "<p>Blank entries are by default considered to come at the end", "of the collation sequence, but if the <code>-nullsfirst</code>", "flag is given then they are considered to come at the start", "instead.", "</p>", SortFilter.explainSyntax(new String[]{"key-list"})};
    }

    @Override
    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String[] keys;
        boolean up = true;
        boolean nullsLast = true;
        String exprs = null;
        while (argIt.hasNext() && exprs == null) {
            String arg = (String)argIt.next();
            if (arg.equals("-down")) {
                argIt.remove();
                up = false;
                continue;
            }
            if (arg.equals("-nullsfirst")) {
                argIt.remove();
                nullsLast = false;
                continue;
            }
            if (exprs != null) continue;
            argIt.remove();
            exprs = arg;
        }
        if (exprs == null) {
            throw new ArgException("No sort keys given");
        }
        try {
            keys = Tokenizer.tokenizeWords(exprs);
            if (keys.length == 0) {
                throw new ArgException("No sort keys given");
            }
        }
        catch (TaskException e) {
            throw new ArgException("Bad <key-list>: " + exprs, e);
        }
        return new SortStep(keys, up, nullsLast);
    }

    private static class SortException
    extends RuntimeException {
        SortException(String msg, Throwable e) {
            super(msg, e);
        }

        IOException asIOException() {
            Throwable error = this.getCause();
            return error instanceof IOException ? (IOException)error : (IOException)new IOException(error.getMessage()).initCause(error);
        }
    }

    private static class RowComparator
    implements Comparator {
        final CompiledExpression[] compExs_;
        final int nexpr_;
        final RandomJELRowReader rowReader_;
        boolean up_;
        boolean nullsLast_;

        public RowComparator(StarTable table, String[] keys, boolean up, boolean nullsLast) throws CompilationException {
            this.nexpr_ = keys.length;
            this.up_ = up;
            this.nullsLast_ = nullsLast;
            this.rowReader_ = new RandomJELRowReader(table);
            Library lib = JELUtils.getLibrary(this.rowReader_);
            this.compExs_ = new CompiledExpression[this.nexpr_];
            for (int i = 0; i < this.nexpr_; ++i) {
                this.compExs_[i] = JELUtils.compile(lib, table, keys[i]);
            }
        }

        public int compare(Object o1, Object o2) {
            long row1 = ((Number)o1).longValue();
            long row2 = ((Number)o2).longValue();
            int c = 0;
            for (int i = 0; i < this.nexpr_ && c == 0; ++i) {
                Object val2;
                Object val1;
                CompiledExpression compEx = this.compExs_[i];
                try {
                    val1 = this.rowReader_.evaluateAtRow(compEx, row1);
                    val2 = this.rowReader_.evaluateAtRow(compEx, row2);
                }
                catch (Throwable e) {
                    throw new SortException("Sort error", e);
                }
                try {
                    c = this.compareValues((Comparable)val1, (Comparable)val2);
                    continue;
                }
                catch (ClassCastException e) {
                    throw new SortException("Expression comparison error during sorting", e);
                }
            }
            return this.up_ ? c : -c;
        }

        private int compareValues(Comparable o1, Comparable o2) {
            boolean null1 = Tables.isBlank((Object)o1);
            boolean null2 = Tables.isBlank((Object)o2);
            if (null1 && null2) {
                return 0;
            }
            if (null1) {
                return this.nullsLast_ ? 1 : -1;
            }
            if (null2) {
                return this.nullsLast_ ? -1 : 1;
            }
            return o1.compareTo(o2);
        }
    }

    private static class SortStep
    implements ProcessingStep {
        final String[] keys_;
        final boolean up_;
        final boolean nullsLast_;

        SortStep(String[] keys, boolean up, boolean nullsLast) {
            this.keys_ = keys;
            this.up_ = up;
            this.nullsLast_ = nullsLast;
        }

        @Override
        public StarTable wrap(StarTable baseTable) throws IOException {
            RowComparator keyComparator;
            long lnrow = (baseTable = Tables.randomTable((StarTable)baseTable)).getRowCount();
            if (lnrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Sorry, can't sort tables with >2^31 rows");
            }
            int nrow = (int)lnrow;
            Number[] rowMap = new Number[nrow];
            for (int i = 0; i < nrow; ++i) {
                rowMap[i] = new Integer(i);
            }
            try {
                keyComparator = new RowComparator(baseTable, this.keys_, this.up_, this.nullsLast_);
            }
            catch (CompilationException e) {
                throw (IOException)new IOException("Bad sort key(s)").initCause(e);
            }
            try {
                Arrays.sort(rowMap, keyComparator);
            }
            catch (SortException e) {
                throw e.asIOException();
            }
            long[] rmap = new long[nrow];
            for (int i = 0; i < nrow; ++i) {
                rmap[i] = rowMap[i].longValue();
            }
            return new RowPermutedStarTable(baseTable, rmap);
        }
    }
}

