/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.io.IOException;
import java.lang.reflect.Array;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.filter.QuantCalc;

public class Arrays {
    private Arrays() {
    }

    public static double sum(Object array) {
        try {
            int n = Array.getLength(array);
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d)) continue;
                sum += d;
            }
            return sum;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double mean(Object array) {
        try {
            int n = Array.getLength(array);
            double sum = 0.0;
            int count = 0;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d)) continue;
                sum += d;
                ++count;
            }
            return sum / (double)count;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double variance(Object array) {
        try {
            int n = Array.getLength(array);
            double sum = 0.0;
            double sum2 = 0.0;
            int count = 0;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d)) continue;
                sum += d;
                sum2 += d * d;
                ++count;
            }
            double mean = sum / (double)count;
            return sum2 / (double)count - mean * mean;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double stdev(Object array) {
        return Math.sqrt(Arrays.variance(array));
    }

    public static double minimum(Object array) {
        try {
            int n = Array.getLength(array);
            double min = Double.NaN;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d) || d > min) continue;
                min = d;
            }
            return min;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double maximum(Object array) {
        try {
            int n = Array.getLength(array);
            double max = Double.NaN;
            for (int i = 0; i < n; ++i) {
                double d = Array.getDouble(array, i);
                if (Double.isNaN(d) || d < max) continue;
                max = d;
            }
            return max;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }

    public static double median(Object array) {
        return Arrays.quantile(array, 0.5);
    }

    public static double quantile(Object array, double quant) {
        try {
            int n = Array.getLength(array);
            QuantCalc qc = QuantCalc.createInstance(Double.class, n);
            for (int i = 0; i < n; ++i) {
                qc.acceptDatum(new Double(Array.getDouble(array, i)));
            }
            qc.ready();
            Number value = qc.getQuantile(quant);
            return value instanceof Number ? value.doubleValue() : Double.NaN;
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
        catch (IOException e) {
            return Double.NaN;
        }
    }

    public static int size(Object array) {
        return array != null && array.getClass().isArray() ? Array.getLength(array) : 0;
    }

    public static int count(Object array) {
        try {
            int n = Array.getLength(array);
            int count = 0;
            for (int i = 0; i < n; ++i) {
                if (Tables.isBlank((Object)Array.get(array, i))) continue;
                ++count;
            }
            return count;
        }
        catch (RuntimeException e) {
            return 0;
        }
    }

    public static int countTrue(boolean[] array) {
        int count = 0;
        for (boolean b : array) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    public static String join(Object array, String joiner) {
        StringBuilder sbuf = new StringBuilder();
        try {
            int n = Array.getLength(array);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sbuf.append(joiner);
                }
                sbuf.append(Array.get(array, i));
            }
            return sbuf.toString();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static double[] add(Object array1, Object array2) {
        int n = Arrays.getNumericArrayLength(array1);
        if (n >= 0 && Arrays.getNumericArrayLength(array2) == n) {
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                out[i] = Array.getDouble(array1, i) + Array.getDouble(array2, i);
            }
            return out;
        }
        return null;
    }

    public static double[] add(Object array, double constant) {
        int n = Arrays.getNumericArrayLength(array);
        if (n >= 0) {
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                out[i] = Array.getDouble(array, i) + constant;
            }
            return out;
        }
        return null;
    }

    public static double[] subtract(Object array1, Object array2) {
        int n = Arrays.getNumericArrayLength(array1);
        if (n >= 0 && Arrays.getNumericArrayLength(array2) == n) {
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                out[i] = Array.getDouble(array1, i) - Array.getDouble(array2, i);
            }
            return out;
        }
        return null;
    }

    public static double[] multiply(Object array1, Object array2) {
        int n = Arrays.getNumericArrayLength(array1);
        if (n >= 0 && Arrays.getNumericArrayLength(array2) == n) {
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                out[i] = Array.getDouble(array1, i) * Array.getDouble(array2, i);
            }
            return out;
        }
        return null;
    }

    public static double[] multiply(Object array, double constant) {
        int n = Arrays.getNumericArrayLength(array);
        if (n >= 0) {
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                out[i] = Array.getDouble(array, i) * constant;
            }
            return out;
        }
        return null;
    }

    public static double[] divide(Object array1, Object array2) {
        int n = Arrays.getNumericArrayLength(array1);
        if (n >= 0 && Arrays.getNumericArrayLength(array2) == n) {
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                out[i] = Array.getDouble(array1, i) / Array.getDouble(array2, i);
            }
            return out;
        }
        return null;
    }

    public static double[] reciprocal(Object array) {
        int n = Arrays.getNumericArrayLength(array);
        if (n >= 0) {
            double[] out = new double[n];
            for (int i = 0; i < n; ++i) {
                out[i] = 1.0 / Array.getDouble(array, i);
            }
            return out;
        }
        return null;
    }

    public static double[] condition(boolean[] flagArray, double trueValue, double falseValue) {
        int n = flagArray.length;
        double[] out = new double[n];
        for (int i = 0; i < n; ++i) {
            out[i] = flagArray[i] ? trueValue : falseValue;
        }
        return out;
    }

    public static double[] array(double ... values) {
        return values;
    }

    public static int[] intArray(int ... values) {
        return values;
    }

    public static String[] stringArray(String ... values) {
        return values;
    }

    private static int getNumericArrayLength(Object array) {
        return array instanceof byte[] || array instanceof short[] || array instanceof int[] || array instanceof long[] || array instanceof float[] || array instanceof double[] ? Array.getLength(array) : -1;
    }
}

