/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.pal.AngleDR;
import uk.ac.starlink.pal.Pal;

public class CoordsRadians {
    private static Pattern dmsPattern = CoordsRadians.getSexPattern("[:d ]", "[:m' ]", "[s\"]?");
    private static Pattern hmsPattern = CoordsRadians.getSexPattern("[:h ]", "[:m' ]", "[s\"]?");
    public static final double DEGREE_RADIANS = Math.PI / 180;
    public static final double HOUR_RADIANS = 0.2617993877991494;
    public static final double ARC_MINUTE_RADIANS = 2.908882086657216E-4;
    public static final double ARC_SECOND_RADIANS = 4.84813681109536E-6;

    private CoordsRadians() {
    }

    public static String radiansToDms(double rad) {
        return CoordsRadians.radiansToDms(rad, 0);
    }

    public static String radiansToDms(double rad, int secFig) {
        if (Double.isNaN(rad)) {
            return null;
        }
        double degrees = CoordsRadians.radiansToDegrees(rad);
        int sign = degrees >= 0.0 ? 1 : -1;
        double round = 1.388888888888889E-4 * (double)sign;
        for (int i = 0; i < secFig; ++i) {
            round *= 0.1;
        }
        degrees += round;
        int d = (int)(degrees *= (double)sign);
        double minutes = (degrees - (double)d) * 60.0;
        int m = (int)minutes;
        double seconds = (minutes - (double)m) * 60.0;
        return CoordsRadians.formatDms(sign == 1, d, m, seconds, secFig);
    }

    public static String radiansToHms(double rad) {
        return CoordsRadians.radiansToHms(rad, 0);
    }

    public static String radiansToHms(double rad, int secFig) {
        if (Double.isNaN(rad)) {
            return null;
        }
        while (rad < 0.0) {
            rad += Math.PI * 2;
        }
        double degrees = CoordsRadians.radiansToDegrees(rad);
        int sign = degrees >= 0.0 ? 1 : -1;
        double hours = degrees / 15.0;
        double round = 1.388888888888889E-4 * (double)sign;
        for (int i = 0; i < secFig; ++i) {
            round *= 0.1;
        }
        hours += round;
        int h = (int)(hours *= (double)sign);
        double minutes = (hours - (double)h) * 60.0;
        int m = (int)minutes;
        double seconds = (minutes - (double)m) * 60.0;
        return CoordsRadians.formatHms(sign == 1, h, m, seconds, secFig);
    }

    public static double dmsToRadians(String dms) {
        double sec;
        Matcher matcher = dmsPattern.matcher(dms);
        if (!matcher.matches()) {
            throw new NumberFormatException(dms + " not in deg:min:sec format");
        }
        boolean positive = !"-".equals(matcher.group(1));
        int hour = Integer.parseInt(matcher.group(2));
        int min = Integer.parseInt(matcher.group(3));
        double d = sec = matcher.group(4) == null ? 0.0 : Double.parseDouble(matcher.group(4));
        if (min < 0 || min > 60) {
            return Double.NaN;
        }
        if (sec < 0.0 || sec > 60.0) {
            return Double.NaN;
        }
        return CoordsRadians.dmsToRadians(positive, hour, min, sec);
    }

    public static double hmsToRadians(String hms) {
        double sec;
        Matcher matcher = hmsPattern.matcher(hms);
        if (!matcher.matches()) {
            throw new NumberFormatException(hms + " not in hour:min:sec format");
        }
        boolean positive = !"-".equals(matcher.group(1));
        int hour = Integer.parseInt(matcher.group(2));
        int min = Integer.parseInt(matcher.group(3));
        double d = sec = matcher.group(4) == null ? 0.0 : Double.parseDouble(matcher.group(4));
        if (min < 0 || min > 60) {
            return Double.NaN;
        }
        if (sec < 0.0 || sec > 60.0) {
            return Double.NaN;
        }
        return CoordsRadians.hmsToRadians(positive, hour, min, sec);
    }

    public static double dmsToRadians(double deg, double min, double sec) {
        if (min < 0.0 || min > 60.0 || (double)((int)min) != min) {
            throw new IllegalArgumentException("Minutes argument " + min + " must be an integer between 0 and 59");
        }
        if (sec < 0.0 || sec > 60.0) {
            throw new IllegalArgumentException("Seconds argument " + sec + " must be between 0 and 60");
        }
        return CoordsRadians.dmsToRadians(!CoordsRadians.isNegative(deg), (int)Math.abs(deg), (int)min, sec);
    }

    public static double hmsToRadians(double hour, double min, double sec) {
        if (min < 0.0 || min > 60.0 || (double)((int)min) != min) {
            throw new IllegalArgumentException("Minutes argument " + min + " must be an integer between 0 and 59");
        }
        if (sec < 0.0 || sec > 60.0) {
            throw new IllegalArgumentException("Seconds argument " + sec + " must be between 0 and 60");
        }
        return CoordsRadians.hmsToRadians(!CoordsRadians.isNegative(hour), (int)Math.abs(hour), (int)min, sec);
    }

    public static double skyDistanceRadians(double ra1, double dec1, double ra2, double dec2) {
        return CoordsRadians.haversineSeparationFormula(ra1, dec1, ra2, dec2);
    }

    public static double posAngRadians(double ra1, double dec1, double ra2, double dec2) {
        double dra = ra2 - ra1;
        double y = Math.sin(dra) * Math.cos(dec2);
        double x = Math.sin(dec2) * Math.cos(dec1) - Math.cos(dec2) * Math.sin(dec1) * Math.cos(dra);
        return x == 0.0 && y == 0.0 ? 0.0 : Math.atan2(y, x);
    }

    public static double hoursToRadians(double hours) {
        return CoordsRadians.degreesToRadians(hours * 15.0);
    }

    public static double degreesToRadians(double deg) {
        return Math.toRadians(deg);
    }

    public static double radiansToDegrees(double rad) {
        return Math.toDegrees(rad);
    }

    public static double raFK4toFK5radians(double raFK4, double decFK4) {
        return CoordsRadians.raFK4toFK5Radians(raFK4, decFK4, 1950.0);
    }

    public static double decFK4toFK5radians(double raFK4, double decFK4) {
        return CoordsRadians.decFK4toFK5Radians(raFK4, decFK4, 1950.0);
    }

    public static double raFK5toFK4radians(double raFK5, double decFK5) {
        return CoordsRadians.raFK5toFK4Radians(raFK5, decFK5, 1950.0);
    }

    public static double decFK5toFK4radians(double raFK5, double decFK5) {
        return CoordsRadians.decFK5toFK4Radians(raFK5, decFK5, 1950.0);
    }

    public static double raFK4toFK5Radians(double raFK4, double decFK4, double bepoch) {
        return new Pal().Fk45z(new AngleDR(raFK4, decFK4), bepoch).getAlpha();
    }

    public static double decFK4toFK5Radians(double raFK4, double decFK4, double bepoch) {
        return new Pal().Fk45z(new AngleDR(raFK4, decFK4), bepoch).getDelta();
    }

    public static double raFK5toFK4Radians(double raFK5, double decFK5, double bepoch) {
        return new Pal().Fk54z(new AngleDR(raFK5, decFK5), bepoch).getAngle().getAlpha();
    }

    public static double decFK5toFK4Radians(double raFK5, double decFK5, double bepoch) {
        return new Pal().Fk54z(new AngleDR(raFK5, decFK5), bepoch).getAngle().getDelta();
    }

    private static boolean isNegative(double value) {
        return (Double.doubleToLongBits(value) & Long.MIN_VALUE) != 0L;
    }

    private static double dmsToRadians(boolean positive, int deg, int min, double sec) {
        assert (deg >= 0);
        assert (min >= 0);
        assert (sec >= 0.0);
        double radians = CoordsRadians.degreesToRadians((double)deg + ((double)min + sec / 60.0) / 60.0);
        return positive ? radians : -1.0 * radians;
    }

    private static double hmsToRadians(boolean positive, int hour, int min, double sec) {
        return 15.0 * CoordsRadians.dmsToRadians(positive, hour, min, sec);
    }

    private static String formatDms(boolean positive, int deg, int min, double sec, int dp) {
        assert (deg >= 0);
        assert (min >= 0);
        return SexFormat.getDmsFormat(dp).format(positive, deg, min, sec);
    }

    private static String formatHms(boolean positive, int hour, int min, double sec, int dp) {
        return SexFormat.getHmsFormat(dp).format(positive, hour, min, sec);
    }

    private static Pattern getSexPattern(String trail1, String trail2, String trail3) {
        return Pattern.compile(" *([+\\-]?) *([0-9]+) *" + trail1 + " *([0-9]+) *" + "(?:" + trail2 + " *([0-9]+\\.?[0-9]*) *" + trail3 + ")?" + " *");
    }

    private static double haversineSeparationFormula(double ra1, double dec1, double ra2, double dec2) {
        double sr2;
        double sd2 = Math.sin(0.5 * (dec2 - dec1));
        double a = sd2 * sd2 + (sr2 = Math.sin(0.5 * (ra2 - ra1))) * sr2 * Math.cos(dec1) * Math.cos(dec2);
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        return a < 1.0 ? 2.0 * Math.asin(Math.sqrt(a)) : Math.PI;
    }

    private static class SexFormat {
        private boolean useSign;
        private int sf1;
        private int dp3;
        private char[] buf;
        private static SexFormat[] hmsFormats = new SexFormat[0];
        private static SexFormat[] dmsFormats = new SexFormat[0];
        private static char[] digits0 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static char[] digitsLeading = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static char[] digitsMinus = new char[]{'-', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

        private SexFormat(boolean useSign, int dp3) {
            this.useSign = useSign;
            this.dp3 = dp3;
            if (dp3 < 0) {
                throw new IllegalArgumentException();
            }
            this.buf = new char[(useSign ? 1 : 0) + 2 + 6 + (dp3 > 0 ? 1 : 0) + dp3];
        }

        public String format(boolean positive, int f1, int f2, double f3) {
            if (f1 < 0 || f2 < 0 || f3 < 0.0) {
                throw new IllegalArgumentException("Can't be negative");
            }
            if (Double.isNaN(f3)) {
                return null;
            }
            int f3i = (int)f3;
            int pos = 0;
            if (this.useSign) {
                int sgnChar = positive ? 43 : 45;
                this.buf[pos++] = sgnChar;
            }
            this.buf[pos++] = digitsLeading[f1 / 10 % 10];
            this.buf[pos++] = digits0[f1 % 10];
            this.buf[pos++] = 58;
            this.buf[pos++] = digits0[f2 / 10 % 10];
            this.buf[pos++] = digits0[f2 % 10];
            this.buf[pos++] = 58;
            this.buf[pos++] = digits0[f3i / 10 % 10];
            this.buf[pos++] = digits0[f3i % 10];
            if (this.dp3 > 0) {
                this.buf[pos++] = 46;
                for (int i = 0; i < this.dp3; ++i) {
                    this.buf[pos++] = digits0[(int)(f3 *= 10.0) % 10];
                }
            }
            return new String(this.buf);
        }

        public static SexFormat getHmsFormat(int dp) {
            int nf = hmsFormats.length;
            if (dp >= nf) {
                hmsFormats = new SexFormat[dp + 1];
                for (int i = 0; i <= dp; ++i) {
                    SexFormat.hmsFormats[i] = new SexFormat(false, i);
                }
            }
            return hmsFormats[dp];
        }

        public static SexFormat getDmsFormat(int dp) {
            int nf = dmsFormats.length;
            if (dp >= nf) {
                dmsFormats = new SexFormat[dp + 1];
                for (int i = 0; i <= dp; ++i) {
                    SexFormat.dmsFormats[i] = new SexFormat(true, i);
                }
            }
            return dmsFormats[dp];
        }
    }
}

